/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.security.CertificateUtil;
import com.itextpdf.text.pdf.security.CrlClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrlClientImp
implements CrlClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrlClientImp.class);

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) {
        try {
            int n;
            if (url == null) {
                if (checkCert == null) {
                    return null;
                }
                url = CertificateUtil.getCRLURL(checkCert);
            }
            if (url == null) {
                return null;
            }
            URL urlt = new URL(url);
            HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
            if (con.getResponseCode() / 100 != 2) {
                throw new IOException(MessageLocalization.getComposedMessage("invalid.http.response.1", con.getResponseCode()));
            }
            InputStream inp = (InputStream)con.getContent();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((n = inp.read(buf, 0, buf.length)) > 0) {
                bout.write(buf, 0, n);
            }
            inp.close();
            ArrayList<byte[]> ar = new ArrayList<byte[]>();
            ar.add(bout.toByteArray());
            return ar;
        }
        catch (Exception ex) {
            if (LOGGER.isLogging(Level.ERROR)) {
                LOGGER.error("CrlClientImp", ex);
            }
            return null;
        }
    }
}

