/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.clipper;

import com.itextpdf.kernel.pdf.canvas.parser.clipper.Point;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Path
extends ArrayList<Point.LongPoint> {
    private static final long serialVersionUID = -7120161578077546673L;

    private static OutPt excludeOp(OutPt op) {
        OutPt result = op.prev;
        result.next = op.next;
        op.next.prev = result;
        result.idx = 0;
        return result;
    }

    public Path() {
    }

    public Path(Point.LongPoint[] points) {
        this();
        for (Point.LongPoint point : points) {
            this.add(point);
        }
    }

    public Path(int cnt) {
        super(cnt);
    }

    public Path(Collection<? extends Point.LongPoint> c) {
        super(c);
    }

    public double area() {
        int cnt = this.size();
        if (cnt < 3) {
            return 0.0;
        }
        double a = 0.0;
        int i = 0;
        int j = cnt - 1;
        while (i < cnt) {
            a += ((double)((Point.LongPoint)this.get(j)).getX() + (double)((Point.LongPoint)this.get(i)).getX()) * ((double)((Point.LongPoint)this.get(j)).getY() - (double)((Point.LongPoint)this.get(i)).getY());
            j = i++;
        }
        return -a * 0.5;
    }

    public Path cleanPolygon() {
        return this.cleanPolygon(1.415);
    }

    public Path cleanPolygon(double distance) {
        int i;
        int cnt = this.size();
        if (cnt == 0) {
            return new Path();
        }
        OutPt[] outPts = new OutPt[cnt];
        for (i = 0; i < cnt; ++i) {
            outPts[i] = new OutPt();
        }
        for (i = 0; i < cnt; ++i) {
            outPts[i].pt = (Point.LongPoint)this.get(i);
            outPts[i].next = outPts[(i + 1) % cnt];
            outPts[i].next.prev = outPts[i];
            outPts[i].idx = 0;
        }
        double distSqrd = distance * distance;
        OutPt op = outPts[0];
        while (op.idx == 0 && op.next != op.prev) {
            if (Point.arePointsClose(op.pt, op.prev.pt, distSqrd)) {
                op = Path.excludeOp(op);
                --cnt;
                continue;
            }
            if (Point.arePointsClose(op.prev.pt, op.next.pt, distSqrd)) {
                Path.excludeOp(op.next);
                op = Path.excludeOp(op);
                cnt -= 2;
                continue;
            }
            if (Point.slopesNearCollinear(op.prev.pt, op.pt, op.next.pt, distSqrd)) {
                op = Path.excludeOp(op);
                --cnt;
                continue;
            }
            op.idx = 1;
            op = op.next;
        }
        if (cnt < 3) {
            cnt = 0;
        }
        Path result = new Path(cnt);
        for (int i2 = 0; i2 < cnt; ++i2) {
            result.add(op.pt);
            op = op.next;
        }
        outPts = null;
        return result;
    }

    public int isPointInPolygon(Point.LongPoint pt) {
        int result = 0;
        int cnt = this.size();
        if (cnt < 3) {
            return 0;
        }
        Point.LongPoint ip = (Point.LongPoint)this.get(0);
        for (int i = 1; i <= cnt; ++i) {
            Point.LongPoint ipNext;
            Point.LongPoint longPoint = ipNext = i == cnt ? (Point.LongPoint)this.get(0) : (Point.LongPoint)this.get(i);
            if (ipNext.getY() == pt.getY() && (ipNext.getX() == pt.getX() || ip.getY() == pt.getY() && ipNext.getX() > pt.getX() == ip.getX() < pt.getX())) {
                return -1;
            }
            if (ip.getY() < pt.getY() != ipNext.getY() < pt.getY()) {
                double d;
                if (ip.getX() >= pt.getX()) {
                    if (ipNext.getX() > pt.getX()) {
                        result = 1 - result;
                    } else {
                        d = (double)(ip.getX() - pt.getX()) * (double)(ipNext.getY() - pt.getY()) - (double)(ipNext.getX() - pt.getX()) * (double)(ip.getY() - pt.getY());
                        if (d == 0.0) {
                            return -1;
                        }
                        if (d > 0.0 == ipNext.getY() > ip.getY()) {
                            result = 1 - result;
                        }
                    }
                } else if (ipNext.getX() > pt.getX()) {
                    d = (double)(ip.getX() - pt.getX()) * (double)(ipNext.getY() - pt.getY()) - (double)(ipNext.getX() - pt.getX()) * (double)(ip.getY() - pt.getY());
                    if (d == 0.0) {
                        return -1;
                    }
                    if (d > 0.0 == ipNext.getY() > ip.getY()) {
                        result = 1 - result;
                    }
                }
            }
            ip = ipNext;
        }
        return result;
    }

    public boolean orientation() {
        return this.area() >= 0.0;
    }

    public void reverse() {
        Collections.reverse(this);
    }

    public Path TranslatePath(Point.LongPoint delta) {
        Path outPath = new Path(this.size());
        for (int i = 0; i < this.size(); ++i) {
            outPath.add(new Point.LongPoint(((Point.LongPoint)this.get(i)).getX() + delta.getX(), ((Point.LongPoint)this.get(i)).getY() + delta.getY()));
        }
        return outPath;
    }

    static class OutRec {
        int Idx;
        boolean isHole;
        boolean isOpen;
        OutRec firstLeft;
        protected OutPt pts;
        OutPt bottomPt;
        PolyNode polyNode;

        OutRec() {
        }

        public double area() {
            OutPt op = this.pts;
            if (op == null) {
                return 0.0;
            }
            double a = 0.0;
            do {
                a += (double)(op.prev.getPt().getX() + op.getPt().getX()) * (double)(op.prev.getPt().getY() - op.getPt().getY());
            } while ((op = op.next) != this.pts);
            return a * 0.5;
        }

        public void fixHoleLinkage() {
            if (this.firstLeft == null || this.isHole != this.firstLeft.isHole && this.firstLeft.pts != null) {
                return;
            }
            OutRec orfl = this.firstLeft;
            while (orfl != null && (orfl.isHole == this.isHole || orfl.pts == null)) {
                orfl = orfl.firstLeft;
            }
            this.firstLeft = orfl;
        }

        public OutPt getPoints() {
            return this.pts;
        }

        public void setPoints(OutPt pts) {
            this.pts = pts;
        }
    }

    protected static class Maxima {
        protected long X;
        protected Maxima Next;
        protected Maxima Prev;

        protected Maxima() {
        }
    }

    static class OutPt {
        int idx;
        protected Point.LongPoint pt;
        OutPt next;
        OutPt prev;

        OutPt() {
        }

        public static OutRec getLowerMostRec(OutRec outRec1, OutRec outRec2) {
            if (outRec1.bottomPt == null) {
                outRec1.bottomPt = outRec1.pts.getBottomPt();
            }
            if (outRec2.bottomPt == null) {
                outRec2.bottomPt = outRec2.pts.getBottomPt();
            }
            OutPt bPt1 = outRec1.bottomPt;
            OutPt bPt2 = outRec2.bottomPt;
            if (bPt1.getPt().getY() > bPt2.getPt().getY()) {
                return outRec1;
            }
            if (bPt1.getPt().getY() < bPt2.getPt().getY()) {
                return outRec2;
            }
            if (bPt1.getPt().getX() < bPt2.getPt().getX()) {
                return outRec1;
            }
            if (bPt1.getPt().getX() > bPt2.getPt().getX()) {
                return outRec2;
            }
            if (bPt1.next == bPt1) {
                return outRec2;
            }
            if (bPt2.next == bPt2) {
                return outRec1;
            }
            if (OutPt.isFirstBottomPt(bPt1, bPt2)) {
                return outRec1;
            }
            return outRec2;
        }

        private static boolean isFirstBottomPt(OutPt btmPt1, OutPt btmPt2) {
            OutPt p = btmPt1.prev;
            while (p.getPt().equals(btmPt1.getPt()) && !p.equals(btmPt1)) {
                p = p.prev;
            }
            double dx1p = Math.abs(Point.LongPoint.getDeltaX(btmPt1.getPt(), p.getPt()));
            p = btmPt1.next;
            while (p.getPt().equals(btmPt1.getPt()) && !p.equals(btmPt1)) {
                p = p.next;
            }
            double dx1n = Math.abs(Point.LongPoint.getDeltaX(btmPt1.getPt(), p.getPt()));
            p = btmPt2.prev;
            while (p.getPt().equals(btmPt2.getPt()) && !p.equals(btmPt2)) {
                p = p.prev;
            }
            double dx2p = Math.abs(Point.LongPoint.getDeltaX(btmPt2.getPt(), p.getPt()));
            p = btmPt2.next;
            while (p.getPt().equals(btmPt2.getPt()) && p.equals(btmPt2)) {
                p = p.next;
            }
            double dx2n = Math.abs(Point.LongPoint.getDeltaX(btmPt2.getPt(), p.getPt()));
            return dx1p >= dx2p && dx1p >= dx2n || dx1n >= dx2p && dx1n >= dx2n;
        }

        public OutPt duplicate(boolean InsertAfter) {
            OutPt result = new OutPt();
            result.setPt(new Point.LongPoint(this.getPt()));
            result.idx = this.idx;
            if (InsertAfter) {
                result.next = this.next;
                result.prev = this;
                this.next.prev = result;
                this.next = result;
            } else {
                result.prev = this.prev;
                result.next = this;
                this.prev.next = result;
                this.prev = result;
            }
            return result;
        }

        OutPt getBottomPt() {
            OutPt dups = null;
            OutPt p = this.next;
            OutPt pp = this;
            while (p != pp) {
                if (p.getPt().getY() > pp.getPt().getY()) {
                    pp = p;
                    dups = null;
                } else if (p.getPt().getY() == pp.getPt().getY() && p.getPt().getX() <= pp.getPt().getX()) {
                    if (p.getPt().getX() < pp.getPt().getX()) {
                        dups = null;
                        pp = p;
                    } else if (p.next != pp && p.prev != pp) {
                        dups = p;
                    }
                }
                p = p.next;
            }
            if (dups != null) {
                while (dups != p) {
                    if (!OutPt.isFirstBottomPt(p, dups)) {
                        pp = dups;
                    }
                    dups = dups.next;
                    while (!dups.getPt().equals(pp.getPt())) {
                        dups = dups.next;
                    }
                }
            }
            return pp;
        }

        public int getPointCount() {
            int result = 0;
            OutPt p = this;
            do {
                ++result;
            } while ((p = p.next) != this && p != null);
            return result;
        }

        public Point.LongPoint getPt() {
            return this.pt;
        }

        public void reversePolyPtLinks() {
            OutPt pp2;
            OutPt pp1 = this;
            do {
                pp2 = pp1.next;
                pp1.next = pp1.prev;
                pp1.prev = pp2;
            } while ((pp1 = pp2) != this);
        }

        public void setPt(Point.LongPoint pt) {
            this.pt = pt;
        }
    }

    static class Join {
        OutPt outPt1;
        OutPt outPt2;
        private Point.LongPoint offPt;

        Join() {
        }

        public Point.LongPoint getOffPt() {
            return this.offPt;
        }

        public void setOffPt(Point.LongPoint offPt) {
            this.offPt = offPt;
        }
    }
}

