/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagging.StandardNamespaces;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;

class RoleMappingResolver
implements IRoleMappingResolver {
    private static final long serialVersionUID = -8911597456631422956L;
    private PdfName currRole;
    private PdfDictionary roleMap;

    RoleMappingResolver(String role, PdfDocument document) {
        this.currRole = PdfStructTreeRoot.convertRoleToPdfName(role);
        this.roleMap = document.getStructTreeRoot().getRoleMap();
    }

    @Override
    public String getRole() {
        return this.currRole.getValue();
    }

    @Override
    public PdfNamespace getNamespace() {
        return null;
    }

    @Override
    public boolean currentRoleIsStandard() {
        return StandardNamespaces.roleBelongsToStandardNamespace(this.currRole.getValue(), "http://iso.org/pdf/ssn");
    }

    @Override
    public boolean currentRoleShallBeMappedToStandard() {
        return !this.currentRoleIsStandard();
    }

    @Override
    public boolean resolveNextMapping() {
        PdfName mappedRole = this.roleMap.getAsName(this.currRole);
        if (mappedRole == null) {
            return false;
        }
        this.currRole = mappedRole;
        return true;
    }
}

