/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.geom;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.HashCode;

public class Point
implements Cloneable {
    public double x;
    public double y;

    public Point() {
        this.setLocation(0, 0);
    }

    public Point(int x, int y) {
        this.setLocation(x, y);
    }

    public Point(double x, double y) {
        this.setLocation(x, y);
    }

    public Point(Point p) {
        this.setLocation(p.x, p.y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public String toString() {
        return MessageFormatUtil.format((String)"Point: [x={0},y={1}]", (Object[])new Object[]{this.x, this.y});
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.setLocation((double)x, (double)y);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void move(double x, double y) {
        this.setLocation(x, y);
    }

    public void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.getX());
        hash.append(this.getY());
        return hash.hashCode();
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2;
    }

    public double distanceSq(double px, double py) {
        return Point.distanceSq(this.getX(), this.getY(), px, py);
    }

    public double distanceSq(Point p) {
        return Point.distanceSq(this.getX(), this.getY(), p.getX(), p.getY());
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point.distanceSq(x1, y1, x2, y2));
    }

    public double distance(double px, double py) {
        return Math.sqrt(this.distanceSq(px, py));
    }

    public double distance(Point p) {
        return Math.sqrt(this.distanceSq(p));
    }

    public Object clone() {
        return new Point(this.x, this.y);
    }
}

