/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.kernel.crypto.AESGCMCipher;
import com.itextpdf.kernel.crypto.IDecryptor;

public class AesGcmDecryptor
implements IDecryptor {
    private AESGCMCipher cipher;
    private final byte[] key;
    private boolean initiated;
    private final byte[] iv = new byte[12];
    private int ivptr;

    public AesGcmDecryptor(byte[] key, int off, int len) {
        this.key = new byte[len];
        System.arraycopy(key, off, this.key, 0, len);
    }

    @Override
    public byte[] update(byte[] b, int off, int len) {
        if (!this.initiated) {
            int left = Math.min(this.iv.length - this.ivptr, len);
            System.arraycopy(b, off, this.iv, this.ivptr, left);
            off += left;
            len -= left;
            this.ivptr += left;
            if (this.ivptr == this.iv.length) {
                this.cipher = new AESGCMCipher(false, this.key, this.iv);
                this.initiated = true;
            }
            if (len == 0) {
                return null;
            }
        }
        return this.cipher.update(b, off, len);
    }

    @Override
    public byte[] finish() {
        if (this.cipher != null) {
            return this.cipher.doFinal();
        }
        return null;
    }
}

