/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BackgroundImage;
import com.itextpdf.layout.property.ClearPropertyValue;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.Property;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
implements IRenderer {
    public static final float EPS = 1.0E-4f;
    public static final float INF = 1000000.0f;
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected boolean isLastRendererForModelElement = true;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea != null ? other.occupiedArea.clone() : null;
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        Integer positioning = (Integer)renderer.getProperty(52);
        if (positioning == null || positioning == 2 || positioning == 1) {
            this.childRenderers.add(renderer);
        } else if (positioning == 4) {
            AbstractRenderer root = this;
            while (root.parent instanceof AbstractRenderer) {
                root = (AbstractRenderer)root.parent;
            }
            if (root == this) {
                this.positionedRenderers.add(renderer);
            } else {
                root.addChild(renderer);
            }
        } else if (positioning == 3) {
            IRenderer parent;
            AbstractRenderer positionedParent = this;
            boolean noPositionInfo = AbstractRenderer.noAbsolutePositionInfo(renderer);
            while (!positionedParent.isPositioned() && !noPositionInfo && (parent = positionedParent.parent) instanceof AbstractRenderer) {
                positionedParent = (AbstractRenderer)parent;
            }
            if (positionedParent == this) {
                this.positionedRenderers.add(renderer);
            } else {
                positionedParent.addChild(renderer);
            }
        }
        if (renderer instanceof AbstractRenderer && !((AbstractRenderer)renderer).isPositioned() && ((AbstractRenderer)renderer).positionedRenderers.size() > 0) {
            int pos = 0;
            List<IRenderer> childPositionedRenderers = ((AbstractRenderer)renderer).positionedRenderers;
            while (pos < childPositionedRenderers.size()) {
                if (AbstractRenderer.noAbsolutePositionInfo(childPositionedRenderers.get(pos))) {
                    ++pos;
                    continue;
                }
                this.positionedRenderers.add(childPositionedRenderers.get(pos));
                childPositionedRenderers.remove(pos);
            }
        }
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    public boolean hasOwnOrModelProperty(int property) {
        return this.properties.containsKey(property) || null != this.getModelElement() && this.getModelElement().hasProperty(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        return null;
    }

    public PdfFont getPropertyAsFont(int property) {
        return (PdfFont)this.getProperty(property);
    }

    public Color getPropertyAsColor(int property) {
        return (Color)this.getProperty(property);
    }

    public TransparentColor getPropertyAsTransparentColor(int property) {
        return (TransparentColor)this.getProperty(property);
    }

    public Float getPropertyAsFloat(int property) {
        Number value = (Number)this.getProperty(property);
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    public Float getPropertyAsFloat(int property, Float defaultValue) {
        Number value = this.getProperty(property, defaultValue);
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    public Integer getPropertyAsInteger(int property) {
        Number value = (Number)this.getProperty(property);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestinationsAndAnnotation(drawContext);
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        this.endElementOpacityApplying(drawContext);
        if (relativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.flushed = true;
    }

    protected void beginElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            PdfExtGState extGState = new PdfExtGState();
            extGState.setStrokeOpacity(opacity.floatValue()).setFillOpacity(opacity.floatValue());
            drawContext.getCanvas().saveState().setExtGState(extGState);
        }
    }

    protected void endElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            drawContext.getCanvas().restoreState();
        }
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        BackgroundImage backgroundImage = (BackgroundImage)this.getProperty(90);
        if (background != null || backgroundImage != null) {
            Rectangle backgroundArea;
            boolean isTagged;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            if (isTagged) {
                drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
            }
            if ((backgroundArea = this.applyMargins(bBox, false)).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background"));
                return;
            }
            if (background != null) {
                TransparentColor backgroundColor = new TransparentColor(background.getColor(), background.getOpacity());
                drawContext.getCanvas().saveState().setFillColor(backgroundColor.getColor());
                backgroundColor.applyFillTransparency(drawContext.getCanvas());
                drawContext.getCanvas().rectangle((double)(backgroundArea.getX() - background.getExtraLeft()), (double)(backgroundArea.getY() - background.getExtraBottom()), (double)(backgroundArea.getWidth() + background.getExtraLeft() + background.getExtraRight()), (double)(backgroundArea.getHeight() + background.getExtraTop() + background.getExtraBottom())).fill().restoreState();
            }
            if (backgroundImage != null && backgroundImage.getImage() != null) {
                this.applyBorderBox(backgroundArea, false);
                Rectangle imageRectangle = new Rectangle(backgroundArea.getX(), backgroundArea.getTop() - backgroundImage.getImage().getHeight(), backgroundImage.getImage().getWidth(), backgroundImage.getImage().getHeight());
                if (imageRectangle.getWidth() <= 0.0f || imageRectangle.getHeight() <= 0.0f) {
                    Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                    logger.error(MessageFormat.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background-image"));
                    return;
                }
                this.applyBorderBox(backgroundArea, true);
                drawContext.getCanvas().saveState().rectangle(backgroundArea).clip().newPath();
                float initialX = backgroundImage.isRepeatX() ? imageRectangle.getX() - imageRectangle.getWidth() : imageRectangle.getX();
                float initialY = backgroundImage.isRepeatY() ? imageRectangle.getTop() : imageRectangle.getY();
                imageRectangle.setY(initialY);
                do {
                    imageRectangle.setX(initialX);
                    do {
                        drawContext.getCanvas().addXObject((PdfXObject)backgroundImage.getImage(), imageRectangle);
                        imageRectangle.moveRight(imageRectangle.getWidth());
                    } while (backgroundImage.isRepeatX() && imageRectangle.getLeft() < backgroundArea.getRight());
                    imageRectangle.moveDown(imageRectangle.getHeight());
                } while (backgroundImage.isRepeatY() && imageRectangle.getTop() > backgroundArea.getBottom());
                drawContext.getCanvas().restoreState();
            }
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    public void drawChildren(DrawContext drawContext) {
        ArrayList<IRenderer> waitingRenderers = new ArrayList<IRenderer>();
        for (IRenderer child : this.childRenderers) {
            if (child.hasProperty(99)) {
                waitingRenderers.add(child);
                continue;
            }
            child.draw(drawContext);
        }
        for (IRenderer waitingRenderer : waitingRenderers) {
            waitingRenderer.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() < 0.0f || bBox.getHeight() < 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormat.format("The {0} rectangle has negative size. It will not be displayed.", "border"));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            }
            if (borders[0] != null) {
                borders[0].draw(canvas, x1, y2, x2, y2, Border.Side.TOP, leftWidth, rightWidth);
            }
            if (borders[1] != null) {
                borders[1].draw(canvas, x2, y2, x2, y1, Border.Side.RIGHT, topWidth, bottomWidth);
            }
            if (borders[2] != null) {
                borders[2].draw(canvas, x2, y1, x1, y1, Border.Side.BOTTOM, rightWidth, leftWidth);
            }
            if (borders[3] != null) {
                borders[3].draw(canvas, x1, y1, x1, y2, Border.Side.LEFT, bottomWidth, topWidth);
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    public IRenderer getParent() {
        return this.parent;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
        for (IRenderer childRenderer : this.positionedRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    protected void applyDestinationsAndAnnotation(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        this.applyLinkAnnotation(drawContext.getDocument());
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        return this.retrieveUnitValue(parentBoxWidth, 77);
    }

    protected Float retrieveHeight() {
        return (Float)this.getProperty(27);
    }

    protected Float retrieveMaxHeight() {
        return (Float)this.getProperty(84);
    }

    protected Float retrieveMinHeight() {
        return (Float)this.getProperty(85);
    }

    protected Float retrieveUnitValue(float basePercentValue, int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        if (value != null) {
            if (value.getUnitType() == 1) {
                return Float.valueOf(value.getValue());
            }
            if (value.getUnitType() == 2) {
                return Float.valueOf(value.getValue() * basePercentValue / 100.0f);
            }
            throw new IllegalStateException("invalid unit type");
        }
        return null;
    }

    protected Map<Integer, Object> getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(Map<Integer, Object> properties) {
        this.properties.putAll(properties);
    }

    protected Float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return null;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return this.applyMargins(rect, this.getMargins(), reverse);
    }

    protected Rectangle applyMargins(Rectangle rect, float[] margins, boolean reverse) {
        return rect.applyMargins(margins[0], margins[1], margins[2], margins[3], reverse);
    }

    protected float[] getMargins() {
        return new float[]{this.getPropertyAsFloat(46).floatValue(), this.getPropertyAsFloat(45).floatValue(), this.getPropertyAsFloat(43).floatValue(), this.getPropertyAsFloat(44).floatValue()};
    }

    protected float[] getPaddings() {
        return new float[]{this.getPropertyAsFloat(50).floatValue(), this.getPropertyAsFloat(49).floatValue(), this.getPropertyAsFloat(47).floatValue(), this.getPropertyAsFloat(48).floatValue()};
    }

    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return this.applyPaddings(rect, this.getPaddings(), reverse);
    }

    protected Rectangle applyPaddings(Rectangle rect, float[] paddings, boolean reverse) {
        return rect.applyMargins(paddings[0], paddings[1], paddings[2], paddings[3], reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        Border[] borders = this.getBorders();
        return this.applyBorderBox(rect, borders, reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
        float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
        float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
        float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
        return rect.applyMargins(topWidth, rightWidth, bottomWidth, leftWidth, reverse);
    }

    protected void applyAbsolutePosition(Rectangle rect) {
        Float top = this.getPropertyAsFloat(73);
        Float bottom = this.getPropertyAsFloat(14);
        Float left = this.getPropertyAsFloat(34);
        Float right = this.getPropertyAsFloat(54);
        float initialHeight = rect.getHeight();
        float initialWidth = rect.getWidth();
        Float minHeight = this.getPropertyAsFloat(85);
        if (minHeight != null && rect.getHeight() < minHeight.floatValue()) {
            float difference = minHeight.floatValue() - rect.getHeight();
            rect.moveDown(difference).setHeight(rect.getHeight() + difference);
        }
        if (top != null) {
            rect.setHeight(rect.getHeight() - top.floatValue());
        }
        if (left != null) {
            rect.setX(rect.getX() + left.floatValue()).setWidth(rect.getWidth() - left.floatValue());
        }
        if (right != null) {
            UnitValue width = (UnitValue)this.getProperty(77);
            if (left == null && width != null) {
                float widthValue = width.isPointValue() ? width.getValue() : width.getValue() * initialWidth;
                float placeLeft = rect.getWidth() - widthValue;
                if (placeLeft > 0.0f) {
                    float computedRight = Math.min(placeLeft, right.floatValue());
                    rect.setX(rect.getX() + rect.getWidth() - computedRight - widthValue);
                }
            } else if (width == null) {
                rect.setWidth(rect.getWidth() - right.floatValue());
            }
        }
        if (bottom != null) {
            if (minHeight != null) {
                rect.setHeight(minHeight.floatValue() + bottom.floatValue());
            } else {
                float minHeightValue = rect.getHeight() - bottom.floatValue();
                Float currentMaxHeight = this.getPropertyAsFloat(84);
                if (currentMaxHeight != null) {
                    minHeightValue = Math.min(minHeightValue, currentMaxHeight.floatValue());
                }
                this.setProperty(85, Float.valueOf(minHeightValue));
            }
        }
    }

    protected void applyRelativePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73, Float.valueOf(0.0f)).floatValue();
        float bottom = this.getPropertyAsFloat(14, Float.valueOf(0.0f)).floatValue();
        float left = this.getPropertyAsFloat(34, Float.valueOf(0.0f)).floatValue();
        float right = this.getPropertyAsFloat(54, Float.valueOf(0.0f)).floatValue();
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
        String destination = (String)this.getProperty(17);
        if (destination != null) {
            PdfArray array = new PdfArray();
            array.add(document.getPage(this.occupiedArea.getPageNumber()).getPdfObject());
            array.add((PdfObject)PdfName.XYZ);
            array.add((PdfObject)new PdfNumber((double)this.occupiedArea.getBBox().getX()));
            array.add((PdfObject)new PdfNumber((double)(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight())));
            array.add((PdfObject)new PdfNumber(0));
            document.addNamedDestination(destination, (PdfObject)array.makeIndirect(document));
            this.deleteProperty(17);
        }
    }

    protected void applyAction(PdfDocument document) {
        PdfAction action = (PdfAction)this.getProperty(1);
        if (action != null) {
            PdfLinkAnnotation link = (PdfLinkAnnotation)this.getProperty(88);
            if (link == null) {
                link = new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f));
                Border border = (Border)this.getProperty(9);
                if (border != null) {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, border.getWidth()}));
                } else {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
                }
                this.setProperty(88, link);
            }
            link.setAction(action);
        }
    }

    protected void applyLinkAnnotation(PdfDocument document) {
        PdfLinkAnnotation linkAnnotation = (PdfLinkAnnotation)this.getProperty(88);
        if (linkAnnotation != null) {
            Rectangle pdfBBox = this.calculateAbsolutePdfBBox();
            linkAnnotation.setRectangle(new PdfArray(pdfBBox));
            PdfPage page = document.getPage(this.occupiedArea.getPageNumber());
            page.addAnnotation((PdfAnnotation)linkAnnotation);
        }
    }

    MinMaxWidth getMinMaxWidth(float availableWidth) {
        return MinMaxWidthUtils.countDefaultMinMaxWidth(this, availableWidth);
    }

    @Deprecated
    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        return this.isNotFittingLayoutArea(layoutArea);
    }

    protected boolean isNotFittingLayoutArea(LayoutArea layoutArea) {
        return !this.isPositioned() && (this.occupiedArea.getBBox().getHeight() > layoutArea.getBBox().getHeight() || this.occupiedArea.getBBox().getWidth() > layoutArea.getBBox().getWidth());
    }

    protected boolean isPositioned() {
        return !this.isStaticLayout();
    }

    protected boolean isFixedLayout() {
        Object positioning = this.getProperty(52);
        return Integer.valueOf(4).equals(positioning);
    }

    protected boolean isStaticLayout() {
        Object positioning = this.getProperty(52);
        return positioning == null || Integer.valueOf(1).equals(positioning);
    }

    protected boolean isRelativePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(2).equals(positioning);
    }

    protected boolean isAbsolutePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(3).equals(positioning);
    }

    protected boolean isKeepTogether() {
        return Boolean.TRUE.equals(this.getPropertyAsBoolean(32));
    }

    @Deprecated
    protected void alignChildHorizontally(IRenderer childRenderer, float availableWidth) {
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT) {
            float freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth();
            switch (horizontalAlignment) {
                case RIGHT: {
                    childRenderer.move(freeSpace, 0.0f);
                    break;
                }
                case CENTER: {
                    childRenderer.move(freeSpace / 2.0f, 0.0f);
                }
            }
        }
    }

    protected void alignChildHorizontally(IRenderer childRenderer, Rectangle currentArea) {
        float availableWidth = currentArea.getWidth();
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT) {
            float freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth();
            FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)childRenderer.getProperty(99));
            if (FloatPropertyValue.RIGHT.equals((Object)floatPropertyValue)) {
                freeSpace = this.calculateFreeSpaceIfFloatPropertyPresent(freeSpace, childRenderer, currentArea);
            }
            switch (horizontalAlignment) {
                case RIGHT: {
                    childRenderer.move(freeSpace, 0.0f);
                    break;
                }
                case CENTER: {
                    childRenderer.move(freeSpace / 2.0f, 0.0f);
                }
            }
        }
    }

    protected Border[] getBorders() {
        Border border = (Border)this.getProperty(9);
        Border topBorder = (Border)this.getProperty(13);
        Border rightBorder = (Border)this.getProperty(12);
        Border bottomBorder = (Border)this.getProperty(10);
        Border leftBorder = (Border)this.getProperty(11);
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        if (!this.hasOwnOrModelProperty(13)) {
            borders[0] = border;
        }
        if (!this.hasOwnOrModelProperty(12)) {
            borders[1] = border;
        }
        if (!this.hasOwnOrModelProperty(10)) {
            borders[2] = border;
        }
        if (!this.hasOwnOrModelProperty(11)) {
            borders[3] = border;
        }
        return borders;
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setProperty(13, border);
                break;
            }
            case 1: {
                this.setProperty(12, border);
                break;
            }
            case 2: {
                this.setProperty(10, border);
                break;
            }
            case 3: {
                this.setProperty(11, border);
            }
        }
        return this;
    }

    protected Rectangle calculateAbsolutePdfBBox() {
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> contentBoxPoints = this.rectangleToPointsList(contentBox);
        AbstractRenderer renderer = this;
        while (renderer.parent != null) {
            Float angle;
            if (renderer instanceof BlockRenderer && (angle = (Float)renderer.getProperty(55)) != null) {
                BlockRenderer blockRenderer = (BlockRenderer)renderer;
                AffineTransform rotationTransform = blockRenderer.createRotationTransformInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            renderer = (AbstractRenderer)renderer.parent;
        }
        return this.calculateBBox(contentBoxPoints);
    }

    protected Rectangle calculateBBox(List<Point> points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point p : points) {
            minX = Math.min(p.getX(), minX);
            minY = Math.min(p.getY(), minY);
            maxX = Math.max(p.getX(), maxX);
            maxY = Math.max(p.getY(), maxY);
        }
        return new Rectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
    }

    protected List<Point> rectangleToPointsList(Rectangle rect) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(Arrays.asList(new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop()), new Point((double)rect.getLeft(), (double)rect.getTop())));
        return points;
    }

    protected List<Point> transformPoints(List<Point> points, AffineTransform transform) {
        for (Point point : points) {
            transform.transform(point, point);
        }
        return points;
    }

    protected float[] calculateShiftToPositionBBoxOfPointsAt(float left, float top, List<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            maxY = Math.max(point.getY(), maxY);
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        return new float[]{dx, dy};
    }

    protected void overrideHeightProperties() {
        Float height = (Float)this.getProperty(27);
        Float maxHeight = (Float)this.getProperty(84);
        Float minHeight = (Float)this.getProperty(85);
        if (null != height) {
            if (null == maxHeight || height.floatValue() < maxHeight.floatValue()) {
                maxHeight = height;
            } else {
                height = maxHeight;
            }
            if (null == minHeight || height.floatValue() > minHeight.floatValue()) {
                minHeight = height;
            }
        }
        if (null != maxHeight && null != minHeight && minHeight.floatValue() > maxHeight.floatValue()) {
            maxHeight = minHeight;
        }
        if (null != maxHeight) {
            this.setProperty(84, maxHeight);
        }
        if (null != minHeight) {
            this.setProperty(85, minHeight);
        }
    }

    void removeUnnecessaryFloatRendererAreas(List<Rectangle> floatRendererAreas) {
        if (!this.hasProperty(99) && !this.parent.hasProperty(99)) {
            for (int i = floatRendererAreas.size() - 1; i >= 0; --i) {
                Rectangle floatRendererArea = floatRendererAreas.get(i);
                if (!(floatRendererArea.getY() >= this.occupiedArea.getBBox().getY())) continue;
                floatRendererAreas.remove(i);
            }
        }
    }

    LayoutArea applyFloatPropertyOnCurrentArea(List<Rectangle> floatRendererAreas, float availableWidth, Float elementWidth) {
        LayoutArea editedArea = this.occupiedArea;
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (floatPropertyValue != null && !FloatPropertyValue.NONE.equals((Object)floatPropertyValue)) {
            if (elementWidth != null) {
                if (elementWidth.floatValue() < this.occupiedArea.getBBox().getWidth()) {
                    for (IRenderer renderer : this.childRenderers) {
                        LayoutArea childArea = renderer.getOccupiedArea();
                        if (childArea == null || !(elementWidth.floatValue() < childArea.getBBox().getWidth())) continue;
                        childArea.getBBox().setWidth(elementWidth.floatValue());
                    }
                }
                this.occupiedArea.getBBox().setWidth(elementWidth.floatValue());
            }
            if (this.occupiedArea.getBBox().getWidth() < availableWidth) {
                editedArea = this.occupiedArea.clone();
                floatRendererAreas.add(this.occupiedArea.getBBox());
                editedArea.getBBox().moveUp(editedArea.getBBox().getHeight());
                editedArea.getBBox().setHeight(0.0f);
            }
        }
        return editedArea;
    }

    void adjustLineAreaAccordingToFloatRenderers(List<Rectangle> floatRendererAreas, Rectangle layoutBox) {
        for (Rectangle floatRendererArea : floatRendererAreas) {
            if (layoutBox.getX() >= floatRendererArea.getX() && layoutBox.getX() < floatRendererArea.getX() + floatRendererArea.getWidth()) {
                layoutBox.moveRight(floatRendererArea.getWidth());
                layoutBox.setWidth(layoutBox.getWidth() - floatRendererArea.getWidth());
                continue;
            }
            if (!(layoutBox.getX() < floatRendererArea.getX()) || !(layoutBox.getX() + layoutBox.getWidth() > floatRendererArea.getX())) continue;
            layoutBox.setWidth(layoutBox.getWidth() - floatRendererArea.getWidth());
        }
    }

    void adjustBlockAreaAccordingToFloatRenderers(List<Rectangle> floatRendererAreas, Rectangle layoutBox, float extremalRightBorder, Float blockWidth, MarginsCollapseHandler marginsCollapseHandler) {
        for (Rectangle floatRenderer : floatRendererAreas) {
            float freeSpace;
            FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
            if (layoutBox.getX() >= floatRenderer.getX() && layoutBox.getX() < floatRenderer.getX() + floatRenderer.getWidth()) {
                layoutBox.moveRight(floatRenderer.getWidth());
                freeSpace = extremalRightBorder - layoutBox.getX() - layoutBox.getWidth();
                if (!(freeSpace < 0.0f)) continue;
                layoutBox.setWidth(layoutBox.getWidth() + freeSpace);
                continue;
            }
            if (!FloatPropertyValue.RIGHT.equals((Object)floatPropertyValue) || !((freeSpace = extremalRightBorder - layoutBox.getX() - layoutBox.getWidth()) < 0.0f)) continue;
            layoutBox.setWidth(layoutBox.getWidth() + freeSpace);
        }
        if (blockWidth != null && blockWidth.floatValue() + layoutBox.getX() > extremalRightBorder) {
            float minFloatY = 2.1474836E9f;
            for (int i = floatRendererAreas.size() - 1; i >= 0; --i) {
                Rectangle floatRendererArea = floatRendererAreas.get(i);
                layoutBox.moveLeft(floatRendererArea.getWidth());
                floatRendererAreas.remove(i);
                if (!(floatRendererArea.getY() < minFloatY)) continue;
                minFloatY = floatRendererArea.getY();
            }
            layoutBox.setWidth(blockWidth.floatValue());
            float topMargin = this.getMargins()[0];
            float topPadding = this.getPaddings()[0];
            minFloatY -= topMargin + topPadding;
            if (minFloatY < 2.1474836E9f) {
                layoutBox.setHeight(minFloatY - layoutBox.getY());
                if (marginsCollapseHandler != null) {
                    marginsCollapseHandler.startMarginsCollapse(layoutBox);
                }
            }
        }
    }

    float calculateClearHeightCorrection(List<Rectangle> floatRendererAreas, Rectangle parentBBox) {
        ClearPropertyValue clearPropertyValue = (ClearPropertyValue)((Object)this.getProperty(100));
        float clearHeightCorrection = 0.0f;
        if (floatRendererAreas.size() > 0 && clearPropertyValue != null) {
            float maxFloatHeight = 0.0f;
            Rectangle theLowestFloatRectangle = null;
            float criticalPoint = parentBBox.getX() + parentBBox.getWidth();
            for (int i = floatRendererAreas.size() - 1; i >= 0; --i) {
                Rectangle floatRenderer = floatRendererAreas.get(i);
                if (!(clearPropertyValue.equals((Object)ClearPropertyValue.LEFT) && floatRenderer.getX() < criticalPoint || clearPropertyValue.equals((Object)ClearPropertyValue.RIGHT) && floatRenderer.getX() + floatRenderer.getWidth() > criticalPoint) && !clearPropertyValue.equals((Object)ClearPropertyValue.BOTH)) continue;
                floatRendererAreas.remove(i);
                if ((clearPropertyValue.equals((Object)ClearPropertyValue.LEFT) || clearPropertyValue.equals((Object)ClearPropertyValue.BOTH)) && floatRenderer.getY() + floatRenderer.getHeight() <= parentBBox.getY() + parentBBox.getHeight() && floatRenderer.getX() < parentBBox.getX()) {
                    parentBBox.moveLeft(floatRenderer.getWidth());
                    parentBBox.setWidth(parentBBox.getWidth() + floatRenderer.getWidth());
                }
                if (!(maxFloatHeight < floatRenderer.getHeight())) continue;
                theLowestFloatRectangle = floatRenderer;
                maxFloatHeight = floatRenderer.getHeight();
            }
            if (theLowestFloatRectangle != null) {
                clearHeightCorrection = theLowestFloatRectangle.getHeight() + theLowestFloatRectangle.getY() - parentBBox.getY() - parentBBox.getHeight();
                parentBBox.decreaseHeight(theLowestFloatRectangle.getHeight() - clearHeightCorrection);
            }
        }
        return clearHeightCorrection;
    }

    void adjustLayoutAreaIfClearPropertyPresent(float clearHeightCorrection, LayoutArea area, FloatPropertyValue floatPropertyValue) {
        if (clearHeightCorrection > 0.0f) {
            Rectangle rect = area.getBBox();
            if (floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE)) {
                rect.moveUp(this.occupiedArea.getBBox().getHeight() - clearHeightCorrection);
            } else {
                rect.moveDown(clearHeightCorrection);
            }
        }
    }

    float calculateFreeSpaceIfFloatPropertyPresent(float freeSpace, IRenderer childRenderer, Rectangle currentArea) {
        return freeSpace - (childRenderer.getOccupiedArea().getBBox().getX() - currentArea.getX());
    }

    Document getDocument() {
        IRenderer parent = this.getParent();
        AbstractRenderer currentRenderer = this;
        while (parent != null) {
            if (parent instanceof AbstractRenderer) {
                currentRenderer = (AbstractRenderer)parent;
                parent = currentRenderer.getParent();
                continue;
            }
            if (!(currentRenderer instanceof DocumentRenderer)) continue;
            return ((DocumentRenderer)currentRenderer).document;
        }
        if (currentRenderer instanceof DocumentRenderer) {
            return ((DocumentRenderer)currentRenderer).document;
        }
        return null;
    }

    static boolean noAbsolutePositionInfo(IRenderer renderer) {
        return !renderer.hasProperty(73) && !renderer.hasProperty(14) && !renderer.hasProperty(34) && !renderer.hasProperty(54);
    }

    void shrinkOccupiedAreaForAbsolutePosition() {
        if (this.isAbsolutePosition()) {
            Float left = this.getPropertyAsFloat(34);
            Float right = this.getPropertyAsFloat(54);
            UnitValue width = (UnitValue)this.getProperty(77);
            if (left == null && right == null && width == null) {
                this.occupiedArea.getBBox().setWidth(0.0f);
            }
        }
    }

    void drawPositionedChildren(DrawContext drawContext) {
        for (IRenderer positionedChild : this.positionedRenderers) {
            positionedChild.draw(drawContext);
        }
    }

    FontCharacteristics createFontCharacteristics() {
        FontCharacteristics fc = new FontCharacteristics();
        if (this.hasProperty(95)) {
            fc.setFontWeight((String)this.getProperty(95));
        }
        if (this.hasProperty(94)) {
            fc.setFontStyle((String)this.getProperty(94));
        }
        return fc;
    }

    PdfFont resolveFirstPdfFont() {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            return (PdfFont)font;
        }
        if (font instanceof String) {
            FontProvider provider = (FontProvider)this.getProperty(91);
            if (provider == null) {
                throw new IllegalStateException("Invalid font type. FontProvider expected. Cannot resolve font with string value");
            }
            FontCharacteristics fc = this.createFontCharacteristics();
            return this.resolveFirstPdfFont((String)font, provider, fc);
        }
        throw new IllegalStateException("String or PdfFont expected as value of FONT property");
    }

    PdfFont resolveFirstPdfFont(String font, FontProvider provider, FontCharacteristics fc) {
        return provider.getPdfFont(provider.getFontSelector(FontFamilySplitter.splitFontFamily(font), fc).bestMatch());
    }

    static void applyGeneratedAccessibleAttributes(TagTreePointer tagPointer, PdfDictionary attributes) {
        if (attributes == null) {
            return;
        }
        PdfStructElem structElem = tagPointer.getDocument().getTagStructureContext().getPointerStructElem(tagPointer);
        PdfObject structElemAttr = structElem.getAttributes(false);
        if (structElemAttr == null || !structElemAttr.isDictionary() && !structElemAttr.isArray()) {
            structElem.setAttributes((PdfObject)attributes);
        } else if (structElemAttr.isDictionary()) {
            PdfArray attrArr = new PdfArray();
            attrArr.add((PdfObject)attributes);
            attrArr.add(structElemAttr);
            structElem.setAttributes((PdfObject)attrArr);
        } else {
            PdfArray attrArr = (PdfArray)structElemAttr;
            attrArr.add(0, (PdfObject)attributes);
        }
    }
}

