/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.AreaBreakType;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import java.util.ArrayList;
import java.util.List;

public class DocumentRenderer
extends RootRenderer {
    protected Document document;
    protected List<Integer> wrappedContentPage = new ArrayList<Integer>();
    protected List<IRenderer> waitingDrawingElements = new ArrayList<IRenderer>();

    public DocumentRenderer(Document document) {
        this(document, true);
    }

    public DocumentRenderer(Document document, boolean immediateFlush) {
        this.document = document;
        this.immediateFlush = immediateFlush;
        this.modelElement = document;
    }

    @Override
    public LayoutArea getOccupiedArea() {
        throw new IllegalStateException("Not applicable for DocumentRenderer");
    }

    @Override
    public IRenderer getNextRenderer() {
        return new DocumentRenderer(this.document, this.immediateFlush);
    }

    @Override
    public void close() {
        if (this.waitingDrawingElements.size() > 0) {
            IRenderer waitingDrawingElement = this.waitingDrawingElements.get(0);
            this.waitingDrawingElements.remove(0);
            this.flushSingleRenderer(waitingDrawingElement);
        }
        super.close();
    }

    @Override
    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        PageSize customPageSize;
        AreaBreak areaBreak;
        AreaBreak areaBreak2 = areaBreak = overflowResult != null && overflowResult.getAreaBreak() != null ? overflowResult.getAreaBreak() : null;
        if (areaBreak != null && areaBreak.getType() == AreaBreakType.LAST_PAGE) {
            while (this.currentPageNumber < this.document.getPdfDocument().getNumberOfPages()) {
                this.moveToNextPage();
            }
        } else {
            this.moveToNextPage();
        }
        if (this.waitingDrawingElements.size() > 0) {
            IRenderer renderer = this.waitingDrawingElements.get(0);
            this.waitingDrawingElements.remove(0);
            this.flushSingleRenderer(renderer);
        }
        PageSize pageSize = customPageSize = areaBreak != null ? areaBreak.getPageSize() : null;
        while (this.document.getPdfDocument().getNumberOfPages() >= this.currentPageNumber && this.document.getPdfDocument().getPage(this.currentPageNumber).isFlushed()) {
            ++this.currentPageNumber;
        }
        PageSize lastPageSize = this.ensureDocumentHasNPages(this.currentPageNumber, customPageSize);
        if (lastPageSize == null) {
            lastPageSize = new PageSize(this.document.getPdfDocument().getPage(this.currentPageNumber).getTrimBox());
        }
        this.currentArea = new LayoutArea(this.currentPageNumber, this.document.getPageEffectiveArea(lastPageSize));
        return this.currentArea;
    }

    @Override
    protected void flushSingleRenderer(IRenderer resultRenderer) {
        FloatPropertyValue value = (FloatPropertyValue)((Object)resultRenderer.getProperty(99));
        if (value != null) {
            this.waitingDrawingElements.add(resultRenderer);
            resultRenderer.setProperty(99, null);
        } else if (!resultRenderer.isFlushed()) {
            int pageNum = resultRenderer.getOccupiedArea().getPageNumber();
            PdfDocument pdfDocument = this.document.getPdfDocument();
            this.ensureDocumentHasNPages(pageNum, null);
            PdfPage correspondingPage = pdfDocument.getPage(pageNum);
            boolean wrapOldContent = pdfDocument.getReader() != null && pdfDocument.getWriter() != null && correspondingPage.getContentStreamCount() > 0 && correspondingPage.getLastContentStream().getLength() > 0 && !this.wrappedContentPage.contains(pageNum) && pdfDocument.getNumberOfPages() >= pageNum;
            this.wrappedContentPage.add(pageNum);
            if (pdfDocument.isTagged()) {
                pdfDocument.getTagStructureContext().getAutoTaggingPointer().setPageForTagging(correspondingPage);
            }
            PdfCanvas pageCanvas = new PdfCanvas(correspondingPage, wrapOldContent);
            resultRenderer.draw(new DrawContext(pdfDocument, pageCanvas, pdfDocument.isTagged()));
            if (this.waitingDrawingElements.size() > 0) {
                for (IRenderer renderer : this.waitingDrawingElements) {
                    renderer.draw(new DrawContext(pdfDocument, pageCanvas, pdfDocument.isTagged()));
                }
                this.waitingDrawingElements.clear();
            }
        }
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        if (customPageSize != null) {
            this.document.getPdfDocument().addNewPage(customPageSize);
        } else {
            this.document.getPdfDocument().addNewPage();
        }
        return customPageSize != null ? customPageSize : this.document.getPdfDocument().getDefaultPageSize();
    }

    private PageSize ensureDocumentHasNPages(int n, PageSize customPageSize) {
        PageSize lastPageSize = null;
        while (this.document.getPdfDocument().getNumberOfPages() < n) {
            lastPageSize = this.addNewPage(customPageSize);
        }
        return lastPageSize;
    }

    private void moveToNextPage() {
        if (this.immediateFlush && this.currentPageNumber > 1) {
            this.document.getPdfDocument().getPage(this.currentPageNumber - 1).flush();
        }
        ++this.currentPageNumber;
    }
}

