/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import java.util.ArrayList;
import java.util.List;

final class TableBorderUtil {
    private TableBorderUtil() {
    }

    public static Border getCellSideBorder(Cell cellModel, int borderType) {
        Border cellModelSideBorder = (Border)cellModel.getProperty(borderType);
        if (null == cellModelSideBorder && !cellModel.hasProperty(borderType) && null == (cellModelSideBorder = (Border)cellModel.getProperty(9)) && !cellModel.hasProperty(9)) {
            cellModelSideBorder = (Border)cellModel.getDefaultProperty(9);
        }
        return cellModelSideBorder;
    }

    public static Border getWidestBorder(List<Border> borderList) {
        Border theWidestBorder = null;
        if (0 != borderList.size()) {
            for (Border border : borderList) {
                if (null == border || null != theWidestBorder && !(border.getWidth() > theWidestBorder.getWidth())) continue;
                theWidestBorder = border;
            }
        }
        return theWidestBorder;
    }

    public static Border getWidestBorder(List<Border> borderList, int start, int end) {
        Border theWidestBorder = null;
        if (0 != borderList.size()) {
            for (Border border : borderList.subList(start, end)) {
                if (null == border || null != theWidestBorder && !(border.getWidth() > theWidestBorder.getWidth())) continue;
                theWidestBorder = border;
            }
        }
        return theWidestBorder;
    }

    public static List<Border> createAndFillBorderList(Border border, int size) {
        ArrayList<Border> borderList = new ArrayList<Border>();
        for (int i = 0; i < size; ++i) {
            borderList.add(border);
        }
        return borderList;
    }

    public static List<Border> createAndFillBorderList(List<Border> originalList, Border borderToCollapse, int size) {
        ArrayList<Border> borderList = new ArrayList<Border>();
        if (null != originalList) {
            borderList.addAll(originalList);
        }
        while (borderList.size() < size) {
            borderList.add(borderToCollapse);
        }
        int end = null == originalList ? size : Math.min(originalList.size(), size);
        for (int i = 0; i < end; ++i) {
            if (null != borderList.get(i) && (null == borderToCollapse || !(((Border)borderList.get(i)).getWidth() <= borderToCollapse.getWidth()))) continue;
            borderList.set(i, borderToCollapse);
        }
        return borderList;
    }
}

