/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutContext;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.ContinuousContainer;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.Leading;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.ParagraphOrphansControl;
import com.itextpdf.layout.properties.ParagraphWidowsControl;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.BlockFormattingContextUtil;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import com.itextpdf.layout.renderer.OrphansWidowsLayoutHelper;
import com.itextpdf.layout.renderer.RotationUtils;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphRenderer
extends BlockRenderer {
    protected List<LineRenderer> lines = null;

    public ParagraphRenderer(Paragraph modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        ParagraphOrphansControl orphansControl = (ParagraphOrphansControl)this.getProperty(121);
        ParagraphWidowsControl widowsControl = (ParagraphWidowsControl)this.getProperty(122);
        if (orphansControl != null || widowsControl != null) {
            return OrphansWidowsLayoutHelper.orphansWidowsAwareLayout(this, layoutContext, orphansControl, widowsControl);
        }
        if (RenderingMode.SVG_MODE == this.getProperty(123) && !TypographyUtils.isPdfCalligraphAvailable()) {
            this.deleteProperty(7);
        }
        LayoutResult layoutResult = this.directLayout(layoutContext);
        ParagraphRenderer.updateParentLines(this);
        ParagraphRenderer.updateParentLines((ParagraphRenderer)layoutResult.getSplitRenderer());
        return layoutResult;
    }

    protected LayoutResult directLayout(LayoutContext layoutContext) {
        AbstractRenderer overflowRenderer;
        OverflowPropertyValue overflowY;
        boolean wasHeightClipped = false;
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean anythingPlaced = false;
        boolean firstLineInBox = true;
        LineRenderer currentRenderer = (LineRenderer)new LineRenderer().setParent(this);
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
        }
        ContinuousContainer.setupContinuousContainerIfNeeded(this);
        OverflowPropertyValue overflowX = (OverflowPropertyValue)((Object)this.getProperty(103));
        Boolean nowrapProp = this.getPropertyAsBoolean(118);
        currentRenderer.setProperty(118, nowrapProp);
        boolean notAllKidsAreFloats = false;
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        float clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, floatRendererAreas, parentBBox);
        FloatingHelper.applyClearance(parentBBox, marginsCollapseHandler, clearHeightCorrection, FloatingHelper.isRendererFloating(this));
        Float blockWidth = this.retrieveWidth(parentBBox.getWidth());
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            blockWidth = FloatingHelper.adjustFloatedBlockLayoutBox(this, parentBBox, blockWidth, floatRendererAreas, floatPropertyValue, overflowX);
            floatRendererAreas = new ArrayList<Rectangle>();
        }
        if (this.childRenderers.isEmpty()) {
            anythingPlaced = true;
            currentRenderer = null;
        }
        boolean isPositioned = this.isPositioned();
        Float rotation = this.getPropertyAsFloat(55);
        Float blockMaxHeight = this.retrieveMaxHeight();
        OverflowPropertyValue overflowPropertyValue = overflowY = (null == blockMaxHeight || blockMaxHeight.floatValue() > parentBBox.getHeight()) && !wasParentsHeightClipped ? OverflowPropertyValue.FIT : (OverflowPropertyValue)((Object)this.getProperty(104));
        if (rotation != null || this.isFixedLayout()) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        if (rotation != null && !FloatingHelper.isRendererFloating(this)) {
            blockWidth = RotationUtils.retrieveRotatedLayoutWidth(parentBBox.getWidth(), this);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.startMarginsCollapse(parentBBox);
        }
        Border[] borders = this.getBorders();
        UnitValue[] paddings = this.getPaddings();
        float parentWidth = parentBBox.getWidth();
        this.applyMargins(parentBBox, false);
        this.applyBorderBox(parentBBox, borders, false);
        if (this.isFixedLayout()) {
            parentBBox.setX(this.getPropertyAsFloat(34).floatValue());
        }
        this.applyPaddings(parentBBox, paddings, false);
        float additionalWidth = parentWidth - parentBBox.getWidth();
        this.applyWidth(parentBBox, blockWidth, overflowX);
        wasHeightClipped = this.applyMaxHeight(parentBBox, blockMaxHeight, marginsCollapseHandler, false, overflowY);
        MinMaxWidth minMaxWidth = new MinMaxWidth(additionalWidth);
        MaxMaxWidthHandler widthHandler = new MaxMaxWidthHandler(minMaxWidth);
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        this.shrinkOccupiedAreaForAbsolutePosition();
        TargetCounterHandler.addPageByID(this);
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        this.lines = new ArrayList<LineRenderer>();
        for (IRenderer child : this.childRenderers) {
            notAllKidsAreFloats = notAllKidsAreFloats || !FloatingHelper.isRendererFloating(child);
            currentRenderer.addChild(child);
        }
        float lastYLine = layoutBox.getY() + layoutBox.getHeight();
        float previousDescent = 0.0f;
        float lastLineBottomLeadingIndent = 0.0f;
        boolean onlyOverflowedFloatsLeft = false;
        ArrayList<IRenderer> inlineFloatsOverflowedToNextPage = new ArrayList<IRenderer>();
        boolean floatOverflowedToNextPageWithNothing = false;
        HashSet<Rectangle> nonChildFloatingRendererAreas = new HashSet<Rectangle>(floatRendererAreas);
        if (marginsCollapsingEnabled && !this.childRenderers.isEmpty()) {
            marginsCollapseHandler.startChildMarginsHandling(null, layoutBox);
        }
        boolean includeFloatsInOccupiedArea = BlockFormattingContextUtil.isRendererCreateBfc(this);
        while (currentRenderer != null) {
            currentRenderer.setProperty(67, this.getPropertyAsFloat(67));
            currentRenderer.setProperty(69, this.getProperty(69));
            float lineIndent = anythingPlaced ? 0.0f : this.getPropertyAsFloat(18).floatValue();
            Rectangle childLayoutBox = new Rectangle(layoutBox.getX(), layoutBox.getY(), layoutBox.getWidth(), layoutBox.getHeight());
            currentRenderer.setProperty(103, (Object)overflowX);
            currentRenderer.setProperty(104, (Object)overflowY);
            LineLayoutContext lineLayoutContext = new LineLayoutContext(new LayoutArea(pageNumber, childLayoutBox), null, floatRendererAreas, wasHeightClipped || wasParentsHeightClipped).setTextIndent(lineIndent).setFloatOverflowedToNextPageWithNothing(floatOverflowedToNextPageWithNothing);
            LineLayoutResult result = (LineLayoutResult)((LineRenderer)currentRenderer.setParent(this)).layout(lineLayoutContext);
            boolean isLastLineReLaidOut = false;
            if (result.getStatus() == 3) {
                Float lineShiftUnderFloats;
                if (layoutContext.isClippedHeight()) {
                    OverflowPropertyValue previousOverflowProperty = (OverflowPropertyValue)((Object)currentRenderer.getProperty(104));
                    currentRenderer.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
                    lineLayoutContext.setClippedHeight(true);
                    result = (LineLayoutResult)((LineRenderer)currentRenderer.setParent(this)).layout(lineLayoutContext);
                    currentRenderer.setProperty(104, (Object)previousOverflowProperty);
                    isLastLineReLaidOut = true;
                }
                if ((lineShiftUnderFloats = FloatingHelper.calculateLineShiftUnderFloats(floatRendererAreas, layoutBox)) != null) {
                    layoutBox.decreaseHeight(lineShiftUnderFloats.floatValue());
                    firstLineInBox = true;
                    continue;
                }
                boolean allRemainingKidsAreFloats = !currentRenderer.childRenderers.isEmpty();
                for (IRenderer renderer : currentRenderer.childRenderers) {
                    allRemainingKidsAreFloats = allRemainingKidsAreFloats && FloatingHelper.isRendererFloating(renderer);
                }
                if (allRemainingKidsAreFloats) {
                    onlyOverflowedFloatsLeft = true;
                }
            }
            floatOverflowedToNextPageWithNothing = lineLayoutContext.isFloatOverflowedToNextPageWithNothing();
            if (result.getFloatsOverflowedToNextPage() != null) {
                inlineFloatsOverflowedToNextPage.addAll(result.getFloatsOverflowedToNextPage());
            }
            float minChildWidth = result.getMinMaxWidth().getMinWidth();
            float maxChildWidth = result.getMinMaxWidth().getMaxWidth();
            ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth);
            ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth);
            LineRenderer processedRenderer = (LineRenderer)result.getSplitRenderer();
            if (processedRenderer == null && result.getStatus() == 1) {
                processedRenderer = currentRenderer;
            }
            if (onlyOverflowedFloatsLeft) {
                processedRenderer = null;
            }
            TextAlignment textAlignment = this.getProperty(70, TextAlignment.LEFT);
            this.applyTextAlignment(textAlignment, result, processedRenderer, layoutBox, floatRendererAreas, onlyOverflowedFloatsLeft, lineIndent);
            Leading leading = RenderingMode.HTML_MODE.equals(this.getProperty(123)) ? null : (Leading)this.getProperty(33);
            boolean lineHasContent = processedRenderer != null && processedRenderer.getOccupiedArea().getBBox().getHeight() > 0.0f;
            boolean isFit = processedRenderer != null;
            float deltaY = 0.0f;
            if (isFit && !RenderingMode.HTML_MODE.equals(this.getProperty(123))) {
                if (lineHasContent) {
                    float indentFromLastLine = previousDescent - lastLineBottomLeadingIndent - (leading != null ? processedRenderer.getTopLeadingIndent(leading) : 0.0f) - processedRenderer.getMaxAscent();
                    if (processedRenderer.containsImage()) {
                        indentFromLastLine += previousDescent;
                    }
                    deltaY = lastYLine + indentFromLastLine - processedRenderer.getYLine();
                    float f = lastLineBottomLeadingIndent = leading != null ? processedRenderer.getBottomLeadingIndent(leading) : 0.0f;
                    if (lastLineBottomLeadingIndent < 0.0f && processedRenderer.containsImage()) {
                        lastLineBottomLeadingIndent = 0.0f;
                    }
                }
                if (firstLineInBox) {
                    float f = deltaY = leading != null ? -processedRenderer.getTopLeadingIndent(leading) : 0.0f;
                }
                if (isLastLineReLaidOut) {
                    isFit = leading == null || processedRenderer.getOccupiedArea().getBBox().getY() + deltaY - lastLineBottomLeadingIndent >= layoutBox.getY();
                } else {
                    boolean bl = isFit = leading == null || processedRenderer.getOccupiedArea().getBBox().getY() + deltaY >= layoutBox.getY();
                }
            }
            if (!isFit && (null == processedRenderer || ParagraphRenderer.isOverflowFit(overflowY))) {
                boolean includeFloatsInOccupiedAreaOnSplit;
                if (currentAreaPos + 1 < areas.size()) {
                    layoutBox = areas.get(++currentAreaPos).clone();
                    lastYLine = layoutBox.getY() + layoutBox.getHeight();
                    firstLineInBox = true;
                    continue;
                }
                boolean keepTogether = this.isKeepTogether(result.getCauseOfNothing());
                if (keepTogether) {
                    floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
                    return new MinMaxWidthLayoutResult(3, null, null, this, this);
                }
                if (marginsCollapsingEnabled && anythingPlaced && notAllKidsAreFloats) {
                    marginsCollapseHandler.endChildMarginsHandling(layoutBox);
                }
                boolean bl = includeFloatsInOccupiedAreaOnSplit = !onlyOverflowedFloatsLeft || includeFloatsInOccupiedArea;
                if (includeFloatsInOccupiedAreaOnSplit) {
                    FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this, nonChildFloatingRendererAreas);
                    this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
                }
                if (marginsCollapsingEnabled) {
                    marginsCollapseHandler.endMarginsCollapse(layoutBox);
                }
                boolean minHeightOverflowed = false;
                if (!includeFloatsInOccupiedAreaOnSplit) {
                    AbstractRenderer minHeightOverflow = this.applyMinHeight(overflowY, layoutBox);
                    minHeightOverflowed = minHeightOverflow != null;
                    this.applyVerticalAlignment();
                }
                ParagraphRenderer[] split = this.split();
                split[0].lines = this.lines;
                for (LineRenderer line : this.lines) {
                    split[0].childRenderers.addAll(line.getChildRenderers());
                }
                split[1].childRenderers.addAll(inlineFloatsOverflowedToNextPage);
                if (processedRenderer != null) {
                    split[1].childRenderers.addAll(processedRenderer.getChildRenderers());
                }
                if (result.getOverflowRenderer() != null) {
                    split[1].childRenderers.addAll(result.getOverflowRenderer().getChildRenderers());
                }
                if (onlyOverflowedFloatsLeft && !includeFloatsInOccupiedArea && !minHeightOverflowed) {
                    FloatingHelper.removeParentArtifactsOnPageSplitIfOnlyFloatsOverflow(split[1]);
                }
                float usedHeight = this.occupiedArea.getBBox().getHeight();
                if (!includeFloatsInOccupiedAreaOnSplit) {
                    Rectangle commonRectangle = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{layoutBox, this.occupiedArea.getBBox()});
                    usedHeight = commonRectangle.getHeight();
                }
                this.updateHeightsOnSplit(usedHeight, wasHeightClipped, this, split[1], includeFloatsInOccupiedAreaOnSplit);
                this.correctFixedLayout();
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                this.applyAbsolutePositionIfNeeded(layoutContext);
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                if (wasHeightClipped) {
                    return new MinMaxWidthLayoutResult(1, editedArea, split[0], null).setMinMaxWidth(minMaxWidth);
                }
                if (anythingPlaced) {
                    return new MinMaxWidthLayoutResult(2, editedArea, split[0], split[1]).setMinMaxWidth(minMaxWidth);
                }
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), currentRenderer.getOccupiedArea().getBBox()}));
                    this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
                    this.parent.setProperty(25, true);
                    this.lines.add(currentRenderer);
                    if (2 == result.getStatus()) {
                        IRenderer childNotRendered = result.getCauseOfNothing();
                        int firstNotRendered = currentRenderer.childRenderers.indexOf(childNotRendered);
                        currentRenderer.childRenderers.retainAll(currentRenderer.childRenderers.subList(0, firstNotRendered));
                        for (IRenderer child : currentRenderer.getChildRenderers()) {
                            child.setParent(currentRenderer);
                        }
                        split[1].childRenderers.removeAll(split[1].childRenderers.subList(0, firstNotRendered));
                        return new MinMaxWidthLayoutResult(2, editedArea, this, split[1], null).setMinMaxWidth(minMaxWidth);
                    }
                    return new MinMaxWidthLayoutResult(1, editedArea, null, null, this).setMinMaxWidth(minMaxWidth);
                }
                floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
                ParagraphRenderer overflowRenderer2 = result.getCauseOfNothing() instanceof AreaBreakRenderer ? split[1] : this;
                return new MinMaxWidthLayoutResult(3, null, null, overflowRenderer2, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
            }
            if (leading != null) {
                processedRenderer.applyLeading(deltaY);
                if (lineHasContent) {
                    lastYLine = processedRenderer.getYLine();
                }
            }
            if (lineHasContent) {
                this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), processedRenderer.getOccupiedArea().getBBox()}));
                this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
            }
            firstLineInBox = false;
            layoutBox.setHeight(processedRenderer.getOccupiedArea().getBBox().getY() - layoutBox.getY());
            this.lines.add(processedRenderer);
            anythingPlaced = true;
            currentRenderer = (LineRenderer)result.getOverflowRenderer();
            previousDescent = processedRenderer.getMaxDescent();
            if (inlineFloatsOverflowedToNextPage.isEmpty() || result.getOverflowRenderer() != null) continue;
            onlyOverflowedFloatsLeft = true;
            currentRenderer = new LineRenderer();
        }
        if (!RenderingMode.HTML_MODE.equals(this.getProperty(123))) {
            float moveDown = lastLineBottomLeadingIndent;
            if (ParagraphRenderer.isOverflowFit(overflowY) && moveDown > this.occupiedArea.getBBox().getY() - layoutBox.getY()) {
                moveDown = this.occupiedArea.getBBox().getY() - layoutBox.getY();
            }
            this.occupiedArea.getBBox().moveDown(moveDown);
            this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + moveDown);
        }
        if (marginsCollapsingEnabled && !this.childRenderers.isEmpty() && notAllKidsAreFloats) {
            marginsCollapseHandler.endChildMarginsHandling(layoutBox);
        }
        if (includeFloatsInOccupiedArea) {
            FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this, nonChildFloatingRendererAreas);
            this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
        }
        if (wasHeightClipped) {
            this.fixOccupiedAreaIfOverflowedY(overflowY, layoutBox);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        if ((overflowRenderer = this.applyMinHeight(overflowY, layoutBox)) != null && this.isKeepTogether()) {
            floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
            return new LayoutResult(3, null, null, this, this);
        }
        ContinuousContainer continuousContainer = (ContinuousContainer)this.getProperty(141);
        if (continuousContainer != null && overflowRenderer == null) {
            continuousContainer.reApplyProperties(this);
            paddings = this.getPaddings();
            borders = this.getBorders();
        }
        this.correctFixedLayout();
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        if (rotation != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea())) {
                if (this.isNotFittingWidth(layoutContext.getArea()) && !this.isNotFittingHeight(layoutContext.getArea())) {
                    LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Element does not fit current area. {0}", (Object[])new Object[]{"It fits by height so it will be forced placed"}));
                } else if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
                    return new MinMaxWidthLayoutResult(3, null, null, this, this);
                }
            }
        }
        this.applyVerticalAlignment();
        FloatingHelper.removeFloatsAboveRendererBottom(floatRendererAreas, this);
        LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
        ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
        if (null == overflowRenderer) {
            return new MinMaxWidthLayoutResult(1, editedArea, null, null, null).setMinMaxWidth(minMaxWidth);
        }
        return new MinMaxWidthLayoutResult(2, editedArea, this, overflowRenderer, null).setMinMaxWidth(minMaxWidth);
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(ParagraphRenderer.class, this.getClass());
        return new ParagraphRenderer((Paragraph)this.modelElement);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return (T1)UnitValue.createPointValue(0.0f);
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lines != null && !this.lines.isEmpty()) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(this.lines.get(i).toString());
            }
        } else {
            for (IRenderer renderer : this.childRenderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.lines != null) {
            for (LineRenderer line : this.lines) {
                line.draw(drawContext);
            }
        }
    }

    @Override
    public void move(float dxRight, float dyUp) {
        Logger logger = LoggerFactory.getLogger(ParagraphRenderer.class);
        if (this.occupiedArea == null) {
            logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Moving won't be performed."}));
            return;
        }
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        if (null != this.lines) {
            for (LineRenderer line : this.lines) {
                line.move(dxRight, dyUp);
            }
        }
    }

    public List<LineRenderer> getLines() {
        return this.lines;
    }

    @Override
    protected Float getFirstYLineRecursively() {
        if (this.lines == null || this.lines.isEmpty()) {
            return null;
        }
        return this.lines.get(0).getFirstYLineRecursively();
    }

    @Override
    protected Float getLastYLineRecursively() {
        if (!this.allowLastYLineRecursiveExtraction()) {
            return null;
        }
        if (this.lines == null || this.lines.isEmpty()) {
            return null;
        }
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Float yLine = this.lines.get(i).getLastYLineRecursively();
            if (yLine == null) continue;
            return yLine;
        }
        return null;
    }

    private ParagraphRenderer createOverflowRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    private ParagraphRenderer createSplitRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    protected ParagraphRenderer createOverflowRenderer(IRenderer parent) {
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = parent;
        this.fixOverflowRenderer(overflowRenderer);
        overflowRenderer.addAllProperties(this.getOwnProperties());
        ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    protected ParagraphRenderer createSplitRenderer(IRenderer parent) {
        ParagraphRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.parent = parent;
        splitRenderer.addAllProperties(this.getOwnProperties());
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        return this.createOverflowRenderer(this.parent);
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        MinMaxWidth minMaxWidth = new MinMaxWidth();
        Float rotation = this.getPropertyAsFloat(55);
        if (!this.setMinMaxWidthBasedOnFixedWidth(minMaxWidth)) {
            Float maxWidth;
            Float minWidth = this.hasAbsoluteUnitValue(80) ? this.retrieveMinWidth(0.0f) : null;
            Float f = maxWidth = this.hasAbsoluteUnitValue(79) ? this.retrieveMaxWidth(0.0f) : null;
            if (minWidth == null || maxWidth == null) {
                boolean restoreRotation = this.hasOwnProperty(55);
                this.setProperty(55, null);
                MinMaxWidthLayoutResult result = (MinMaxWidthLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
                if (restoreRotation) {
                    this.setProperty(55, rotation);
                } else {
                    this.deleteOwnProperty(55);
                }
                minMaxWidth = result.getMinMaxWidth();
            }
            if (minWidth != null) {
                minMaxWidth.setChildrenMinWidth(minWidth.floatValue());
            }
            if (maxWidth != null) {
                minMaxWidth.setChildrenMaxWidth(maxWidth.floatValue());
            }
            if (minMaxWidth.getChildrenMinWidth() > minMaxWidth.getChildrenMaxWidth()) {
                minMaxWidth.setChildrenMaxWidth(minMaxWidth.getChildrenMaxWidth());
            }
        } else {
            minMaxWidth.setAdditionalWidth(ParagraphRenderer.calculateAdditionalWidth(this));
        }
        return rotation != null ? RotationUtils.countRotationMinMaxWidth(minMaxWidth, this) : minMaxWidth;
    }

    protected ParagraphRenderer[] split() {
        ParagraphRenderer splitRenderer = this.createSplitRenderer(this.parent);
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer(this.parent);
        return new ParagraphRenderer[]{splitRenderer, overflowRenderer};
    }

    private void fixOverflowRenderer(ParagraphRenderer overflowRenderer) {
        float firstLineIndent = overflowRenderer.getPropertyAsFloat(18).floatValue();
        if (firstLineIndent != 0.0f) {
            overflowRenderer.setProperty(18, Float.valueOf(0.0f));
        }
    }

    private void alignStaticKids(LineRenderer renderer, float dxRight) {
        renderer.getOccupiedArea().getBBox().moveRight(dxRight);
        for (IRenderer childRenderer : renderer.getChildRenderers()) {
            if (FloatingHelper.isRendererFloating(childRenderer)) continue;
            childRenderer.move(dxRight, 0.0f);
        }
    }

    private void applyTextAlignment(TextAlignment textAlignment, LineLayoutResult result, LineRenderer processedRenderer, Rectangle layoutBox, List<Rectangle> floatRendererAreas, boolean onlyOverflowedFloatsLeft, float lineIndent) {
        if (textAlignment == TextAlignment.JUSTIFIED && result.getStatus() == 2 && !result.isSplitForcedByNewline() && !onlyOverflowedFloatsLeft || textAlignment == TextAlignment.JUSTIFIED_ALL) {
            if (processedRenderer != null) {
                Rectangle actualLineLayoutBox = layoutBox.clone();
                FloatingHelper.adjustLineAreaAccordingToFloats(floatRendererAreas, actualLineLayoutBox);
                processedRenderer.justify(actualLineLayoutBox.getWidth() - lineIndent);
            }
        } else if (textAlignment != TextAlignment.LEFT && processedRenderer != null) {
            Rectangle actualLineLayoutBox = layoutBox.clone();
            FloatingHelper.adjustLineAreaAccordingToFloats(floatRendererAreas, actualLineLayoutBox);
            float deltaX = Math.max(0.0f, actualLineLayoutBox.getWidth() - lineIndent - processedRenderer.getOccupiedArea().getBBox().getWidth());
            switch (textAlignment) {
                case RIGHT: {
                    this.alignStaticKids(processedRenderer, deltaX);
                    break;
                }
                case CENTER: {
                    this.alignStaticKids(processedRenderer, deltaX / 2.0f);
                    break;
                }
                case JUSTIFIED: {
                    if (!BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7))) break;
                    this.alignStaticKids(processedRenderer, deltaX);
                }
            }
        }
    }

    private static void updateParentLines(ParagraphRenderer re) {
        if (re == null) {
            return;
        }
        for (LineRenderer lineRenderer : re.lines) {
            lineRenderer.setParent(re);
        }
        for (IRenderer childRenderer : re.getChildRenderers()) {
            IRenderer line = childRenderer.getParent();
            if (line instanceof LineRenderer && re.lines.contains((LineRenderer)line)) continue;
            childRenderer.setParent(null);
        }
    }
}

