/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua1;

import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.ua1.PdfUA1AnnotationChecker;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.List;

public final class PdfUA1FormChecker {
    private PdfUA1FormChecker() {
    }

    public static void checkFormStructElement(PdfStructElem form) {
        boolean fieldContainsTU;
        PdfDictionary widget = PdfUA1FormChecker.getInteractiveKidForm(form);
        if (widget == null || !PdfUA1AnnotationChecker.isAnnotationVisible(widget)) {
            return;
        }
        PdfDictionary formField = widget;
        if (!PdfFormField.isFormField((PdfDictionary)widget) && widget.containsKey(PdfName.Parent)) {
            formField = widget.getAsDictionary(PdfName.Parent);
        }
        boolean bl = fieldContainsTU = formField != null && formField.get(PdfName.TU) != null;
        if (!fieldContainsTU && form.getAlt() == null) {
            throw new PdfUAConformanceException("Document form fields missing both TU entry and alternative description. For PdfFormfields use PdfFormfield#setAlternativeName(\"Your alternative description\"); For the layout engine use Element#getAccesibilityProperties().setAlternateDescription(\"your alternative description\")");
        }
    }

    private static PdfDictionary getInteractiveKidForm(PdfStructElem structElem) {
        List kids = structElem.getKids();
        boolean containsSingleWidget = false;
        if (kids.size() == 1) {
            boolean bl = containsSingleWidget = kids.get(0) instanceof PdfObjRef && PdfFormAnnotationUtil.isPureWidgetOrMergedField((PdfDictionary)((PdfObjRef)kids.get(0)).getReferencedObject());
        }
        if (!containsSingleWidget && !PdfUA1FormChecker.containsRole(structElem)) {
            throw new PdfUAConformanceException("If the Form structure element omits a Role PrintField attribute, it shall have only one child: an object reference identifying the widget annotation.");
        }
        return containsSingleWidget ? ((PdfObjRef)kids.get(0)).getReferencedObject() : null;
    }

    private static boolean containsRole(PdfStructElem structElem) {
        for (PdfStructureAttributes attributes : structElem.getAttributesList()) {
            if (!"PrintField".equals(attributes.getAttributeAsEnum("O")) || attributes.getAttributeAsEnum("Role") == null) continue;
            return true;
        }
        return false;
    }

    public static class PdfUA1FormTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        public PdfUA1FormTagHandler(PdfUAValidationContext context) {
            super(context);
        }

        public boolean accept(IStructureNode node) {
            return node != null;
        }

        public void processElement(IStructureNode elem) {
            if (elem instanceof PdfObjRef && PdfFormAnnotationUtil.isPureWidgetOrMergedField((PdfDictionary)((PdfObjRef)elem).getReferencedObject()) && !"Form".equals(this.context.resolveToStandardRole(elem.getParent()))) {
                throw new PdfUAConformanceException("Widget annotation shall be either Form structure element or an Artifact.");
            }
            PdfStructElem form = this.context.getElementIfRoleMatches(PdfName.Form, elem);
            if (form == null) {
                return;
            }
            PdfUA1FormChecker.checkFormStructElement(form);
        }
    }
}

