/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.ShorthandResolverFactory;
import com.itextpdf.styledxmlparser.css.util.CssBackgroundUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("background-color", shorthandExpression), new CssDeclaration("background-image", shorthandExpression), new CssDeclaration("background-position", shorthandExpression), new CssDeclaration("background-size", shorthandExpression), new CssDeclaration("background-repeat", shorthandExpression), new CssDeclaration("background-origin", shorthandExpression), new CssDeclaration("background-clip", shorthandExpression), new CssDeclaration("background-attachment", shorthandExpression));
        }
        if (shorthandExpression.trim().isEmpty()) {
            LOGGER.error(MessageFormatUtil.format((String)"{0} shorthand property cannot be empty.", (Object[])new Object[]{"background"}));
            return new ArrayList<CssDeclaration>();
        }
        List<List<String>> propsList = CssUtils.extractShorthandProperties(shorthandExpression);
        HashMap<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps = new HashMap<CssBackgroundUtils.BackgroundPropertyType, String>();
        BackgroundShorthandResolver.fillMapWithPropertiesTypes(resolvedProps);
        for (List<String> props : propsList) {
            if (BackgroundShorthandResolver.processProperties(props, resolvedProps)) continue;
            return new ArrayList<CssDeclaration>();
        }
        if (resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR) == null) {
            resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR, "transparent");
        }
        if (!BackgroundShorthandResolver.checkProperties(resolvedProps)) {
            return new ArrayList<CssDeclaration>();
        }
        return Arrays.asList(new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_IMAGE), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_IMAGE)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_REPEAT), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_REPEAT)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_CLIP), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_CLIP)), new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ATTACHMENT), (String)resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ATTACHMENT)));
    }

    private static boolean checkProperties(Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps) {
        for (Map.Entry<CssBackgroundUtils.BackgroundPropertyType, String> property : resolvedProps.entrySet()) {
            if (!CssDeclarationValidationMaster.checkDeclaration(new CssDeclaration(CssBackgroundUtils.getBackgroundPropertyNameFromType(property.getKey()), property.getValue()))) {
                LOGGER.error(MessageFormatUtil.format((String)"Invalid css property declaration: {0}", (Object[])new Object[]{property.getValue()}));
                return false;
            }
            IShorthandResolver resolver = ShorthandResolverFactory.getShorthandResolver(CssBackgroundUtils.getBackgroundPropertyNameFromType(property.getKey()));
            if (resolver == null || !resolver.resolveShorthand(property.getValue()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void removeSpacesAroundSlash(List<String> props) {
        for (int i = 0; i < props.size(); ++i) {
            if ("/".equals(props.get(i))) {
                if (i != 0 && i != props.size() - 1) {
                    String property = props.get(i - 1) + props.get(i) + props.get(i + 1);
                    props.set(i + 1, property);
                    props.remove(i);
                    props.remove(i - 1);
                }
                return;
            }
            if (props.get(i).startsWith("/")) {
                if (i != 0) {
                    String property = props.get(i - 1) + props.get(i);
                    props.set(i, property);
                    props.remove(i - 1);
                }
                return;
            }
            if (!props.get(i).endsWith("/")) continue;
            if (i != props.size() - 1) {
                String property = props.get(i) + props.get(i + 1);
                props.set(i + 1, property);
                props.remove(i);
            }
            return;
        }
    }

    private static void fillMapWithPropertiesTypes(Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps) {
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_IMAGE, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_REPEAT, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_CLIP, null);
        resolvedProps.put(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ATTACHMENT, null);
    }

    private static boolean processProperties(List<String> props, Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps) {
        if (props.isEmpty()) {
            LOGGER.error(MessageFormatUtil.format((String)"{0} shorthand property cannot be empty.", (Object[])new Object[]{"background"}));
            return false;
        }
        if (resolvedProps.get((Object)CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR) != null) {
            LOGGER.error("Only the last background can include a background color.");
            return false;
        }
        BackgroundShorthandResolver.removeSpacesAroundSlash(props);
        HashSet<CssBackgroundUtils.BackgroundPropertyType> usedTypes = new HashSet<CssBackgroundUtils.BackgroundPropertyType>();
        if (BackgroundShorthandResolver.processAllSpecifiedProperties(props, resolvedProps, usedTypes)) {
            BackgroundShorthandResolver.fillNotProcessedProperties(resolvedProps, usedTypes);
            return true;
        }
        return false;
    }

    private static boolean processAllSpecifiedProperties(List<String> props, Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps, Set<CssBackgroundUtils.BackgroundPropertyType> usedTypes) {
        ArrayList<String> boxValues = new ArrayList<String>();
        boolean slashEncountered = false;
        boolean propertyProcessedCorrectly = true;
        for (String value : props) {
            int slashCharInd = value.indexOf(47);
            if (slashCharInd > 0 && slashCharInd < value.length() - 1 && !slashEncountered && !value.contains("url(")) {
                slashEncountered = true;
                propertyProcessedCorrectly = BackgroundShorthandResolver.processValueWithSlash(value, slashCharInd, resolvedProps, usedTypes);
            } else {
                CssBackgroundUtils.BackgroundPropertyType type = CssBackgroundUtils.resolveBackgroundPropertyType(value);
                if (CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN_OR_CLIP == type) {
                    boxValues.add(value);
                } else {
                    propertyProcessedCorrectly = BackgroundShorthandResolver.putPropertyBasedOnType(BackgroundShorthandResolver.changePropertyType(type, slashEncountered), value, resolvedProps, usedTypes);
                }
            }
            if (propertyProcessedCorrectly) continue;
            return false;
        }
        return BackgroundShorthandResolver.addBackgroundClipAndBackgroundOriginBoxValues(boxValues, resolvedProps, usedTypes);
    }

    private static boolean addBackgroundClipAndBackgroundOriginBoxValues(List<String> boxValues, Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps, Set<CssBackgroundUtils.BackgroundPropertyType> usedTypes) {
        if (boxValues.size() == 1) {
            return BackgroundShorthandResolver.putPropertyBasedOnType(CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_CLIP, boxValues.get(0), resolvedProps, usedTypes);
        }
        if (boxValues.size() >= 2) {
            for (int i = 0; i < 2; ++i) {
                CssBackgroundUtils.BackgroundPropertyType type;
                CssBackgroundUtils.BackgroundPropertyType backgroundPropertyType = type = i == 0 ? CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_ORIGIN : CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_CLIP;
                if (BackgroundShorthandResolver.putPropertyBasedOnType(type, boxValues.get(i), resolvedProps, usedTypes)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processValueWithSlash(String value, int slashCharInd, Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps, Set<CssBackgroundUtils.BackgroundPropertyType> usedTypes) {
        String value1 = value.substring(0, slashCharInd);
        CssBackgroundUtils.BackgroundPropertyType typeBeforeSlash = BackgroundShorthandResolver.changePropertyType(CssBackgroundUtils.resolveBackgroundPropertyType(value1), false);
        if (typeBeforeSlash != CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION && typeBeforeSlash != CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_OR_SIZE) {
            LOGGER.error(MessageFormatUtil.format((String)"Unknown {0} property: \"{1}\".", (Object[])new Object[]{"background-position", value1}));
            return false;
        }
        String value2 = value.substring(slashCharInd + 1);
        CssBackgroundUtils.BackgroundPropertyType typeAfterSlash = BackgroundShorthandResolver.changePropertyType(CssBackgroundUtils.resolveBackgroundPropertyType(value2), true);
        if (typeAfterSlash != CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE && typeAfterSlash != CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_OR_SIZE) {
            LOGGER.error(MessageFormatUtil.format((String)"Unknown {0} property: \"{1}\".", (Object[])new Object[]{"background-size", value2}));
            return false;
        }
        return BackgroundShorthandResolver.putPropertyBasedOnType(typeBeforeSlash, value1, resolvedProps, usedTypes) && BackgroundShorthandResolver.putPropertyBasedOnType(typeAfterSlash, value2, resolvedProps, usedTypes);
    }

    private static void fillNotProcessedProperties(Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps, Set<CssBackgroundUtils.BackgroundPropertyType> usedTypes) {
        for (CssBackgroundUtils.BackgroundPropertyType type : new ArrayList<CssBackgroundUtils.BackgroundPropertyType>(resolvedProps.keySet())) {
            if (usedTypes.contains((Object)type) || type == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_COLOR) continue;
            if (resolvedProps.get((Object)type) == null) {
                resolvedProps.put(type, CssDefaults.getDefaultValue(CssBackgroundUtils.getBackgroundPropertyNameFromType(type)));
                continue;
            }
            resolvedProps.put(type, resolvedProps.get((Object)type) + "," + CssDefaults.getDefaultValue(CssBackgroundUtils.getBackgroundPropertyNameFromType(type)));
        }
    }

    private static CssBackgroundUtils.BackgroundPropertyType changePropertyType(CssBackgroundUtils.BackgroundPropertyType propertyType, boolean slashEncountered) {
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_X || propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_Y) {
            propertyType = CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION;
        }
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION_OR_SIZE) {
            return slashEncountered ? CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE : CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION;
        }
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_SIZE && !slashEncountered) {
            return CssBackgroundUtils.BackgroundPropertyType.UNDEFINED;
        }
        if (propertyType == CssBackgroundUtils.BackgroundPropertyType.BACKGROUND_POSITION && slashEncountered) {
            return CssBackgroundUtils.BackgroundPropertyType.UNDEFINED;
        }
        return propertyType;
    }

    private static boolean putPropertyBasedOnType(CssBackgroundUtils.BackgroundPropertyType type, String value, Map<CssBackgroundUtils.BackgroundPropertyType, String> resolvedProps, Set<CssBackgroundUtils.BackgroundPropertyType> usedTypes) {
        if (type == CssBackgroundUtils.BackgroundPropertyType.UNDEFINED) {
            LOGGER.error(MessageFormatUtil.format((String)"Was not able to define one of the background CSS shorthand properties: {0}", (Object[])new Object[]{value}));
            return false;
        }
        if (resolvedProps.get((Object)type) == null) {
            resolvedProps.put(type, value);
        } else if (usedTypes.contains((Object)type)) {
            resolvedProps.put(type, resolvedProps.get((Object)type) + " " + value);
        } else {
            resolvedProps.put(type, resolvedProps.get((Object)type) + "," + value);
        }
        usedTypes.add(type);
        return true;
    }
}

