/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.selector.CssSelector;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CssRuleSetParser {
    private static final Logger logger = LoggerFactory.getLogger(CssRuleSetParser.class);

    private CssRuleSetParser() {
    }

    public static List<CssDeclaration> parsePropertyDeclarations(String propertiesStr) {
        ArrayList<CssDeclaration> declarations = new ArrayList<CssDeclaration>();
        int openedCommentPos = propertiesStr.indexOf("/*", 0);
        if (openedCommentPos != -1) {
            declarations.addAll(CssRuleSetParser.parsePropertyDeclarations(propertiesStr.substring(0, openedCommentPos)));
            int closedCommentPos = propertiesStr.indexOf("*/", openedCommentPos);
            if (closedCommentPos != -1) {
                declarations.addAll(CssRuleSetParser.parsePropertyDeclarations(propertiesStr.substring(closedCommentPos + 2, propertiesStr.length())));
            }
        } else {
            String[] propertySplit;
            int pos = CssRuleSetParser.getSemicolonPosition(propertiesStr, 0);
            while (pos != -1) {
                propertySplit = CssRuleSetParser.splitCssProperty(propertiesStr.substring(0, pos));
                if (propertySplit != null) {
                    declarations.add(new CssDeclaration(propertySplit[0], propertySplit[1]));
                }
                propertiesStr = propertiesStr.substring(pos + 1);
                pos = CssRuleSetParser.getSemicolonPosition(propertiesStr, 0);
            }
            if (!propertiesStr.replaceAll("[\\n\\r\\t ]", "").isEmpty()) {
                propertySplit = CssRuleSetParser.splitCssProperty(propertiesStr);
                if (propertySplit != null) {
                    declarations.add(new CssDeclaration(propertySplit[0], propertySplit[1]));
                }
                return declarations;
            }
        }
        return declarations;
    }

    public static List<CssRuleSet> parseRuleSet(String selectorStr, String propertiesStr) {
        List<CssDeclaration> declarations = CssRuleSetParser.parsePropertyDeclarations(propertiesStr);
        ArrayList<CssRuleSet> ruleSets = new ArrayList<CssRuleSet>();
        String[] selectors = selectorStr.split(",");
        for (int i = 0; i < selectors.length; ++i) {
            selectors[i] = CssUtils.removeDoubleSpacesAndTrim(selectors[i]);
            if (selectors[i].length() != 0) continue;
            return ruleSets;
        }
        for (String currentSelectorStr : selectors) {
            try {
                ruleSets.add(new CssRuleSet(new CssSelector(currentSelectorStr), declarations));
            }
            catch (Exception exc) {
                logger.error(MessageFormatUtil.format((String)"Error while parsing css selector: {0}", (Object[])new Object[]{currentSelectorStr}), (Throwable)exc);
                declarations.clear();
                return ruleSets;
            }
        }
        return ruleSets;
    }

    private static String[] splitCssProperty(String property) {
        if (property.trim().isEmpty()) {
            return null;
        }
        String[] result = new String[2];
        int position = property.indexOf(":");
        if (position < 0) {
            logger.error(MessageFormatUtil.format((String)"Invalid css property declaration: {0}", (Object[])new Object[]{property.trim()}));
            return null;
        }
        result[0] = property.substring(0, position);
        result[1] = property.substring(position + 1);
        return result;
    }

    private static int getSemicolonPosition(String propertiesStr, int fromIndex) {
        int semiColonPos = propertiesStr.indexOf(";", fromIndex);
        int closedBracketPos = propertiesStr.indexOf(")", semiColonPos + 1);
        int openedBracketPos = propertiesStr.indexOf("(", fromIndex);
        if (semiColonPos != -1 && openedBracketPos < semiColonPos && closedBracketPos > 0) {
            int nextOpenedBracketPos = openedBracketPos;
            while ((nextOpenedBracketPos = propertiesStr.indexOf("(", (openedBracketPos = nextOpenedBracketPos) + 1)) < closedBracketPos && nextOpenedBracketPos > 0) {
            }
        }
        if (semiColonPos != -1 && semiColonPos > openedBracketPos && semiColonPos < closedBracketPos) {
            return CssRuleSetParser.getSemicolonPosition(propertiesStr, closedBracketPos + 1);
        }
        return semiColonPos;
    }
}

