/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl.datatype;

import com.itextpdf.styledxmlparser.css.validate.ICssDataTypeValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CssEnumValidator
implements ICssDataTypeValidator {
    private Set<String> allowedValues;

    public CssEnumValidator(String ... allowedValues) {
        this.allowedValues = new HashSet<String>(Arrays.asList(allowedValues));
    }

    public CssEnumValidator(Collection<String> allowedValues) {
        this(allowedValues, null);
    }

    public CssEnumValidator(Collection<String> allowedValues, Collection<String> allowedModificators) {
        this.allowedValues = new HashSet<String>();
        this.allowedValues.addAll(allowedValues);
        if (null != allowedModificators) {
            for (String prefix : allowedModificators) {
                for (String value : allowedValues) {
                    this.allowedValues.add(prefix + " " + value);
                }
            }
        }
    }

    public void addAllowedValues(Collection<String> allowedValues) {
        this.allowedValues.addAll(allowedValues);
    }

    @Override
    public boolean isValid(String objectString) {
        return this.allowedValues.contains(objectString);
    }
}

