/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FontFamilySplitterUtil {
    private static final Pattern FONT_FAMILY_PATTERN = Pattern.compile("^([\\w-]+)$");
    private static final Pattern FONT_FAMILY_PATTERN_QUOTED = Pattern.compile("^(('[\\w -]+')|(\"[\\w -]+\"))$");
    private static final Pattern FONT_FAMILY_PATTERN_QUOTED_SELECT = Pattern.compile("([\\w -]+)");

    public static List<String> splitFontFamily(String fontFamilies) {
        if (fontFamilies == null) {
            return null;
        }
        String[] names = fontFamilies.split(",");
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            Matcher selectMatcher;
            String trimmedName = name.trim();
            if (FONT_FAMILY_PATTERN.matcher(trimmedName).matches()) {
                result.add(trimmedName);
                continue;
            }
            if (!FONT_FAMILY_PATTERN_QUOTED.matcher(trimmedName).matches() || !(selectMatcher = FONT_FAMILY_PATTERN_QUOTED_SELECT.matcher(trimmedName)).find()) continue;
            result.add(selectMatcher.group());
        }
        return result;
    }

    public static String removeQuotes(String fontFamily) {
        Matcher selectMatcher = FONT_FAMILY_PATTERN_QUOTED_SELECT.matcher(fontFamily);
        if (selectMatcher.find()) {
            return selectMatcher.group();
        }
        return null;
    }
}

