/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;
import java.util.List;

public class EllipticalCurveTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 7;
    private Point startPoint;

    public EllipticalCurveTo() {
        this(false);
    }

    public EllipticalCurveTo(boolean relative) {
        super(relative);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point previous) {
        this.startPoint = previous;
        if (inputCoordinates.length < 7) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(rx ry rot largearc sweep x y)+ parameters are expected for elliptical arcs. Got: {0}", (Object[])new Object[]{Arrays.toString(inputCoordinates)}));
        }
        this.coordinates = new String[7];
        System.arraycopy(inputCoordinates, 0, this.coordinates, 0, 7);
        double[] initialPoint = new double[]{previous.getX(), previous.getY()};
        if (this.isRelative()) {
            String[] relativeEndPoint = new String[]{inputCoordinates[5], inputCoordinates[6]};
            String[] absoluteEndPoint = this.copier.makeCoordinatesAbsolute(relativeEndPoint, initialPoint);
            this.coordinates[5] = absoluteEndPoint[0];
            this.coordinates[6] = absoluteEndPoint[1];
        }
    }

    @Override
    public void draw(PdfCanvas canvas) {
        Point start = new Point(this.startPoint.x * 0.75, this.startPoint.y * 0.75);
        double rx = Math.abs(CssUtils.parseAbsoluteLength((String)this.coordinates[0]));
        double ry = Math.abs(CssUtils.parseAbsoluteLength((String)this.coordinates[1]));
        double rotation = Double.parseDouble(this.coordinates[2]) % 360.0;
        rotation = Math.toRadians(rotation);
        boolean largeArc = !CssUtils.compareFloats((float)CssUtils.parseFloat((String)this.coordinates[3]).floatValue(), (float)0.0f);
        boolean sweep = !CssUtils.compareFloats((float)CssUtils.parseFloat((String)this.coordinates[4]).floatValue(), (float)0.0f);
        Point end = new Point((double)CssUtils.parseAbsoluteLength((String)this.coordinates[5]), (double)CssUtils.parseAbsoluteLength((String)this.coordinates[6]));
        if (CssUtils.compareFloats((double)start.x, (double)end.x) && CssUtils.compareFloats((double)start.y, (double)end.y)) {
            return;
        }
        if (CssUtils.compareFloats((double)rx, (double)0.0) || CssUtils.compareFloats((double)ry, (double)0.0)) {
            canvas.lineTo(end.x, end.y);
        } else {
            EllipseArc arc;
            if (CssUtils.compareFloats((double)rotation, (double)0.0)) {
                arc = EllipseArc.getEllipse(start, end, rx, ry, sweep, largeArc);
            } else {
                AffineTransform normalizer = AffineTransform.getRotateInstance((double)(-rotation));
                normalizer.translate(-start.x, -start.y);
                Point newArcEnd = normalizer.transform(end, null);
                newArcEnd.translate(start.x, start.y);
                arc = EllipseArc.getEllipse(start, newArcEnd, rx, ry, sweep, largeArc);
            }
            Point[][] points = this.makePoints(PdfCanvas.bezierArc((double)arc.ll.x, (double)arc.ll.y, (double)arc.ur.x, (double)arc.ur.y, (double)arc.startAng, (double)arc.extent));
            if (sweep) {
                points = EllipticalCurveTo.rotate(points, rotation, points[0][0]);
                for (int i = 0; i < points.length; ++i) {
                    EllipticalCurveTo.drawCurve(canvas, points[i][1], points[i][2], points[i][3]);
                }
            } else {
                points = EllipticalCurveTo.rotate(points, rotation, points[points.length - 1][3]);
                for (int i = points.length - 1; i >= 0; --i) {
                    EllipticalCurveTo.drawCurve(canvas, points[i][2], points[i][1], points[i][0]);
                }
            }
        }
    }

    static Point[][] rotate(Point[][] list, double rotation, Point rotator) {
        if (!CssUtils.compareFloats((double)rotation, (double)0.0)) {
            Point[][] result = new Point[list.length][];
            AffineTransform transRotTrans = AffineTransform.getRotateInstance((double)rotation, (double)rotator.x, (double)rotator.y);
            for (int i = 0; i < list.length; ++i) {
                Point[] input = list[i];
                Point[] row = new Point[input.length];
                for (int j = 0; j < input.length; ++j) {
                    row[j] = transRotTrans.transform(input[j], null);
                }
                result[i] = row;
            }
            return result;
        }
        return list;
    }

    String[] getCoordinates() {
        return this.coordinates;
    }

    private static void drawCurve(PdfCanvas canvas, Point cp1, Point cp2, Point end) {
        canvas.curveTo(cp1.x, cp1.y, cp2.x, cp2.y, end.x, end.y);
    }

    private Point[][] makePoints(List<double[]> input) {
        Point[][] result = new Point[input.size()][];
        for (int i = 0; i < input.size(); ++i) {
            result[i] = new Point[input.get(i).length / 2];
            for (int j = 0; j < input.get(i).length; j += 2) {
                result[i][j / 2] = new Point(input.get(i)[j], input.get(i)[j + 1]);
            }
        }
        return result;
    }

    static class EllipseArc {
        final Point ll;
        final Point ur;
        final double startAng;
        final double extent;

        EllipseArc(Point center, double a, double b, double startAng, double extent) {
            this.ll = new Point(center.x - a, center.y - b);
            this.ur = new Point(center.x + a, center.y + b);
            this.startAng = startAng;
            this.extent = extent;
        }

        static EllipseArc getEllipse(Point start, Point end, double a, double b, boolean sweep, boolean largeArc) {
            double between2;
            double r1 = (start.x - end.x) / (-2.0 * a);
            double r2 = (start.y - end.y) / (2.0 * b);
            double factor = Math.sqrt(r1 * r1 + r2 * r2);
            if (factor > 1.0) {
                return EllipseArc.getEllipse(start, end, a * factor, b * factor, sweep, largeArc);
            }
            double between1 = Math.atan(r1 / r2);
            EllipseArc result = EllipseArc.calculatePossibleMiddle(start, end, a, b, between1 + (between2 = Math.asin(factor)), sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, Math.PI + between1 - between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, Math.PI + between1 + between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, between1 - between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            throw new SvgProcessingException("Could not determine the middle point of the ellipse traced by this elliptical arc");
        }

        static EllipseArc calculatePossibleMiddle(Point start, Point end, double a, double b, double startToCenterAngle, boolean sweep, boolean largeArc) {
            double x0 = start.x - a * Math.cos(startToCenterAngle);
            double y0 = start.y - b * Math.sin(startToCenterAngle);
            Point center = new Point(x0, y0);
            double check = Math.pow((end.x - center.x) / a, 2.0) + Math.pow((end.y - center.y) / b, 2.0);
            if (CssUtils.compareFloats((double)check, (double)1.0)) {
                double theta1 = EllipseArc.calculateAngle(start, center, a, b);
                double theta2 = EllipseArc.calculateAngle(end, center, a, b);
                double startAngl = 0.0;
                double extent = 0.0;
                long deltaTheta = Math.abs(Math.round(theta2 - theta1));
                if (largeArc) {
                    if (sweep) {
                        if (theta2 > theta1 && deltaTheta >= 180L) {
                            startAngl = theta1;
                            extent = theta2 - theta1;
                        }
                        if (theta1 > theta2 && deltaTheta <= 180L) {
                            startAngl = theta1;
                            extent = 360.0 - theta1 + theta2;
                        }
                    } else {
                        if (theta2 > theta1 && deltaTheta <= 180L) {
                            startAngl = theta2;
                            extent = 360.0 - theta2 + theta1;
                        }
                        if (theta1 > theta2 && deltaTheta >= 180L) {
                            startAngl = theta2;
                            extent = theta1 - theta2;
                        }
                    }
                } else if (sweep) {
                    if (theta2 > theta1 && deltaTheta <= 180L) {
                        startAngl = theta1;
                        extent = theta2 - theta1;
                    }
                    if (theta1 > theta2 && deltaTheta >= 180L) {
                        startAngl = theta1;
                        extent = 360.0 - theta1 + theta2;
                    }
                } else {
                    if (theta2 > theta1 && deltaTheta >= 180L) {
                        startAngl = theta2;
                        extent = 360.0 - theta2 + theta1;
                    }
                    if (theta1 > theta2 && deltaTheta <= 180L) {
                        startAngl = theta2;
                        extent = theta1 - theta2;
                    }
                }
                if (startAngl >= 0.0 && extent > 0.0) {
                    return new EllipseArc(center, a, b, startAngl, extent);
                }
            }
            return null;
        }

        static double calculateAngle(Point pt, Point center, double a, double b) {
            double result = Math.pow((pt.x - center.x) / a, 2.0) + Math.pow((pt.y - center.y) / b, 2.0);
            double cos = (pt.x - center.x) / a;
            double sin = (pt.y - center.y) / b;
            if ((cos = Math.max(Math.min(cos, 1.0), -1.0)) >= 0.0 && sin >= 0.0 || cos < 0.0 && sin >= 0.0) {
                result = EllipseArc.toDegrees(Math.acos(cos));
            }
            if (cos >= 0.0 && sin < 0.0 || cos < 0.0 && sin < 0.0) {
                result = 360.0 - EllipseArc.toDegrees(Math.acos(cos));
            }
            return result;
        }

        static double toDegrees(double radians) {
            return radians * 180.0 / Math.PI;
        }
    }
}

