/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.util.WhiteSpaceUtil;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextLeafSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;

public final class SvgTextUtil {
    private SvgTextUtil() {
    }

    public static String trimLeadingWhitespace(String toTrim) {
        char currentChar;
        int current;
        if (toTrim == null) {
            return "";
        }
        int end = toTrim.length();
        for (current = 0; current < end && Character.isWhitespace(currentChar = toTrim.charAt(current)) && currentChar != '\n' && currentChar != '\r'; ++current) {
        }
        return toTrim.substring(current);
    }

    public static String trimTrailingWhitespace(String toTrim) {
        if (toTrim == null) {
            return "";
        }
        int end = toTrim.length();
        if (end > 0) {
            char currentChar;
            int current;
            for (current = end - 1; current >= 0 && Character.isWhitespace(currentChar = toTrim.charAt(current)) && currentChar != '\n' && currentChar != '\r'; --current) {
            }
            if (current < 0) {
                return "";
            }
            return toTrim.substring(0, current + 1);
        }
        return toTrim;
    }

    public static void processWhiteSpace(TextSvgBranchRenderer root, boolean isLeadingElement) {
        boolean performLeadingTrim = isLeadingElement;
        for (ISvgTextNodeRenderer child : root.getChildren()) {
            if (child instanceof TextSvgBranchRenderer) {
                SvgTextUtil.processWhiteSpace((TextSvgBranchRenderer)child, child.containsAbsolutePositionChange());
                ((TextSvgBranchRenderer)child).markWhiteSpaceProcessed();
            }
            if (!(child instanceof TextLeafSvgNodeRenderer)) continue;
            TextLeafSvgNodeRenderer leafRend = (TextLeafSvgNodeRenderer)child;
            String toProcess = leafRend.getAttribute("text_content");
            toProcess = toProcess.replaceAll("\\s+", " ");
            toProcess = WhiteSpaceUtil.collapseConsecutiveSpaces((String)toProcess);
            if (performLeadingTrim) {
                toProcess = SvgTextUtil.trimLeadingWhitespace(toProcess);
                toProcess = SvgTextUtil.trimTrailingWhitespace(toProcess);
                performLeadingTrim = false;
            } else {
                toProcess = SvgTextUtil.trimTrailingWhitespace(toProcess);
            }
            leafRend.setAttribute("text_content", toProcess);
        }
    }

    public static boolean isOnlyWhiteSpace(String s) {
        String trimmedText = s.replaceAll("\\s+", " ");
        trimmedText = SvgTextUtil.trimLeadingWhitespace(trimmedText);
        trimmedText = SvgTextUtil.trimTrailingWhitespace(trimmedText);
        return trimmedText.equals("");
    }

    public static float resolveFontSize(ISvgTextNodeRenderer renderer, float parentFontSize) {
        float fontSize = SvgTextUtil.extractFontSize(renderer);
        if (Float.isNaN(fontSize) || fontSize < 0.0f) {
            fontSize = parentFontSize;
        }
        return fontSize;
    }

    private static float extractFontSize(ISvgTextNodeRenderer renderer) {
        String fontSizeRawValue;
        float fontSize = Float.NaN;
        if (renderer.getAttribute("font-size") != null && (fontSizeRawValue = renderer.getAttribute("font-size")) != null && !fontSizeRawValue.isEmpty()) {
            fontSize = CssUtils.parseAbsoluteLength((String)fontSizeRawValue, (String)"pt");
        }
        return fontSize;
    }
}

