/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.db;

import com.mageddo.tobby.UncheckedSQLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectionUtils.class);

    public static void useTransaction(Connection con, Runnable runnable) {
        ConnectionUtils.useTransaction(con, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T useTransaction(Connection con, Callable<T> runnable) {
        try {
            boolean isAutoCommit = con.getAutoCommit();
            if (isAutoCommit) {
                con.setAutoCommit(false);
            }
            T r = runnable.call();
            if (isAutoCommit) {
                con.setAutoCommit(true);
            } else {
                con.commit();
            }
            return r;
        }
        catch (SQLException e) {
            ConnectionUtils.quietRollback(con);
            throw new UncheckedSQLException(e);
        }
        catch (Exception e) {
            ConnectionUtils.quietRollback(con);
            throw e;
        }
    }

    public static void savepoint(Connection con, Callback callback) throws SQLException {
        Savepoint sp = con.setSavepoint("SAVEPOINT_1");
        try {
            callback.run();
        }
        catch (Exception e) {
            con.rollback(sp);
            throw e;
        }
    }

    public static void quietRollback(Connection conn) {
        try {
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void quietClose(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ConnectionUtils() {
    }

    public static interface Callable<T> {
        public T call();
    }

    public static interface Callback {
        public void run() throws SQLException;
    }
}

