/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.db;

import com.mageddo.db.DB;
import com.mageddo.tobby.UncheckedSQLException;
import com.mageddo.tobby.internal.utils.Validator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class DBUtils {
    private static final Pattern DB_NAME_REGEX = Pattern.compile("jdbc:(\\w+):");

    private DBUtils() {
    }

    public static DB discoverDB(Connection connection) throws SQLException {
        String url = connection.getMetaData().getURL();
        return DB.of(DBUtils.findDBName(url));
    }

    public static DB discoverDB(DataSource dataSource) {
        DB dB;
        block8: {
            Connection con = dataSource.getConnection();
            try {
                dB = DBUtils.discoverDB(con);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
            }
            con.close();
        }
        return dB;
    }

    private static String findDBName(String jdbcUrl) {
        Matcher matcher = DB_NAME_REGEX.matcher(jdbcUrl);
        Validator.isTrue(matcher.find(), "Couldn't parse jdbc url: %s", jdbcUrl);
        return matcher.group(1);
    }
}

