/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.db;

import com.mageddo.db.DB;
import com.mageddo.tobby.internal.utils.ObjectUtils;
import com.mageddo.tobby.internal.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class SqlErrorCodes {
    private static final Map<DB, SqlErrorCodes> data = new HashMap<DB, SqlErrorCodes>();
    @NonNull
    private final DB db;
    private final boolean useSqlStateForTranslation;
    @NonNull
    private final Set<Integer> duplicateKeyCodes;
    @NonNull
    private final Set<String> databaseProductName;
    @NonNull
    private final Set<String> queryTimeoutErrors;

    public static SqlErrorCodes build(DB db) {
        Properties codes = SqlErrorCodes.loadSqlErrorsProperties();
        for (Object key : codes.keySet()) {
            String parsedKey = (String)key;
            String prefix = String.format("%s.", db.getName());
            if (!parsedKey.startsWith(prefix)) continue;
            return SqlErrorCodes.put(db, SqlErrorCodes.builder().db(db).useSqlStateForTranslation(SqlErrorCodes.toBoolean(codes, prefix, "useSqlStateForTranslation")).duplicateKeyCodes(SqlErrorCodes.toIntegerSet(codes, prefix, "duplicateKeyCodes")).databaseProductName(SqlErrorCodes.toStringSet(codes, prefix, "databaseProductName")).queryTimeoutErrors(SqlErrorCodes.toStringSet(codes, prefix, "queryTimeoutErrors")).build());
        }
        return SqlErrorCodes.empty();
    }

    public static SqlErrorCodes of(DB db) {
        return data.getOrDefault(db, SqlErrorCodes.empty());
    }

    public static boolean isQueryTimeoutError(DB db, SQLException e) {
        return SqlErrorCodes.of(db).isQueryTimeoutError(e);
    }

    public boolean isDuplicateKeyError(SQLException e) {
        if (this.useSqlStateForTranslation) {
            return this.isDuplicateKeyError(ObjectUtils.firstNonNull(this.parseIntOrNull(e.getSQLState()), e.getErrorCode()));
        }
        return this.isDuplicateKeyError(e.getErrorCode());
    }

    public boolean isDuplicateKeyError(int errorCode) {
        return this.duplicateKeyCodes.contains(errorCode);
    }

    public boolean isQueryTimeoutError(SQLException e) {
        String msg = e.getMessage();
        for (String err : this.queryTimeoutErrors) {
            if (!msg.contains(err)) continue;
            return true;
        }
        return false;
    }

    private Integer parseIntOrNull(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Set<Integer> toIntegerSet(String codes) {
        return Arrays.stream(codes.split(",")).map(Integer::parseInt).collect(Collectors.toSet());
    }

    private static Set<Integer> toIntegerSet(Properties codes, String prefix, String key) {
        return SqlErrorCodes.toIntegerSet(SqlErrorCodes.getProperty(codes, prefix, key));
    }

    private static Set<String> toStringSet(String codes) {
        if (StringUtils.isBlank(codes)) {
            return Collections.emptySet();
        }
        return Arrays.stream(codes.split(",")).collect(Collectors.toSet());
    }

    private static Set<String> toStringSet(Properties codes, String prefix, String key) {
        return SqlErrorCodes.toStringSet(SqlErrorCodes.getProperty(codes, prefix, key));
    }

    private static boolean toBoolean(Properties codes, String prefix, String key) {
        String v = SqlErrorCodes.getProperty(codes, prefix, key);
        if (StringUtils.isBlank(v)) {
            return false;
        }
        return Boolean.parseBoolean(v);
    }

    private static String getProperty(Properties codes, String prefix, String key) {
        return codes.getProperty(String.format("%s%s", prefix, key));
    }

    private static Properties loadSqlErrorsProperties() {
        try {
            Properties properties = new Properties();
            SqlErrorCodes.loadIfNotNull(properties, "/com/mageddo/db/sql-error-codes.properties");
            SqlErrorCodes.loadIfNotNull(properties, "/com/mageddo/db/sql-error-codes-override.properties");
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void loadIfNotNull(Properties properties, String path) throws IOException {
        InputStream in = SqlErrorCodes.class.getResourceAsStream(path);
        if (in != null) {
            properties.load(in);
        }
    }

    private static SqlErrorCodes empty() {
        return SqlErrorCodes.builder().db(DB.of("Unknown")).duplicateKeyCodes(Collections.emptySet()).databaseProductName(Collections.emptySet()).queryTimeoutErrors(Collections.emptySet()).build();
    }

    private static SqlErrorCodes put(DB db, SqlErrorCodes errorCodes) {
        data.put(db, errorCodes);
        return errorCodes;
    }

    private static boolean $default$useSqlStateForTranslation() {
        return false;
    }

    SqlErrorCodes(@NonNull DB db, boolean useSqlStateForTranslation, @NonNull Set<Integer> duplicateKeyCodes, @NonNull Set<String> databaseProductName, @NonNull Set<String> queryTimeoutErrors) {
        if (db == null) {
            throw new NullPointerException("db is marked non-null but is null");
        }
        if (duplicateKeyCodes == null) {
            throw new NullPointerException("duplicateKeyCodes is marked non-null but is null");
        }
        if (databaseProductName == null) {
            throw new NullPointerException("databaseProductName is marked non-null but is null");
        }
        if (queryTimeoutErrors == null) {
            throw new NullPointerException("queryTimeoutErrors is marked non-null but is null");
        }
        this.db = db;
        this.useSqlStateForTranslation = useSqlStateForTranslation;
        this.duplicateKeyCodes = duplicateKeyCodes;
        this.databaseProductName = databaseProductName;
        this.queryTimeoutErrors = queryTimeoutErrors;
    }

    public static SqlErrorCodesBuilder builder() {
        return new SqlErrorCodesBuilder();
    }

    @NonNull
    public DB getDb() {
        return this.db;
    }

    public boolean isUseSqlStateForTranslation() {
        return this.useSqlStateForTranslation;
    }

    @NonNull
    public Set<Integer> getDuplicateKeyCodes() {
        return this.duplicateKeyCodes;
    }

    @NonNull
    public Set<String> getDatabaseProductName() {
        return this.databaseProductName;
    }

    @NonNull
    public Set<String> getQueryTimeoutErrors() {
        return this.queryTimeoutErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlErrorCodes)) {
            return false;
        }
        SqlErrorCodes other = (SqlErrorCodes)o;
        if (this.isUseSqlStateForTranslation() != other.isUseSqlStateForTranslation()) {
            return false;
        }
        DB this$db = this.getDb();
        DB other$db = other.getDb();
        if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
            return false;
        }
        Set<Integer> this$duplicateKeyCodes = this.getDuplicateKeyCodes();
        Set<Integer> other$duplicateKeyCodes = other.getDuplicateKeyCodes();
        if (this$duplicateKeyCodes == null ? other$duplicateKeyCodes != null : !((Object)this$duplicateKeyCodes).equals(other$duplicateKeyCodes)) {
            return false;
        }
        Set<String> this$databaseProductName = this.getDatabaseProductName();
        Set<String> other$databaseProductName = other.getDatabaseProductName();
        if (this$databaseProductName == null ? other$databaseProductName != null : !((Object)this$databaseProductName).equals(other$databaseProductName)) {
            return false;
        }
        Set<String> this$queryTimeoutErrors = this.getQueryTimeoutErrors();
        Set<String> other$queryTimeoutErrors = other.getQueryTimeoutErrors();
        return !(this$queryTimeoutErrors == null ? other$queryTimeoutErrors != null : !((Object)this$queryTimeoutErrors).equals(other$queryTimeoutErrors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSqlStateForTranslation() ? 79 : 97);
        DB $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
        Set<Integer> $duplicateKeyCodes = this.getDuplicateKeyCodes();
        result = result * 59 + ($duplicateKeyCodes == null ? 43 : ((Object)$duplicateKeyCodes).hashCode());
        Set<String> $databaseProductName = this.getDatabaseProductName();
        result = result * 59 + ($databaseProductName == null ? 43 : ((Object)$databaseProductName).hashCode());
        Set<String> $queryTimeoutErrors = this.getQueryTimeoutErrors();
        result = result * 59 + ($queryTimeoutErrors == null ? 43 : ((Object)$queryTimeoutErrors).hashCode());
        return result;
    }

    public String toString() {
        return "SqlErrorCodes(db=" + this.getDb() + ", useSqlStateForTranslation=" + this.isUseSqlStateForTranslation() + ", duplicateKeyCodes=" + this.getDuplicateKeyCodes() + ", databaseProductName=" + this.getDatabaseProductName() + ", queryTimeoutErrors=" + this.getQueryTimeoutErrors() + ")";
    }

    public static class SqlErrorCodesBuilder {
        private DB db;
        private boolean useSqlStateForTranslation$set;
        private boolean useSqlStateForTranslation$value;
        private Set<Integer> duplicateKeyCodes;
        private Set<String> databaseProductName;
        private Set<String> queryTimeoutErrors;

        SqlErrorCodesBuilder() {
        }

        public SqlErrorCodesBuilder db(@NonNull DB db) {
            if (db == null) {
                throw new NullPointerException("db is marked non-null but is null");
            }
            this.db = db;
            return this;
        }

        public SqlErrorCodesBuilder useSqlStateForTranslation(boolean useSqlStateForTranslation) {
            this.useSqlStateForTranslation$value = useSqlStateForTranslation;
            this.useSqlStateForTranslation$set = true;
            return this;
        }

        public SqlErrorCodesBuilder duplicateKeyCodes(@NonNull Set<Integer> duplicateKeyCodes) {
            if (duplicateKeyCodes == null) {
                throw new NullPointerException("duplicateKeyCodes is marked non-null but is null");
            }
            this.duplicateKeyCodes = duplicateKeyCodes;
            return this;
        }

        public SqlErrorCodesBuilder databaseProductName(@NonNull Set<String> databaseProductName) {
            if (databaseProductName == null) {
                throw new NullPointerException("databaseProductName is marked non-null but is null");
            }
            this.databaseProductName = databaseProductName;
            return this;
        }

        public SqlErrorCodesBuilder queryTimeoutErrors(@NonNull Set<String> queryTimeoutErrors) {
            if (queryTimeoutErrors == null) {
                throw new NullPointerException("queryTimeoutErrors is marked non-null but is null");
            }
            this.queryTimeoutErrors = queryTimeoutErrors;
            return this;
        }

        public SqlErrorCodes build() {
            boolean useSqlStateForTranslation$value = this.useSqlStateForTranslation$value;
            if (!this.useSqlStateForTranslation$set) {
                useSqlStateForTranslation$value = SqlErrorCodes.$default$useSqlStateForTranslation();
            }
            return new SqlErrorCodes(this.db, useSqlStateForTranslation$value, this.duplicateKeyCodes, this.databaseProductName, this.queryTimeoutErrors);
        }

        public String toString() {
            return "SqlErrorCodes.SqlErrorCodesBuilder(db=" + this.db + ", useSqlStateForTranslation$value=" + this.useSqlStateForTranslation$value + ", duplicateKeyCodes=" + this.duplicateKeyCodes + ", databaseProductName=" + this.databaseProductName + ", queryTimeoutErrors=" + this.queryTimeoutErrors + ")";
        }
    }
}

