/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.db;

import com.mageddo.tobby.UncheckedSQLException;
import com.mageddo.tobby.internal.utils.Threads;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmUtils {
    private static final Logger log = LoggerFactory.getLogger(StmUtils.class);
    private static final ExecutorService EXECUTOR = Threads.newPool(5);

    public static int executeOrCancel(PreparedStatement stm, Duration timeout) throws SQLException {
        AtomicBoolean semaphore = new AtomicBoolean();
        EXECUTOR.submit(() -> {
            long now = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace("status=stmWatcherStarted");
            }
            while (!semaphore.get() && !StmUtils.timeHasExpired(timeout, now) && StmUtils.sleep()) {
            }
            if (log.isTraceEnabled()) {
                log.trace("status=exitSleep");
            }
            if (semaphore.compareAndSet(false, true)) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("status=cancellingStatement");
                    }
                    stm.cancel();
                    if (log.isTraceEnabled()) {
                        log.trace("status=canceled");
                    }
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
            }
        });
        int affected = stm.executeUpdate();
        if (log.isTraceEnabled()) {
            log.trace("status=executed");
        }
        semaphore.set(true);
        return affected;
    }

    private static boolean sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(16L);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static boolean timeHasExpired(Duration timeout, long now) {
        return System.currentTimeMillis() - now >= timeout.toMillis();
    }
}

