/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby;

import com.mageddo.db.DB;
import com.mageddo.db.QueryTimeoutException;
import com.mageddo.db.StmUtils;
import com.mageddo.tobby.LockDAO;
import com.mageddo.tobby.Parameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LockDAOGeneric
implements LockDAO {
    private final DB db;

    @Inject
    public LockDAOGeneric(DB db) {
        this.db = db;
    }

    @Override
    public void lock(Connection conn, Duration timeout) {
        StringBuilder sql = new StringBuilder().append("UPDATE TTO_PARAMETER SET \n").append("  VAL_PARAMETER = CURRENT_TIMESTAMP \n").append("WHERE IDT_TTO_PARAMETER = ? \n");
        try (PreparedStatement stm = conn.prepareStatement(sql.toString());){
            stm.setString(1, Parameter.REPLICATOR_LOCK.name());
            int affected = StmUtils.executeOrCancel(stm, timeout);
            if (affected != 1) {
                throw new IllegalStateException("Must update exactly one record while locking");
            }
        }
        catch (SQLException e) {
            throw QueryTimeoutException.check(this.db, e);
        }
    }
}

