/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby;

import com.mageddo.db.ConnectionUtils;
import com.mageddo.db.DuplicatedRecordException;
import com.mageddo.tobby.LockDAO;
import com.mageddo.tobby.Parameter;
import com.mageddo.tobby.ParameterDAO;
import java.sql.Connection;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Locker {
    private static final Logger log = LoggerFactory.getLogger(Locker.class);
    private final LockDAO lockDAO;
    private final ParameterDAO parameterDAO;

    @Inject
    public Locker(LockDAO lockDAO, ParameterDAO parameterDAO) {
        this.lockDAO = lockDAO;
        this.parameterDAO = parameterDAO;
    }

    public void lock(Connection conn) {
        this.insertIfAbsent(conn);
        this.lockDAO.lock(conn, Duration.ofMillis(500L));
        log.info("status=lockAcquired");
    }

    private void insertIfAbsent(Connection conn) {
        try {
            ConnectionUtils.useTransaction(conn, () -> this.parameterDAO.insertIfAbsent(conn, Parameter.REPLICATOR_LOCK, String.valueOf(LocalDateTime.now())));
        }
        catch (DuplicatedRecordException e) {
            log.info("status=already-insert");
        }
    }
}

