/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby;

import com.mageddo.db.ConnectionUtils;
import com.mageddo.db.DB;
import com.mageddo.db.DuplicatedRecordException;
import com.mageddo.db.QueryTimeoutException;
import com.mageddo.db.SqlErrorCodes;
import com.mageddo.db.StmUtils;
import com.mageddo.tobby.Parameter;
import com.mageddo.tobby.ParameterDAO;
import com.mageddo.tobby.UncheckedSQLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ParameterDAOUniversal
implements ParameterDAO {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DB db;

    @Inject
    public ParameterDAOUniversal(DB db) {
        this.db = db;
    }

    @Override
    public LocalDateTime findAsDateTime(Connection connection, Parameter parameter, LocalDateTime defaultValue) {
        return LocalDateTime.parse(this.find(connection, parameter, defaultValue.toString()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String find(Connection connection, Parameter parameter, String defaultValue) {
        try (PreparedStatement stm = connection.prepareStatement("SELECT VAL_PARAMETER FROM TTO_PARAMETER WHERE IDT_TTO_PARAMETER = ?");){
            String string;
            block18: {
                ResultSet rs;
                block16: {
                    String string2;
                    block17: {
                        stm.setString(1, parameter.name());
                        rs = stm.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            string2 = defaultValue;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = rs.getString("VAL_PARAMETER");
                if (rs == null) break block18;
                rs.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    @Override
    public boolean insertIfAbsent(Connection conn, Parameter parameter, String value) {
        if (this.find(conn, parameter, null) == null) {
            this.insert(conn, parameter, value);
            return true;
        }
        return false;
    }

    @Override
    public void insertOrUpdate(Connection connection, Parameter parameter, String value) {
        try {
            ConnectionUtils.savepoint(connection, () -> {
                if (this.update(connection, parameter, value) == 0) {
                    this.log.info("status=nothing-to-update, action=inserting, parameter={}", (Object)parameter.name());
                    try {
                        this.insert(connection, parameter, value);
                    }
                    catch (DuplicatedRecordException e) {
                        this.log.info("status=already-insert, parameter={}", (Object)parameter.name());
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    @Override
    public void insert(Connection connection, Parameter parameter, String value) {
        String sql = "INSERT INTO TTO_PARAMETER (IDT_TTO_PARAMETER, VAL_PARAMETER) VALUES (?, ?)";
        try (PreparedStatement stm = connection.prepareStatement("INSERT INTO TTO_PARAMETER (IDT_TTO_PARAMETER, VAL_PARAMETER) VALUES (?, ?)");){
            stm.setString(1, parameter.name());
            stm.setString(2, value);
            StmUtils.executeOrCancel(stm, Duration.ofMillis(500L));
            this.log.info("status=inserted, parameter={}, value={}", (Object)parameter.name(), (Object)value);
        }
        catch (SQLException e) {
            if (SqlErrorCodes.isQueryTimeoutError(this.db, e)) {
                throw new QueryTimeoutException("INSERT INTO TTO_PARAMETER (IDT_TTO_PARAMETER, VAL_PARAMETER) VALUES (?, ?)", e);
            }
            throw DuplicatedRecordException.check(this.db, parameter.name(), e);
        }
    }

    @Override
    public int update(Connection connection, Parameter parameter, String value) {
        int n;
        block8: {
            StringBuilder sql = new StringBuilder().append("UPDATE TTO_PARAMETER SET \n").append("  VAL_PARAMETER = ?, \n").append("  DAT_UPDATED = CURRENT_TIMESTAMP \n").append("WHERE IDT_TTO_PARAMETER = ? \n");
            PreparedStatement stm = connection.prepareStatement(sql.toString());
            try {
                stm.setString(1, value);
                stm.setString(2, parameter.name());
                n = stm.executeUpdate();
                if (stm == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stm != null) {
                        try {
                            stm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
            }
            stm.close();
        }
        return n;
    }
}

