/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby;

import com.mageddo.tobby.Headers;
import java.util.Arrays;

public final class ProducerRecord {
    private final String topic;
    private final Integer partition;
    private final byte[] key;
    private final byte[] value;
    private final Headers headers;

    public ProducerRecord(String topic, byte[] value) {
        this(topic, null, value);
    }

    public ProducerRecord(String topic, byte[] key, byte[] value) {
        this(topic, null, key, value);
    }

    public ProducerRecord(String topic, Integer partition, byte[] key, byte[] value) {
        this(topic, partition, key, value, null);
    }

    public ProducerRecord(String topic, Integer partition, byte[] key, byte[] value, Headers headers) {
        this.topic = topic;
        this.partition = partition;
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    public static ProducerRecordBuilder builder() {
        return new ProducerRecordBuilder();
    }

    public ProducerRecordBuilder toBuilder() {
        return new ProducerRecordBuilder().topic(this.topic).partition(this.partition).key(this.key).value(this.value).headers(this.headers);
    }

    public String getTopic() {
        return this.topic;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerRecord)) {
            return false;
        }
        ProducerRecord other = (ProducerRecord)o;
        Integer this$partition = this.getPartition();
        Integer other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !((Object)this$partition).equals(other$partition)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        if (!Arrays.equals(this.getKey(), other.getKey())) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : ((Object)$partition).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKey());
        result = result * 59 + Arrays.hashCode(this.getValue());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "ProducerRecord(topic=" + this.getTopic() + ", partition=" + this.getPartition() + ", key=" + Arrays.toString(this.getKey()) + ", value=" + Arrays.toString(this.getValue()) + ", headers=" + this.getHeaders() + ")";
    }

    public static class ProducerRecordBuilder {
        private String topic;
        private Integer partition;
        private byte[] key;
        private byte[] value;
        private Headers headers;

        ProducerRecordBuilder() {
        }

        public ProducerRecordBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public ProducerRecordBuilder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public ProducerRecordBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        public ProducerRecordBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        public ProducerRecordBuilder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public ProducerRecord build() {
            return new ProducerRecord(this.topic, this.partition, this.key, this.value, this.headers);
        }

        public String toString() {
            return "ProducerRecord.ProducerRecordBuilder(topic=" + this.topic + ", partition=" + this.partition + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", headers=" + this.headers + ")";
        }
    }
}

