/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby;

import com.mageddo.tobby.ProducedRecord;
import com.mageddo.tobby.RecordProcessedDAO;
import com.mageddo.tobby.UncheckedSQLException;
import com.mageddo.tobby.converter.ProducedRecordConverter;
import com.mageddo.tobby.converter.RecordProcessedMapper;
import com.mageddo.tobby.internal.utils.StopWatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecordProcessedDAOGeneric
implements RecordProcessedDAO {
    private static final Logger log = LoggerFactory.getLogger(RecordProcessedDAOGeneric.class);

    @Inject
    public RecordProcessedDAOGeneric() {
    }

    @Override
    public void save(Connection con, ProducedRecord record) {
        StopWatch stopWatch = StopWatch.createStarted();
        StringBuilder sql = new StringBuilder().append("INSERT INTO TTO_RECORD_PROCESSED ( \n").append("  IDT_TTO_RECORD, NAM_TOPIC, NUM_PARTITION, \n").append("  TXT_KEY, TXT_VALUE, TXT_HEADERS \n").append(") VALUES ( \n").append("  ?, ?, ?, \n").append("  ?, ?, ? \n").append(") \n");
        try (PreparedStatement stm = con.prepareStatement(sql.toString());){
            RecordProcessedMapper.map(stm, record);
            stm.executeUpdate();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("status=recordProcessedSaved, statementTime={}", (Object)stopWatch.getTime());
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProducedRecord find(Connection connection, UUID id) {
        String sql = "SELECT * FROM TTO_RECORD_PROCESSED WHERE IDT_TTO_RECORD = ?";
        try (PreparedStatement stm = connection.prepareStatement("SELECT * FROM TTO_RECORD_PROCESSED WHERE IDT_TTO_RECORD = ?");){
            ProducedRecord producedRecord;
            block18: {
                ResultSet rs;
                block16: {
                    ProducedRecord producedRecord2;
                    block17: {
                        stm.setString(1, id.toString());
                        rs = stm.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            producedRecord2 = ProducedRecordConverter.map(rs);
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return producedRecord2;
                }
                producedRecord = null;
                if (rs == null) break block18;
                rs.close();
            }
            return producedRecord;
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }
}

