/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.dagger;

import com.mageddo.db.DB;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.RecordProcessedDAO;
import com.mageddo.tobby.RecordProcessedDAOGeneric;
import com.mageddo.tobby.RecordProcessedDAOGeneric_Factory;
import com.mageddo.tobby.dagger.DaosProducersModule;
import com.mageddo.tobby.dagger.DaosProducersModule_DbFactory;
import com.mageddo.tobby.dagger.DaosProducersModule_ProducerJdbcFactory;
import com.mageddo.tobby.dagger.DaosProducersModule_RecordDAOFactory;
import com.mageddo.tobby.dagger.TobbyConfig;
import com.mageddo.tobby.producer.Producer;
import com.mageddo.tobby.producer.ProducerJdbc;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DaggerTobbyConfig
implements TobbyConfig {
    private Provider<DB> dbProvider;
    private Provider<RecordDAO> recordDAOProvider;
    private Provider<ProducerJdbc> producerJdbcProvider;
    private Provider<RecordProcessedDAOGeneric> recordProcessedDAOGenericProvider;

    private DaggerTobbyConfig(DaosProducersModule daosProducersModuleParam) {
        this.initialize(daosProducersModuleParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(DaosProducersModule daosProducersModuleParam) {
        this.dbProvider = DoubleCheck.provider((Provider)DaosProducersModule_DbFactory.create(daosProducersModuleParam));
        this.recordDAOProvider = DoubleCheck.provider((Provider)DaosProducersModule_RecordDAOFactory.create(daosProducersModuleParam, this.dbProvider));
        this.producerJdbcProvider = DoubleCheck.provider((Provider)DaosProducersModule_ProducerJdbcFactory.create(daosProducersModuleParam, this.recordDAOProvider));
        this.recordProcessedDAOGenericProvider = DoubleCheck.provider((Provider)RecordProcessedDAOGeneric_Factory.create());
    }

    @Override
    public Producer producer() {
        return (Producer)this.producerJdbcProvider.get();
    }

    @Override
    public RecordDAO recordDAO() {
        return (RecordDAO)this.recordDAOProvider.get();
    }

    @Override
    public RecordProcessedDAO recordProcessedDAO() {
        return (RecordProcessedDAO)this.recordProcessedDAOGenericProvider.get();
    }

    public static final class Builder {
        private DaosProducersModule daosProducersModule;

        private Builder() {
        }

        public Builder daosProducersModule(DaosProducersModule daosProducersModule) {
            this.daosProducersModule = (DaosProducersModule)Preconditions.checkNotNull((Object)daosProducersModule);
            return this;
        }

        public TobbyConfig build() {
            Preconditions.checkBuilderRequirement((Object)this.daosProducersModule, DaosProducersModule.class);
            return new DaggerTobbyConfig(this.daosProducersModule);
        }
    }
}

