/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.dagger;

import com.mageddo.db.SimpleDataSource;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.RecordProcessedDAO;
import com.mageddo.tobby.dagger.DaggerTobbyConfig;
import com.mageddo.tobby.dagger.DaosProducersBindsModule;
import com.mageddo.tobby.dagger.DaosProducersModule;
import com.mageddo.tobby.factory.SerializerCreator;
import com.mageddo.tobby.internal.utils.Validator;
import com.mageddo.tobby.producer.kafka.JdbcKafkaProducerAdapter;
import com.mageddo.tobby.producer.kafka.SimpleJdbcKafkaProducerAdapter;
import dagger.Component;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

@Singleton
@Component(modules={DaosProducersModule.class, DaosProducersBindsModule.class})
public interface TobbyConfig {
    public com.mageddo.tobby.producer.Producer producer();

    public RecordDAO recordDAO();

    public RecordProcessedDAO recordProcessedDAO();

    default public <K, V> SimpleJdbcKafkaProducerAdapter<K, V> jdbcProducerAdapter(Class<? extends Serializer<K>> keySerializer, Class<? extends Serializer<V>> valueSerializer) {
        return new SimpleJdbcKafkaProducerAdapter(SerializerCreator.create(keySerializer, null), SerializerCreator.create(valueSerializer, null), this.producer());
    }

    default public <K, V> SimpleJdbcKafkaProducerAdapter<K, V> jdbcProducerAdapter(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.jdbcProducerAdapter(keySerializer, valueSerializer, this.producer());
    }

    default public <K, V> SimpleJdbcKafkaProducerAdapter<K, V> jdbcProducerAdapter(Serializer<K> keySerializer, Serializer<V> valueSerializer, com.mageddo.tobby.producer.Producer producer) {
        return new SimpleJdbcKafkaProducerAdapter<K, V>(keySerializer, valueSerializer, producer);
    }

    default public <K, V> JdbcKafkaProducerAdapter<K, V> jdbcProducerAdapter(Producer<K, V> delegate, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new JdbcKafkaProducerAdapter<K, V>(delegate, this.jdbcProducerAdapter(keySerializer, valueSerializer));
    }

    default public <K, V> JdbcKafkaProducerAdapter<K, V> jdbcProducerAdapter(Producer<K, V> delegate, Class<? extends Serializer<K>> keySerializer, Class<? extends Serializer<V>> valueSerializer) {
        return new JdbcKafkaProducerAdapter<K, V>(delegate, this.jdbcProducerAdapter(SerializerCreator.create(keySerializer, null), SerializerCreator.create(valueSerializer, null)));
    }

    public static TobbyConfig build(String url, String username, String password) {
        return TobbyConfig.build(new SimpleDataSource(url, password, username));
    }

    public static TobbyConfig build(DataSource dataSource) {
        Validator.isTrue(dataSource != null, "Data source can't be null", dataSource);
        return DaggerTobbyConfig.builder().daosProducersModule(new DaosProducersModule(dataSource)).build();
    }
}

