/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.factory;

import com.mageddo.tobby.internal.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import org.apache.kafka.common.serialization.Serializer;

public class SerializerCreator {
    public static <T> Serializer<T> create(Class<? extends Serializer<T>> clazz, Class<? extends Serializer<T>> defaultClass) {
        return SerializerCreator.create(clazz.getName(), defaultClass == null ? null : defaultClass.getName());
    }

    public static Serializer create(String clazz, String defaultClass) {
        if (StringUtils.isBlank(clazz)) {
            return (Serializer)SerializerCreator.newInstance(defaultClass);
        }
        return (Serializer)SerializerCreator.newInstance(clazz);
    }

    private static Object newInstance(String keySerializer) {
        try {
            return Class.forName(keySerializer).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private SerializerCreator() {
    }
}

