/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.internal.utils;

import com.mageddo.tobby.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    public static String getRootCauseMessage(Throwable th) {
        Throwable root = ExceptionUtils.getRootCause(th);
        root = root == null ? th : root;
        return ExceptionUtils.getMessage(root);
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String clsName = ExceptionUtils.getSimpleName(th);
        String msg = th.getMessage();
        return clsName + ": " + StringUtils.defaultString(msg);
    }

    private static String getSimpleName(Throwable th) {
        return th.getClass().getSimpleName();
    }

    private ExceptionUtils() {
    }
}

