/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.internal.utils;

import com.mageddo.tobby.internal.utils.UncheckedExecutionException;
import com.mageddo.tobby.internal.utils.UncheckedInterruptedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Threads {
    public static ExecutorService newPool(int size) {
        return Executors.newFixedThreadPool(size, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public static <V> List<V> executeAndGet(ExecutorService executorService, List<Callable<V>> callables) {
        ArrayList<Future<V>> futures = new ArrayList<Future<V>>();
        for (Callable<V> callable : callables) {
            futures.add(executorService.submit(callable));
        }
        return Threads.get(futures);
    }

    public static <V> List<V> get(List<Future<V>> futures) {
        ArrayList<V> results = new ArrayList<V>();
        for (Future<V> future : futures) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new UncheckedExecutionException(e);
            }
        }
        return results;
    }

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private Threads() {
    }
}

