/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.producer;

import com.mageddo.db.ConnectionUtils;
import com.mageddo.tobby.ProducedRecord;
import com.mageddo.tobby.ProducerRecord;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.UncheckedSQLException;
import com.mageddo.tobby.internal.utils.StopWatch;
import com.mageddo.tobby.producer.Producer;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerJdbc
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(ProducerJdbc.class);
    private final RecordDAO recordDAO;
    private final DataSource dataSource;

    public ProducerJdbc(RecordDAO recordDAO, DataSource dataSource) {
        this.recordDAO = recordDAO;
        this.dataSource = dataSource;
    }

    @Override
    public ProducedRecord send(ProducerRecord record) {
        StopWatch totalStopWatch = StopWatch.createStarted();
        try {
            ProducedRecord producedRecord;
            block12: {
                Connection connection = this.dataSource.getConnection();
                try {
                    producedRecord = ConnectionUtils.useTransaction(connection, () -> this.recordDAO.save(connection, record));
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new UncheckedSQLException(e);
                    }
                }
                connection.close();
            }
            return producedRecord;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("status=committed, total={}", (Object)totalStopWatch.getTime());
            }
        }
    }

    @Override
    public ProducedRecord send(Connection connection, ProducerRecord record) {
        return this.recordDAO.save(connection, record);
    }
}

