/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.producer.kafka;

import com.mageddo.tobby.producer.kafka.SimpleJdbcKafkaProducerAdapter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;

public class JdbcKafkaProducerAdapter<K, V>
implements Producer<K, V> {
    private final SimpleJdbcKafkaProducerAdapter<K, V> jdbcDelegate;
    private final Producer<K, V> kafkaDelegate;

    public JdbcKafkaProducerAdapter(Producer<K, V> kafkaDelegate, SimpleJdbcKafkaProducerAdapter<K, V> jdbcDelegate) {
        this.kafkaDelegate = kafkaDelegate;
        this.jdbcDelegate = jdbcDelegate;
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.jdbcDelegate.send(record);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        return this.jdbcDelegate.send(record, callback);
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.kafkaDelegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.kafkaDelegate.metrics();
    }

    public void flush() {
        this.kafkaDelegate.flush();
    }

    public void close() {
        this.jdbcDelegate.close();
        this.kafkaDelegate.close();
    }

    public void close(long timeout, TimeUnit unit) {
        this.jdbcDelegate.close(timeout, unit);
        this.kafkaDelegate.close(timeout, unit);
    }

    public void close(Duration timeout) {
        this.close(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void initTransactions() {
        this.jdbcDelegate.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.jdbcDelegate.initTransactions();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.jdbcDelegate.initTransactions();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.jdbcDelegate.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.jdbcDelegate.initTransactions();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.jdbcDelegate.initTransactions();
    }
}

