/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.producer.kafka;

import com.mageddo.tobby.internal.utils.SyncFuture;
import com.mageddo.tobby.producer.Producer;
import com.mageddo.tobby.producer.kafka.JdbcKafkaProducer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcKafkaProducerAdapter<K, V>
implements org.apache.kafka.clients.producer.Producer<K, V> {
    private static final Logger log = LoggerFactory.getLogger(SimpleJdbcKafkaProducerAdapter.class);
    private final JdbcKafkaProducer<K, V> jdbcKafkaProducer;

    public SimpleJdbcKafkaProducerAdapter(Serializer<K> keySerializer, Serializer<V> valueSerializer, Producer producer) {
        this(new JdbcKafkaProducer<K, V>(producer, keySerializer, valueSerializer));
    }

    public SimpleJdbcKafkaProducerAdapter(JdbcKafkaProducer<K, V> jdbcKafkaProducer) {
        this.jdbcKafkaProducer = jdbcKafkaProducer;
    }

    public void initTransactions() {
        this.transactionUnsupportedError();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.transactionUnsupportedError();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.transactionUnsupportedError();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.transactionUnsupportedError();
    }

    public void commitTransaction() throws ProducerFencedException {
        this.transactionUnsupportedError();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.transactionUnsupportedError();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        RecordMetadata produced = this.save(record);
        return this.buildPromise(produced);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        RecordMetadata metadata = this.save(record);
        try {
            callback.onCompletion(metadata, null);
        }
        catch (Throwable e) {
            log.warn("status=callbackFailed, msg={}", (Object)e.getMessage(), (Object)e);
        }
        return this.buildPromise(metadata);
    }

    public void flush() {
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return Collections.EMPTY_LIST;
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.EMPTY_MAP;
    }

    public void close() {
    }

    public void close(long timeout, TimeUnit unit) {
    }

    public void close(Duration timeout) {
    }

    private void transactionUnsupportedError() {
        throw new UnsupportedOperationException("This is a jdbc producer, no kafka transactions are necessary");
    }

    private Future<RecordMetadata> buildPromise(RecordMetadata metadata) {
        return new SyncFuture<RecordMetadata>(metadata);
    }

    private RecordMetadata save(ProducerRecord<K, V> record) {
        return this.jdbcKafkaProducer.send(record);
    }
}

