/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.producer.kafka.converter;

import com.mageddo.tobby.ProducedRecord;
import com.mageddo.tobby.producer.kafka.converter.HeadersConverter;
import java.sql.Timestamp;
import java.util.zip.CRC32;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;

public class ProducedRecordConverter {
    private ProducedRecordConverter() {
    }

    public static RecordMetadata toMetadata(ProducedRecord record) {
        return new RecordMetadata(new TopicPartition(record.getTopic(), record.getPartition() == null ? -1 : record.getPartition()), -1L, -1L, ProducedRecordConverter.toMillis(record), ProducedRecordConverter.digest(record), ProducedRecordConverter.calcSize(record.getKey()), ProducedRecordConverter.calcSize(record.getValue()));
    }

    public static ProducerRecord<byte[], byte[]> toKafkaProducerRecord(ProducedRecord record) {
        return new ProducerRecord(record.getTopic(), record.getPartition(), (Object)record.getKey(), (Object)record.getValue(), (Iterable)HeadersConverter.toKafkaHeaders(record.getHeaders()));
    }

    private static long toMillis(ProducedRecord record) {
        if (record.getCreatedAt() == null) {
            return -1L;
        }
        return Timestamp.valueOf(record.getCreatedAt()).toInstant().toEpochMilli();
    }

    private static int calcSize(byte[] record) {
        return record == null ? 0 : record.length;
    }

    private static Long digest(ProducedRecord record) {
        CRC32 digest = new CRC32();
        if (record.getKey() != null) {
            digest.update(record.getKey(), 0, record.getKey().length);
        }
        if (record.getValue() != null) {
            digest.update(record.getValue(), 0, record.getValue().length);
        }
        return digest.getValue();
    }
}

