/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.replicator;

import com.mageddo.db.ConnectionUtils;
import com.mageddo.tobby.ProducedRecord;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.replicator.BufferedReplicator;
import com.mageddo.tobby.replicator.Replicator;
import com.mageddo.tobby.replicator.StreamingIterator;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;

public class DeleteIdempotenceBasedReplicator
implements Replicator,
StreamingIterator {
    private final RecordDAO recordDAO;
    private final Connection writeConn;
    private final Connection readConn;
    private final BufferedReplicator replicator;
    private final int fetchSize;

    public DeleteIdempotenceBasedReplicator(Connection readConn, Connection writeConn, RecordDAO recordDAO, BufferedReplicator replicator, int fetchSize) {
        this.recordDAO = recordDAO;
        this.writeConn = writeConn;
        this.readConn = readConn;
        this.replicator = replicator;
        this.fetchSize = fetchSize;
    }

    @Override
    public boolean send(ProducedRecord record) {
        this.recordDAO.acquireDeleting(this.writeConn, record.getId());
        if (this.replicator.send(record)) {
            this.flush();
        }
        return false;
    }

    @Override
    public void flush() {
        ConnectionUtils.useTransaction(this.writeConn, this.replicator::flush);
    }

    @Override
    public int iterate(Connection readConn) {
        AtomicInteger counter = new AtomicInteger();
        this.recordDAO.iterateOverRecords(this.readConn, this.fetchSize, record -> {
            counter.incrementAndGet();
            this.send((ProducedRecord)record);
        });
        this.flush();
        return counter.get();
    }
}

