/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.replicator;

import com.mageddo.db.ConnectionUtils;
import com.mageddo.tobby.ProducedRecord;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.RecordProcessedDAO;
import com.mageddo.tobby.replicator.BufferedReplicator;
import com.mageddo.tobby.replicator.Replicator;
import com.mageddo.tobby.replicator.StreamingIterator;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;

public class DeleteWithHistoryIdempotenceBasedReplicator
implements Replicator,
StreamingIterator {
    private final RecordDAO recordDAO;
    private final RecordProcessedDAO recordProcessedDAO;
    private final Connection writeConn;
    private final Connection readConn;
    private final BufferedReplicator replicator;
    private final int fetchSize;

    public DeleteWithHistoryIdempotenceBasedReplicator(Connection readConn, Connection writeConn, RecordDAO recordDAO, RecordProcessedDAO recordProcessedDAO, BufferedReplicator replicator, int fetchSize) {
        this.recordDAO = recordDAO;
        this.writeConn = writeConn;
        this.readConn = readConn;
        this.recordProcessedDAO = recordProcessedDAO;
        this.replicator = replicator;
        this.fetchSize = fetchSize;
    }

    @Override
    public boolean send(ProducedRecord record) {
        this.recordDAO.acquireDeleting(this.writeConn, record.getId());
        this.recordProcessedDAO.save(this.writeConn, record);
        if (this.replicator.send(record)) {
            this.flush();
        }
        return false;
    }

    @Override
    public void flush() {
        ConnectionUtils.useTransaction(this.writeConn, this.replicator::flush);
    }

    @Override
    public int iterate(Connection readConn) {
        AtomicInteger counter = new AtomicInteger();
        this.recordDAO.iterateOverRecords(this.readConn, this.fetchSize, record -> {
            counter.incrementAndGet();
            this.send((ProducedRecord)record);
        });
        this.flush();
        return counter.get();
    }
}

