/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.replicator;

import com.mageddo.tobby.ParameterDAO;
import com.mageddo.tobby.RecordDAO;
import com.mageddo.tobby.RecordProcessedDAO;
import com.mageddo.tobby.replicator.BufferedReplicator;
import com.mageddo.tobby.replicator.DeleteIdempotenceBasedReplicator;
import com.mageddo.tobby.replicator.DeleteWithHistoryIdempotenceBasedReplicator;
import com.mageddo.tobby.replicator.InsertIdempotenceBasedReplicator;
import com.mageddo.tobby.replicator.ReplicatorConfig;
import com.mageddo.tobby.replicator.StreamingIterator;
import com.mageddo.tobby.replicator.idempotencestrategy.batchdelete.BatchDeleteIdempotenceBasedReplicator;
import com.mageddo.tobby.replicator.idempotencestrategy.batchdelete.BatchParallelDeleteIdempotenceBasedReplicator;
import com.mageddo.tobby.replicator.idempotencestrategy.batchdelete.DeleteMode;
import java.sql.Connection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IteratorFactory {
    private final RecordDAO recordDAO;
    private final ParameterDAO parameterDAO;
    private final RecordProcessedDAO recordProcessedDAO;
    private final BatchParallelDeleteIdempotenceBasedReplicator batchParallelDeleteIdempotenceBasedReplicator;

    @Inject
    public IteratorFactory(RecordDAO recordDAO, ParameterDAO parameterDAO, RecordProcessedDAO recordProcessedDAO, BatchParallelDeleteIdempotenceBasedReplicator batchParallelDeleteIdempotenceBasedReplicator) {
        this.recordDAO = recordDAO;
        this.parameterDAO = parameterDAO;
        this.recordProcessedDAO = recordProcessedDAO;
        this.batchParallelDeleteIdempotenceBasedReplicator = batchParallelDeleteIdempotenceBasedReplicator;
    }

    public StreamingIterator create(BufferedReplicator replicator, Connection readConn, Connection writeConn, ReplicatorConfig config) {
        switch (config.getIdempotenceStrategy()) {
            case INSERT: {
                return new InsertIdempotenceBasedReplicator(readConn, writeConn, this.recordDAO, this.parameterDAO, replicator, config.getMaxRecordDelayToCommit(), config.getFetchSize());
            }
            case DELETE: {
                return new DeleteIdempotenceBasedReplicator(readConn, writeConn, this.recordDAO, replicator, config.getFetchSize());
            }
            case DELETE_WITH_HISTORY: {
                return new DeleteWithHistoryIdempotenceBasedReplicator(readConn, writeConn, this.recordDAO, this.recordProcessedDAO, replicator, config.getFetchSize());
            }
            case BATCH_DELETE: {
                return new BatchDeleteIdempotenceBasedReplicator(readConn, writeConn, this.recordDAO, replicator, config.getFetchSize(), DeleteMode.valueOf(config.get("replicators.batch-delete.delete-mode")));
            }
            case BATCH_PARALLEL_DELETE: {
                return this.batchParallelDeleteIdempotenceBasedReplicator;
            }
        }
        throw new IllegalArgumentException("Not strategy implemented for: " + (Object)((Object)config.getIdempotenceStrategy()));
    }
}

