/*
 * Decompiled with CFR 0.152.
 */
package com.mageddo.tobby.replicator;

import com.mageddo.tobby.replicator.IdempotenceStrategy;
import com.mageddo.tobby.replicator.ReplicatorContextVars;
import com.mageddo.tobby.replicator.idempotencestrategy.batchdelete.DeleteMode;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.kafka.clients.producer.Producer;

public final class ReplicatorConfig {
    public static final Duration DEFAULT_MAX_RECORD_DELAY_TO_COMMIT = Duration.ofMinutes(15L);
    public static final String REPLICATORS_BATCH_DELETE_DELETE_MODE = "replicators.batch-delete.delete-mode";
    public static final String REPLICATORS_BATCH_PARALLEL_DELETE_MODE = "replicators.batch-parallel-delete.delete-mode";
    public static final String REPLICATORS_BATCH_PARALLEL_THREADS = "replicators.batch-parallel-delete.threads";
    public static final String REPLICATORS_BATCH_PARALLEL_BUFFER_SIZE = "replicators.batch-parallel-delete.buffer-size";
    public static final String REPLICATORS_BATCH_PARALLEL_THREAD_BUFFER_SIZE = "replicators.batch-parallel-delete.thread-buffer-size";
    @NonNull
    private final Producer<byte[], byte[]> producer;
    @NonNull
    private final DataSource dataSource;
    @NonNull
    private final Duration idleTimeout;
    @NonNull
    private final IdempotenceStrategy idempotenceStrategy;
    @NonNull
    private final Duration maxRecordDelayToCommit;
    private final int bufferSize;
    private final int fetchSize;
    @NonNull
    private final Map<String, String> props;
    @NonNull
    private final Predicate<ReplicatorContextVars> stopPredicate;

    public int getInt(String key) {
        this.validateIsSet(key);
        return Integer.parseInt(this.props.get(key));
    }

    public String get(String key) {
        this.validateIsSet(key);
        return this.props.get(key);
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.props);
    }

    private void validateIsSet(String key) {
        if (!this.props.containsKey(key) || this.props.get(key) == null) {
            throw new IllegalStateException(String.format("Prop not set %s", key));
        }
    }

    private static Duration $default$idleTimeout() {
        return Duration.ZERO;
    }

    private static IdempotenceStrategy $default$idempotenceStrategy() {
        return IdempotenceStrategy.DELETE;
    }

    private static Duration $default$maxRecordDelayToCommit() {
        return DEFAULT_MAX_RECORD_DELAY_TO_COMMIT;
    }

    private static int $default$bufferSize() {
        return 20000;
    }

    private static int $default$fetchSize() {
        return 50000;
    }

    private static Predicate<ReplicatorContextVars> $default$stopPredicate() {
        return it -> false;
    }

    ReplicatorConfig(@NonNull Producer<byte[], byte[]> producer, @NonNull DataSource dataSource, @NonNull Duration idleTimeout, @NonNull IdempotenceStrategy idempotenceStrategy, @NonNull Duration maxRecordDelayToCommit, int bufferSize, int fetchSize, @NonNull Map<String, String> props, @NonNull Predicate<ReplicatorContextVars> stopPredicate) {
        if (producer == null) {
            throw new NullPointerException("producer is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (idleTimeout == null) {
            throw new NullPointerException("idleTimeout is marked non-null but is null");
        }
        if (idempotenceStrategy == null) {
            throw new NullPointerException("idempotenceStrategy is marked non-null but is null");
        }
        if (maxRecordDelayToCommit == null) {
            throw new NullPointerException("maxRecordDelayToCommit is marked non-null but is null");
        }
        if (props == null) {
            throw new NullPointerException("props is marked non-null but is null");
        }
        if (stopPredicate == null) {
            throw new NullPointerException("stopPredicate is marked non-null but is null");
        }
        this.producer = producer;
        this.dataSource = dataSource;
        this.idleTimeout = idleTimeout;
        this.idempotenceStrategy = idempotenceStrategy;
        this.maxRecordDelayToCommit = maxRecordDelayToCommit;
        this.bufferSize = bufferSize;
        this.fetchSize = fetchSize;
        this.props = props;
        this.stopPredicate = stopPredicate;
    }

    public static ReplicatorConfigBuilder builder() {
        return new ReplicatorConfigBuilder();
    }

    public ReplicatorConfigBuilder toBuilder() {
        return new ReplicatorConfigBuilder().producer(this.producer).dataSource(this.dataSource).idleTimeout(this.idleTimeout).idempotenceStrategy(this.idempotenceStrategy).maxRecordDelayToCommit(this.maxRecordDelayToCommit).bufferSize(this.bufferSize).fetchSize(this.fetchSize).props(this.props).stopPredicate(this.stopPredicate);
    }

    @NonNull
    public Producer<byte[], byte[]> getProducer() {
        return this.producer;
    }

    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @NonNull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @NonNull
    public IdempotenceStrategy getIdempotenceStrategy() {
        return this.idempotenceStrategy;
    }

    @NonNull
    public Duration getMaxRecordDelayToCommit() {
        return this.maxRecordDelayToCommit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @NonNull
    public Predicate<ReplicatorContextVars> getStopPredicate() {
        return this.stopPredicate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplicatorConfig)) {
            return false;
        }
        ReplicatorConfig other = (ReplicatorConfig)o;
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        if (this.getFetchSize() != other.getFetchSize()) {
            return false;
        }
        Producer<byte[], byte[]> this$producer = this.getProducer();
        Producer<byte[], byte[]> other$producer = other.getProducer();
        if (this$producer == null ? other$producer != null : !this$producer.equals(other$producer)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        Duration this$idleTimeout = this.getIdleTimeout();
        Duration other$idleTimeout = other.getIdleTimeout();
        if (this$idleTimeout == null ? other$idleTimeout != null : !((Object)this$idleTimeout).equals(other$idleTimeout)) {
            return false;
        }
        IdempotenceStrategy this$idempotenceStrategy = this.getIdempotenceStrategy();
        IdempotenceStrategy other$idempotenceStrategy = other.getIdempotenceStrategy();
        if (this$idempotenceStrategy == null ? other$idempotenceStrategy != null : !((Object)((Object)this$idempotenceStrategy)).equals((Object)other$idempotenceStrategy)) {
            return false;
        }
        Duration this$maxRecordDelayToCommit = this.getMaxRecordDelayToCommit();
        Duration other$maxRecordDelayToCommit = other.getMaxRecordDelayToCommit();
        if (this$maxRecordDelayToCommit == null ? other$maxRecordDelayToCommit != null : !((Object)this$maxRecordDelayToCommit).equals(other$maxRecordDelayToCommit)) {
            return false;
        }
        Map<String, String> this$props = this.getProps();
        Map<String, String> other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        Predicate<ReplicatorContextVars> this$stopPredicate = this.getStopPredicate();
        Predicate<ReplicatorContextVars> other$stopPredicate = other.getStopPredicate();
        return !(this$stopPredicate == null ? other$stopPredicate != null : !this$stopPredicate.equals(other$stopPredicate));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBufferSize();
        result = result * 59 + this.getFetchSize();
        Producer<byte[], byte[]> $producer = this.getProducer();
        result = result * 59 + ($producer == null ? 43 : $producer.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        Duration $idleTimeout = this.getIdleTimeout();
        result = result * 59 + ($idleTimeout == null ? 43 : ((Object)$idleTimeout).hashCode());
        IdempotenceStrategy $idempotenceStrategy = this.getIdempotenceStrategy();
        result = result * 59 + ($idempotenceStrategy == null ? 43 : ((Object)((Object)$idempotenceStrategy)).hashCode());
        Duration $maxRecordDelayToCommit = this.getMaxRecordDelayToCommit();
        result = result * 59 + ($maxRecordDelayToCommit == null ? 43 : ((Object)$maxRecordDelayToCommit).hashCode());
        Map<String, String> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        Predicate<ReplicatorContextVars> $stopPredicate = this.getStopPredicate();
        result = result * 59 + ($stopPredicate == null ? 43 : $stopPredicate.hashCode());
        return result;
    }

    public String toString() {
        return "ReplicatorConfig(producer=" + this.getProducer() + ", dataSource=" + this.getDataSource() + ", idleTimeout=" + this.getIdleTimeout() + ", idempotenceStrategy=" + (Object)((Object)this.getIdempotenceStrategy()) + ", maxRecordDelayToCommit=" + this.getMaxRecordDelayToCommit() + ", bufferSize=" + this.getBufferSize() + ", fetchSize=" + this.getFetchSize() + ", props=" + this.getProps() + ", stopPredicate=" + this.getStopPredicate() + ")";
    }

    public static class ReplicatorConfigBuilder {
        private Producer<byte[], byte[]> producer;
        private DataSource dataSource;
        private boolean idleTimeout$set;
        private Duration idleTimeout$value;
        private boolean idempotenceStrategy$set;
        private IdempotenceStrategy idempotenceStrategy$value;
        private boolean maxRecordDelayToCommit$set;
        private Duration maxRecordDelayToCommit$value;
        private boolean bufferSize$set;
        private int bufferSize$value;
        private boolean fetchSize$set;
        private int fetchSize$value;
        private Map<String, String> props = ReplicatorConfigBuilder.buildDefaultProps();
        private boolean stopPredicate$set;
        private Predicate<ReplicatorContextVars> stopPredicate$value;

        public ReplicatorConfigBuilder put(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        private static Map<String, String> buildDefaultProps() {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ReplicatorConfig.REPLICATORS_BATCH_DELETE_DELETE_MODE, DeleteMode.BATCH_DELETE_USING_IN.name());
            props.put(ReplicatorConfig.REPLICATORS_BATCH_PARALLEL_BUFFER_SIZE, String.valueOf(20000));
            props.put(ReplicatorConfig.REPLICATORS_BATCH_PARALLEL_THREADS, "10");
            props.put(ReplicatorConfig.REPLICATORS_BATCH_PARALLEL_DELETE_MODE, DeleteMode.BATCH_DELETE_USING_IN.name());
            props.put(ReplicatorConfig.REPLICATORS_BATCH_PARALLEL_THREAD_BUFFER_SIZE, String.valueOf(1000));
            return props;
        }

        public ReplicatorConfigBuilder producer(@NonNull Producer<byte[], byte[]> producer) {
            if (producer == null) {
                throw new NullPointerException("producer is marked non-null but is null");
            }
            this.producer = producer;
            return this;
        }

        public ReplicatorConfigBuilder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        public ReplicatorConfigBuilder idleTimeout(@NonNull Duration idleTimeout) {
            if (idleTimeout == null) {
                throw new NullPointerException("idleTimeout is marked non-null but is null");
            }
            this.idleTimeout$value = idleTimeout;
            this.idleTimeout$set = true;
            return this;
        }

        public ReplicatorConfigBuilder idempotenceStrategy(@NonNull IdempotenceStrategy idempotenceStrategy) {
            if (idempotenceStrategy == null) {
                throw new NullPointerException("idempotenceStrategy is marked non-null but is null");
            }
            this.idempotenceStrategy$value = idempotenceStrategy;
            this.idempotenceStrategy$set = true;
            return this;
        }

        public ReplicatorConfigBuilder maxRecordDelayToCommit(@NonNull Duration maxRecordDelayToCommit) {
            if (maxRecordDelayToCommit == null) {
                throw new NullPointerException("maxRecordDelayToCommit is marked non-null but is null");
            }
            this.maxRecordDelayToCommit$value = maxRecordDelayToCommit;
            this.maxRecordDelayToCommit$set = true;
            return this;
        }

        public ReplicatorConfigBuilder bufferSize(int bufferSize) {
            this.bufferSize$value = bufferSize;
            this.bufferSize$set = true;
            return this;
        }

        public ReplicatorConfigBuilder fetchSize(int fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return this;
        }

        public ReplicatorConfigBuilder props(@NonNull Map<String, String> props) {
            if (props == null) {
                throw new NullPointerException("props is marked non-null but is null");
            }
            this.props = props;
            return this;
        }

        public ReplicatorConfigBuilder stopPredicate(@NonNull Predicate<ReplicatorContextVars> stopPredicate) {
            if (stopPredicate == null) {
                throw new NullPointerException("stopPredicate is marked non-null but is null");
            }
            this.stopPredicate$value = stopPredicate;
            this.stopPredicate$set = true;
            return this;
        }

        public ReplicatorConfig build() {
            Duration idleTimeout$value = this.idleTimeout$value;
            if (!this.idleTimeout$set) {
                idleTimeout$value = ReplicatorConfig.$default$idleTimeout();
            }
            IdempotenceStrategy idempotenceStrategy$value = this.idempotenceStrategy$value;
            if (!this.idempotenceStrategy$set) {
                idempotenceStrategy$value = ReplicatorConfig.$default$idempotenceStrategy();
            }
            Duration maxRecordDelayToCommit$value = this.maxRecordDelayToCommit$value;
            if (!this.maxRecordDelayToCommit$set) {
                maxRecordDelayToCommit$value = ReplicatorConfig.$default$maxRecordDelayToCommit();
            }
            int bufferSize$value = this.bufferSize$value;
            if (!this.bufferSize$set) {
                bufferSize$value = ReplicatorConfig.$default$bufferSize();
            }
            int fetchSize$value = this.fetchSize$value;
            if (!this.fetchSize$set) {
                fetchSize$value = ReplicatorConfig.$default$fetchSize();
            }
            Predicate stopPredicate$value = this.stopPredicate$value;
            if (!this.stopPredicate$set) {
                stopPredicate$value = ReplicatorConfig.$default$stopPredicate();
            }
            return new ReplicatorConfig(this.producer, this.dataSource, idleTimeout$value, idempotenceStrategy$value, maxRecordDelayToCommit$value, bufferSize$value, fetchSize$value, this.props, stopPredicate$value);
        }

        public String toString() {
            return "ReplicatorConfig.ReplicatorConfigBuilder(producer=" + this.producer + ", dataSource=" + this.dataSource + ", idleTimeout$value=" + this.idleTimeout$value + ", idempotenceStrategy$value=" + (Object)((Object)this.idempotenceStrategy$value) + ", maxRecordDelayToCommit$value=" + this.maxRecordDelayToCommit$value + ", bufferSize$value=" + this.bufferSize$value + ", fetchSize$value=" + this.fetchSize$value + ", props=" + this.props + ", stopPredicate$value=" + this.stopPredicate$value + ")";
        }
    }
}

