/*
 * The MIT License
 * Copyright (c) 2012 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package microsoft.exchange.webservices.data;

/**
 * Class that holds all constants.
 */
public class EWSConstants {
        /*
         * Represents SRV record.
	 */
  /**
   * The Constant SRVRECORD.
   */
  public static final String SRVRECORD = "SRV";
        /*
	 * Represents the name of the domain
	 */
  /**
   * The Constant DOMAIN.
   */
  public static final String DOMAIN = "domain";
	/*
	 * Represents the domain server IP address
	 */
  /**
   * The Constant DNSSERVERADDRESS.
   */
  public static final String DNSSERVERADDRESS = "dnsServerAddress";
	/*
	 * Represents the name of the property file
	 */
  /**
   * The Constant EWS_PROP_FILE.
   */
  public static final String EWS_PROP_FILE = "ews.property";

  /**
   * The Constant HTTP_SCHEME.
   */
  public static final String HTTP_SCHEME = "http";

  /**
   * The Constant HTTPS_SCHEME.
   */
  public static final String HTTPS_SCHEME = "https";

}
