/*
 * The MIT License
 * Copyright (c) 2012 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package microsoft.exchange.webservices.data.core.enumeration.property;

/**
 * Defines the MAPI type of an extended property.
 */
public enum MapiPropertyType {

  // The property is of type ApplicationTime.
  /**
   * The Application time.
   */
  ApplicationTime,

  // The property is of type ApplicationTimeArray.
  /**
   * The Application time array.
   */
  ApplicationTimeArray,

  // The property is of type Binary.
  /**
   * The Binary.
   */
  Binary,

  // The property is of type BinaryArray.
  /**
   * The Binary array.
   */
  BinaryArray,

  // The property is of type Boolean.
  /**
   * The Boolean.
   */
  Boolean,

  // The property is of type CLSID.
  /**
   * The CLSID.
   */
  CLSID,

  // The property is of type CLSIDArray.
  /**
   * The CLSID array.
   */
  CLSIDArray,

  // The property is of type Currency.
  /**
   * The Currency.
   */
  Currency,

  // The property is of type CurrencyArray.
  /**
   * The Currency array.
   */
  CurrencyArray,

  // The property is of type Double.
  /**
   * The Double.
   */
  Double,

  // The property is of type DoubleArray.
  /**
   * The Double array.
   */
  DoubleArray,

  // The property is of type Error.
  /**
   * The Error.
   */
  Error,

  // The property is of type Float.
  /**
   * The Float.
   */
  Float,

  // The property is of type FloatArray.
  /**
   * The Float array.
   */
  FloatArray,

  // The property is of type Integer.
  /**
   * The Integer.
   */
  Integer,

  // The property is of type IntegerArray.
  /**
   * The Integer array.
   */
  IntegerArray,

  // The property is of type Long.
  /**
   * The Long.
   */
  Long,

  // The property is of type LongArray.
  /**
   * The Long array.
   */
  LongArray,

  // The property is of type Null.
  /**
   * The Null.
   */
  Null,

  // The property is of type Object.
  /**
   * The Object.
   */
  Object,

  // The property is of type ObjectArray.
  /**
   * The Object array.
   */
  ObjectArray,

  // The property is of type Short.
  /**
   * The Short.
   */
  Short,

  // The property is of type ShortArray.
  /**
   * The Short array.
   */
  ShortArray,

  // The property is of type SystemTime.
  /**
   * The System time.
   */
  SystemTime,

  // The property is of type SystemTimeArray.
  /**
   * The System time array.
   */
  SystemTimeArray,

  // The property is of type String.
  /**
   * The String.
   */
  String,

  // The property is of type StringArray.
  /**
   * The String array.
   */
  StringArray
}
