/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.exception.error;

import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

public final class UserSettingError {
    private AutodiscoverErrorCode errorCode;
    private String errorMessage;
    private String settingName;

    public UserSettingError() {
    }

    protected UserSettingError(AutodiscoverErrorCode errorCode, String errorMessage, String settingName) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.settingName = settingName;
    }

    public void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("ErrorCode")) {
                this.setErrorCode(reader.readElementValue(AutodiscoverErrorCode.class));
                continue;
            }
            if (reader.getLocalName().equals("ErrorMessage")) {
                this.setErrorMessage(reader.readElementValue());
                continue;
            }
            if (!reader.getLocalName().equals("SettingName")) continue;
            this.setSettingName(reader.readElementValue());
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "UserSettingError"));
    }

    public AutodiscoverErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(AutodiscoverErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSettingName() {
        return this.settingName;
    }

    public void setSettingName(String settingName) {
        this.settingName = settingName;
    }
}

