/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import microsoft.exchange.webservices.data.autodiscover.AutodiscoverService;
import microsoft.exchange.webservices.data.autodiscover.IAutodiscoverRedirectionUrl;
import microsoft.exchange.webservices.data.autodiscover.enumeration.UserSettingName;
import microsoft.exchange.webservices.data.autodiscover.exception.AutodiscoverLocalException;
import microsoft.exchange.webservices.data.autodiscover.request.ApplyConversationActionRequest;
import microsoft.exchange.webservices.data.autodiscover.response.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeServiceBase;
import microsoft.exchange.webservices.data.core.IFileAttachmentContentHandler;
import microsoft.exchange.webservices.data.core.IPredicate;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConversationActionType;
import microsoft.exchange.webservices.data.core.enumeration.misc.DateTimePrecision;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.IdFormat;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.enumeration.misc.UserConfigurationProperties;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.ResolveNameSearchLocation;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.AccountIsLockedException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRemoteException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.request.AddDelegateRequest;
import microsoft.exchange.webservices.data.core.request.ConvertIdRequest;
import microsoft.exchange.webservices.data.core.request.CopyFolderRequest;
import microsoft.exchange.webservices.data.core.request.CopyItemRequest;
import microsoft.exchange.webservices.data.core.request.CreateAttachmentRequest;
import microsoft.exchange.webservices.data.core.request.CreateFolderRequest;
import microsoft.exchange.webservices.data.core.request.CreateItemRequest;
import microsoft.exchange.webservices.data.core.request.CreateResponseObjectRequest;
import microsoft.exchange.webservices.data.core.request.CreateUserConfigurationRequest;
import microsoft.exchange.webservices.data.core.request.DeleteAttachmentRequest;
import microsoft.exchange.webservices.data.core.request.DeleteFolderRequest;
import microsoft.exchange.webservices.data.core.request.DeleteItemRequest;
import microsoft.exchange.webservices.data.core.request.DeleteUserConfigurationRequest;
import microsoft.exchange.webservices.data.core.request.EmptyFolderRequest;
import microsoft.exchange.webservices.data.core.request.ExecuteDiagnosticMethodRequest;
import microsoft.exchange.webservices.data.core.request.ExpandGroupRequest;
import microsoft.exchange.webservices.data.core.request.FindConversationRequest;
import microsoft.exchange.webservices.data.core.request.FindFolderRequest;
import microsoft.exchange.webservices.data.core.request.FindItemRequest;
import microsoft.exchange.webservices.data.core.request.GetAttachmentRequest;
import microsoft.exchange.webservices.data.core.request.GetDelegateRequest;
import microsoft.exchange.webservices.data.core.request.GetEventsRequest;
import microsoft.exchange.webservices.data.core.request.GetFolderRequest;
import microsoft.exchange.webservices.data.core.request.GetFolderRequestForLoad;
import microsoft.exchange.webservices.data.core.request.GetInboxRulesRequest;
import microsoft.exchange.webservices.data.core.request.GetItemRequest;
import microsoft.exchange.webservices.data.core.request.GetItemRequestForLoad;
import microsoft.exchange.webservices.data.core.request.GetPasswordExpirationDateRequest;
import microsoft.exchange.webservices.data.core.request.GetRoomListsRequest;
import microsoft.exchange.webservices.data.core.request.GetRoomsRequest;
import microsoft.exchange.webservices.data.core.request.GetServerTimeZonesRequest;
import microsoft.exchange.webservices.data.core.request.GetUserAvailabilityRequest;
import microsoft.exchange.webservices.data.core.request.GetUserConfigurationRequest;
import microsoft.exchange.webservices.data.core.request.GetUserOofSettingsRequest;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.MoveFolderRequest;
import microsoft.exchange.webservices.data.core.request.MoveItemRequest;
import microsoft.exchange.webservices.data.core.request.RemoveDelegateRequest;
import microsoft.exchange.webservices.data.core.request.ResolveNamesRequest;
import microsoft.exchange.webservices.data.core.request.SendItemRequest;
import microsoft.exchange.webservices.data.core.request.SetUserOofSettingsRequest;
import microsoft.exchange.webservices.data.core.request.SubscribeToPullNotificationsRequest;
import microsoft.exchange.webservices.data.core.request.SubscribeToPushNotificationsRequest;
import microsoft.exchange.webservices.data.core.request.SubscribeToStreamingNotificationsRequest;
import microsoft.exchange.webservices.data.core.request.SyncFolderHierarchyRequest;
import microsoft.exchange.webservices.data.core.request.SyncFolderItemsRequest;
import microsoft.exchange.webservices.data.core.request.UnsubscribeRequest;
import microsoft.exchange.webservices.data.core.request.UpdateDelegateRequest;
import microsoft.exchange.webservices.data.core.request.UpdateFolderRequest;
import microsoft.exchange.webservices.data.core.request.UpdateInboxRulesRequest;
import microsoft.exchange.webservices.data.core.request.UpdateItemRequest;
import microsoft.exchange.webservices.data.core.request.UpdateUserConfigurationRequest;
import microsoft.exchange.webservices.data.core.response.ConvertIdResponse;
import microsoft.exchange.webservices.data.core.response.CreateAttachmentResponse;
import microsoft.exchange.webservices.data.core.response.CreateResponseObjectResponse;
import microsoft.exchange.webservices.data.core.response.DelegateManagementResponse;
import microsoft.exchange.webservices.data.core.response.DelegateUserResponse;
import microsoft.exchange.webservices.data.core.response.DeleteAttachmentResponse;
import microsoft.exchange.webservices.data.core.response.ExecuteDiagnosticMethodResponse;
import microsoft.exchange.webservices.data.core.response.ExpandGroupResponse;
import microsoft.exchange.webservices.data.core.response.FindFolderResponse;
import microsoft.exchange.webservices.data.core.response.FindItemResponse;
import microsoft.exchange.webservices.data.core.response.GetAttachmentResponse;
import microsoft.exchange.webservices.data.core.response.GetDelegateResponse;
import microsoft.exchange.webservices.data.core.response.GetEventsResponse;
import microsoft.exchange.webservices.data.core.response.GetFolderResponse;
import microsoft.exchange.webservices.data.core.response.GetItemResponse;
import microsoft.exchange.webservices.data.core.response.GetServerTimeZonesResponse;
import microsoft.exchange.webservices.data.core.response.GetUserConfigurationResponse;
import microsoft.exchange.webservices.data.core.response.MoveCopyFolderResponse;
import microsoft.exchange.webservices.data.core.response.MoveCopyItemResponse;
import microsoft.exchange.webservices.data.core.response.ResolveNamesResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponseCollection;
import microsoft.exchange.webservices.data.core.response.SubscribeResponse;
import microsoft.exchange.webservices.data.core.response.SyncFolderHierarchyResponse;
import microsoft.exchange.webservices.data.core.response.SyncFolderItemsResponse;
import microsoft.exchange.webservices.data.core.response.UpdateItemResponse;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Conversation;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.messaging.UnifiedMessaging;
import microsoft.exchange.webservices.data.misc.AsyncCallback;
import microsoft.exchange.webservices.data.misc.AsyncRequestResult;
import microsoft.exchange.webservices.data.misc.ConversationAction;
import microsoft.exchange.webservices.data.misc.DelegateInformation;
import microsoft.exchange.webservices.data.misc.ExpandGroupResults;
import microsoft.exchange.webservices.data.misc.FolderIdWrapper;
import microsoft.exchange.webservices.data.misc.IAsyncResult;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.misc.NameResolutionCollection;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.misc.UserConfiguration;
import microsoft.exchange.webservices.data.misc.availability.AttendeeInfo;
import microsoft.exchange.webservices.data.misc.availability.AvailabilityOptions;
import microsoft.exchange.webservices.data.misc.availability.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.misc.availability.TimeWindow;
import microsoft.exchange.webservices.data.misc.id.AlternateIdBase;
import microsoft.exchange.webservices.data.notification.GetEventsResults;
import microsoft.exchange.webservices.data.notification.PullSubscription;
import microsoft.exchange.webservices.data.notification.PushSubscription;
import microsoft.exchange.webservices.data.notification.StreamingSubscription;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.ConversationId;
import microsoft.exchange.webservices.data.property.complex.DelegateUser;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.complex.RuleCollection;
import microsoft.exchange.webservices.data.property.complex.RuleOperation;
import microsoft.exchange.webservices.data.property.complex.StringList;
import microsoft.exchange.webservices.data.property.complex.UserId;
import microsoft.exchange.webservices.data.property.complex.availability.OofSettings;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.CalendarView;
import microsoft.exchange.webservices.data.search.ConversationIndexedItemView;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.GroupedFindItemsResults;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.ViewBase;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import microsoft.exchange.webservices.data.sync.ChangeCollection;
import microsoft.exchange.webservices.data.sync.FolderChange;
import microsoft.exchange.webservices.data.sync.ItemChange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExchangeService
extends ExchangeServiceBase
implements IAutodiscoverRedirectionUrl {
    private static final Log LOG = LogFactory.getLog(ExchangeService.class);
    private URI url;
    private Locale preferredCulture;
    private DateTimePrecision dateTimePrecision = DateTimePrecision.Default;
    private ImpersonatedUserId impersonatedUserId;
    private IFileAttachmentContentHandler fileAttachmentContentHandler;
    private UnifiedMessaging unifiedMessaging;
    private boolean enableScpLookup = true;
    private boolean exchange2007CompatibilityMode = false;

    public List<Item> internalCreateResponseObject(ServiceObject responseObject, FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        CreateResponseObjectRequest request = new CreateResponseObjectRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<ServiceObject> serviceList = new ArrayList<ServiceObject>();
        serviceList.add(responseObject);
        request.setParentFolderId(parentFolderId);
        request.setItems(serviceList);
        request.setMessageDisposition(messageDisposition);
        ServiceResponseCollection responses = request.execute();
        return ((CreateResponseObjectResponse)responses.getResponseAtIndex(0)).getItems();
    }

    public void createFolder(Folder folder, FolderId parentFolderId) throws Exception {
        CreateFolderRequest request = new CreateFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<Folder> folArry = new ArrayList<Folder>();
        folArry.add(folder);
        request.setFolders(folArry);
        request.setParentFolderId(parentFolderId);
        request.execute();
    }

    public void updateFolder(Folder folder) throws Exception {
        UpdateFolderRequest request = new UpdateFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolders().add(folder);
        request.execute();
    }

    public Folder copyFolder(FolderId folderId, FolderId destinationFolderId) throws Exception {
        CopyFolderRequest request = new CopyFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.setDestinationFolderId(destinationFolderId);
        request.getFolderIds().add(folderId);
        ServiceResponseCollection responses = request.execute();
        return ((MoveCopyFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    public Folder moveFolder(FolderId folderId, FolderId destinationFolderId) throws Exception {
        MoveFolderRequest request = new MoveFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.setDestinationFolderId(destinationFolderId);
        request.getFolderIds().add(folderId);
        ServiceResponseCollection responses = request.execute();
        return ((MoveCopyFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    private ServiceResponseCollection<FindFolderResponse> internalFindFolders(Iterable<FolderId> parentFolderIds, SearchFilter searchFilter, FolderView view, ServiceErrorHandling errorHandlingMode) throws Exception {
        FindFolderRequest request = new FindFolderRequest(this, errorHandlingMode);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchFilter(searchFilter);
        request.setView(view);
        return request.execute();
    }

    public FindFoldersResults findFolders(FolderId parentFolderId, SearchFilter searchFilter, FolderView view) throws Exception {
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection<FindFolderResponse> responses = this.internalFindFolders(folderIdArray, searchFilter, view, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindFoldersResults findFolders(FolderId parentFolderId, FolderView view) throws Exception {
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        EwsUtilities.validateParam(view, "view");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection<FindFolderResponse> responses = this.internalFindFolders(folderIdArray, null, view, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindFoldersResults findFolders(WellKnownFolderName parentFolderName, SearchFilter searchFilter, FolderView view) throws Exception {
        return this.findFolders(new FolderId(parentFolderName), searchFilter, view);
    }

    public FindFoldersResults findFolders(WellKnownFolderName parentFolderName, FolderView view) throws Exception {
        return this.findFolders(new FolderId(parentFolderName), view);
    }

    public void loadPropertiesForFolder(Folder folder, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(folder, "folder");
        EwsUtilities.validateParam(propertySet, "propertySet");
        GetFolderRequestForLoad request = new GetFolderRequestForLoad(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folder);
        request.setPropertySet(propertySet);
        request.execute();
    }

    public Folder bindToFolder(FolderId folderId, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        GetFolderRequest request = new GetFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setPropertySet(propertySet);
        ServiceResponseCollection responses = request.execute();
        return ((GetFolderResponse)responses.getResponseAtIndex(0)).getFolder();
    }

    public <TFolder extends Folder> TFolder bindToFolder(Class<TFolder> cls, FolderId folderId, PropertySet propertySet) throws Exception {
        Folder result = this.bindToFolder(folderId, propertySet);
        if (cls.isAssignableFrom(result.getClass())) {
            return (TFolder)result;
        }
        throw new ServiceLocalException(String.format("The folder type returned by the service (%s) isn't compatible with the requested folder type (%s).", result.getClass().getName(), cls.getName()));
    }

    public void deleteFolder(FolderId folderId, DeleteMode deleteMode) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        DeleteFolderRequest request = new DeleteFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setDeleteMode(deleteMode);
        request.execute();
    }

    public void emptyFolder(FolderId folderId, DeleteMode deleteMode, boolean deleteSubFolders) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        EmptyFolderRequest request = new EmptyFolderRequest(this, ServiceErrorHandling.ThrowOnError);
        request.getFolderIds().add(folderId);
        request.setDeleteMode(deleteMode);
        request.setDeleteSubFolders(deleteSubFolders);
        request.execute();
    }

    private ServiceResponseCollection<ServiceResponse> internalCreateItems(Collection<Item> items, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode, ServiceErrorHandling errorHandling) throws Exception {
        CreateItemRequest request = new CreateItemRequest(this, errorHandling);
        request.setParentFolderId(parentFolderId);
        request.setItems(items);
        request.setMessageDisposition(messageDisposition);
        request.setSendInvitationsMode(sendInvitationsMode);
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> createItems(Collection<Item> items, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception {
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return obj.isNew();
            }
        })) {
            throw new ServiceValidationException("This operation can't be performed because at least one item already has an ID.");
        }
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.hasUnprocessedAttachmentChanges();
            }
        })) {
            throw new ServiceValidationException("This operation doesn't support item that have attachments.");
        }
        return this.internalCreateItems(items, parentFolderId, messageDisposition, sendInvitationsMode, ServiceErrorHandling.ReturnErrors);
    }

    public void createItem(Item item, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(item);
        this.internalCreateItems(items, parentFolderId, messageDisposition, sendInvitationsMode, ServiceErrorHandling.ThrowOnError);
    }

    private ServiceResponseCollection<UpdateItemResponse> internalUpdateItems(Iterable<Item> items, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode, ServiceErrorHandling errorHandling) throws Exception {
        UpdateItemRequest request = new UpdateItemRequest(this, errorHandling);
        request.getItems().addAll((Collection)items);
        request.setSavedItemsDestinationFolder(savedItemsDestinationFolderId);
        request.setMessageDisposition(messageDisposition);
        request.setConflictResolutionMode(conflictResolution);
        request.setSendInvitationsOrCancellationsMode(sendInvitationsOrCancellationsMode);
        return request.execute();
    }

    public ServiceResponseCollection<UpdateItemResponse> updateItems(Iterable<Item> items, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws Exception {
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.isNew() && obj.isDirty();
            }
        })) {
            throw new ServiceValidationException("This operation can't be performed because one or more item are new or unmodified.");
        }
        if (!EwsUtilities.trueForAll(items, new IPredicate<Item>(){

            @Override
            public boolean predicate(Item obj) throws ServiceLocalException {
                return !obj.hasUnprocessedAttachmentChanges();
            }
        })) {
            throw new ServiceValidationException("This operation can't be performed because attachments have been added or deleted for one or more item.");
        }
        return this.internalUpdateItems(items, savedItemsDestinationFolderId, conflictResolution, messageDisposition, sendInvitationsOrCancellationsMode, ServiceErrorHandling.ReturnErrors);
    }

    public Item updateItem(Item item, FolderId savedItemsDestinationFolderId, ConflictResolutionMode conflictResolution, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws Exception {
        ArrayList<Item> itemIdArray = new ArrayList<Item>();
        itemIdArray.add(item);
        ServiceResponseCollection<UpdateItemResponse> responses = this.internalUpdateItems(itemIdArray, savedItemsDestinationFolderId, conflictResolution, messageDisposition, sendInvitationsOrCancellationsMode, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getReturnedItem();
    }

    public void sendItem(Item item, FolderId savedCopyDestinationFolderId) throws Exception {
        SendItemRequest request = new SendItemRequest(this, ServiceErrorHandling.ThrowOnError);
        ArrayList<Item> itemIdArray = new ArrayList<Item>();
        itemIdArray.add(item);
        request.setItems(itemIdArray);
        request.setSavedCopyDestinationFolderId(savedCopyDestinationFolderId);
        request.execute();
    }

    private ServiceResponseCollection<MoveCopyItemResponse> internalCopyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, Boolean returnNewItemIds, ServiceErrorHandling errorHandling) throws Exception {
        CopyItemRequest request = new CopyItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDestinationFolderId(destinationFolderId);
        request.setReturnNewItemIds(returnNewItemIds);
        return request.execute();
    }

    public ServiceResponseCollection<MoveCopyItemResponse> copyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId) throws Exception {
        return this.internalCopyItems(itemIds, destinationFolderId, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<MoveCopyItemResponse> copyItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, boolean returnNewItemIds) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "CopyItems");
        return this.internalCopyItems(itemIds, destinationFolderId, returnNewItemIds, ServiceErrorHandling.ReturnErrors);
    }

    public Item copyItem(ItemId itemId, FolderId destinationFolderId) throws Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        return this.internalCopyItems(itemIdArray, destinationFolderId, null, ServiceErrorHandling.ThrowOnError).getResponseAtIndex(0).getItem();
    }

    private ServiceResponseCollection<MoveCopyItemResponse> internalMoveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, Boolean returnNewItemIds, ServiceErrorHandling errorHandling) throws Exception {
        MoveItemRequest request = new MoveItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDestinationFolderId(destinationFolderId);
        request.setReturnNewItemIds(returnNewItemIds);
        return request.execute();
    }

    public ServiceResponseCollection<MoveCopyItemResponse> moveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId) throws Exception {
        return this.internalMoveItems(itemIds, destinationFolderId, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<MoveCopyItemResponse> moveItems(Iterable<ItemId> itemIds, FolderId destinationFolderId, boolean returnNewItemIds) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "MoveItems");
        return this.internalMoveItems(itemIds, destinationFolderId, returnNewItemIds, ServiceErrorHandling.ReturnErrors);
    }

    public Item moveItem(ItemId itemId, FolderId destinationFolderId) throws Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        return this.internalMoveItems(itemIdArray, destinationFolderId, null, ServiceErrorHandling.ThrowOnError).getResponseAtIndex(0).getItem();
    }

    public <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> findItems(Iterable<FolderId> parentFolderIds, SearchFilter searchFilter, String queryString, ViewBase view, Grouping groupBy, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.validateParamCollection(parentFolderIds.iterator(), "parentFolderIds");
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        FindItemRequest request = new FindItemRequest(this, errorHandlingMode);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchFilter(searchFilter);
        request.setQueryString(queryString);
        request.setView(view);
        request.setGroupBy(groupBy);
        return request.execute();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, String queryString, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, queryString, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, SearchFilter searchFilter, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, searchFilter, null, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(FolderId parentFolderId, ItemView view) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, null, view, null, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, String queryString, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), queryString, view);
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, SearchFilter searchFilter, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), searchFilter, view);
    }

    public FindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, ItemView view) throws Exception {
        return this.findItems(new FolderId(parentFolderName), (SearchFilter)null, view);
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, String queryString, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, queryString, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, SearchFilter searchFilter, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, searchFilter, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public GroupedFindItemsResults<Item> findItems(FolderId parentFolderId, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection responses = this.findItems(folderIdArray, null, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    protected <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> findItems(Class<TItem> cls, FolderId parentFolderId, SearchFilter searchFilter, ViewBase view, Grouping groupBy) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        return this.findItems(folderIdArray, searchFilter, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
    }

    public GroupedFindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, String queryString, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        return this.findItems(new FolderId(parentFolderName), queryString, view, groupBy);
    }

    public GroupedFindItemsResults<Item> findItems(WellKnownFolderName parentFolderName, SearchFilter searchFilter, ItemView view, Grouping groupBy) throws Exception {
        return this.findItems(new FolderId(parentFolderName), searchFilter, view, groupBy);
    }

    public FindItemsResults<Appointment> findAppointments(FolderId parentFolderId, CalendarView calendarView) throws Exception {
        ArrayList<FolderId> folderIdArray = new ArrayList<FolderId>();
        folderIdArray.add(parentFolderId);
        ServiceResponseCollection response = this.findItems(folderIdArray, null, null, calendarView, null, ServiceErrorHandling.ThrowOnError);
        return response.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Appointment> findAppointments(WellKnownFolderName parentFolderName, CalendarView calendarView) throws Exception {
        return this.findAppointments(new FolderId(parentFolderName), calendarView);
    }

    public ServiceResponseCollection<ServiceResponse> loadPropertiesForItems(Iterable<Item> items, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParamCollection(items.iterator(), "item");
        EwsUtilities.validateParam(propertySet, "propertySet");
        return this.internalLoadPropertiesForItems(items, propertySet, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> internalLoadPropertiesForItems(Iterable<Item> items, PropertySet propertySet, ServiceErrorHandling errorHandling) throws Exception {
        GetItemRequestForLoad request = new GetItemRequestForLoad(this, errorHandling);
        request.getItemIds().addRangeItem(items);
        request.setPropertySet(propertySet);
        return request.execute();
    }

    private ServiceResponseCollection<GetItemResponse> internalBindToItems(Iterable<ItemId> itemIds, PropertySet propertySet, ServiceErrorHandling errorHandling) throws Exception {
        GetItemRequest request = new GetItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setPropertySet(propertySet);
        return request.execute();
    }

    public ServiceResponseCollection<GetItemResponse> bindToItems(Iterable<ItemId> itemIds, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParamCollection(itemIds.iterator(), "itemIds");
        EwsUtilities.validateParam(propertySet, "propertySet");
        return this.internalBindToItems(itemIds, propertySet, ServiceErrorHandling.ReturnErrors);
    }

    public Item bindToItem(ItemId itemId, PropertySet propertySet) throws Exception {
        EwsUtilities.validateParam(itemId, "itemId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        ArrayList<ItemId> itmLst = new ArrayList<ItemId>();
        itmLst.add(itemId);
        ServiceResponseCollection<GetItemResponse> responses = this.internalBindToItems(itmLst, propertySet, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getItem();
    }

    public <TItem extends Item> TItem bindToItem(Class<TItem> c, ItemId itemId, PropertySet propertySet) throws Exception {
        Item result = this.bindToItem(itemId, propertySet);
        if (c.isAssignableFrom(result.getClass())) {
            return (TItem)result;
        }
        throw new ServiceLocalException(String.format("The item type returned by the service (%s) isn't compatible with the requested item type (%s).", result.getClass().getName(), c.getName()));
    }

    private ServiceResponseCollection<ServiceResponse> internalDeleteItems(Iterable<ItemId> itemIds, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences, ServiceErrorHandling errorHandling) throws Exception {
        DeleteItemRequest request = new DeleteItemRequest(this, errorHandling);
        request.getItemIds().addRange(itemIds);
        request.setDeleteMode(deleteMode);
        request.setSendCancellationsMode(sendCancellationsMode);
        request.setAffectedTaskOccurrences(affectedTaskOccurrences);
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> deleteItems(Iterable<ItemId> itemIds, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws Exception {
        EwsUtilities.validateParamCollection(itemIds.iterator(), "itemIds");
        return this.internalDeleteItems(itemIds, deleteMode, sendCancellationsMode, affectedTaskOccurrences, ServiceErrorHandling.ReturnErrors);
    }

    public void deleteItem(ItemId itemId, DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws Exception {
        ArrayList<ItemId> itemIdArray = new ArrayList<ItemId>();
        itemIdArray.add(itemId);
        EwsUtilities.validateParam(itemId, "itemId");
        this.internalDeleteItems(itemIdArray, deleteMode, sendCancellationsMode, affectedTaskOccurrences, ServiceErrorHandling.ThrowOnError);
    }

    private ServiceResponseCollection<GetAttachmentResponse> internalGetAttachments(Iterable<Attachment> attachments, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties, ServiceErrorHandling errorHandling) throws Exception {
        GetAttachmentRequest request = new GetAttachmentRequest(this, errorHandling);
        Iterator<Attachment> it = attachments.iterator();
        while (it.hasNext()) {
            request.getAttachments().add(it.next());
        }
        request.setBodyType(bodyType);
        if (additionalProperties != null) {
            ArrayList<PropertyDefinitionBase> propsArray = new ArrayList<PropertyDefinitionBase>();
            for (PropertyDefinitionBase propertyDefinitionBase : additionalProperties) {
                propsArray.add(propertyDefinitionBase);
            }
            request.getAdditionalProperties().addAll(propsArray);
        }
        return request.execute();
    }

    protected ServiceResponseCollection<GetAttachmentResponse> getAttachments(Attachment[] attachments, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        return this.internalGetAttachments(Arrays.asList(attachments), bodyType, additionalProperties, ServiceErrorHandling.ReturnErrors);
    }

    public void getAttachment(Attachment attachment, BodyType bodyType, Iterable<PropertyDefinitionBase> additionalProperties) throws Exception {
        ArrayList<Attachment> attachmentArray = new ArrayList<Attachment>();
        attachmentArray.add(attachment);
        this.internalGetAttachments(attachmentArray, bodyType, additionalProperties, ServiceErrorHandling.ThrowOnError);
    }

    public ServiceResponseCollection<CreateAttachmentResponse> createAttachments(String parentItemId, Iterable<Attachment> attachments) throws ServiceResponseException, Exception {
        CreateAttachmentRequest request = new CreateAttachmentRequest(this, ServiceErrorHandling.ReturnErrors);
        request.setParentItemId(parentItemId);
        request.getAttachments().addAll((Collection)attachments);
        return request.execute();
    }

    public ServiceResponseCollection<DeleteAttachmentResponse> deleteAttachments(Iterable<Attachment> attachments) throws ServiceResponseException, Exception {
        DeleteAttachmentRequest request = new DeleteAttachmentRequest(this, ServiceErrorHandling.ReturnErrors);
        request.getAttachments().addAll((Collection)attachments);
        return request.execute();
    }

    public NameResolutionCollection resolveName(String nameToResolve) throws Exception {
        return this.resolveName(nameToResolve, ResolveNameSearchLocation.ContactsThenDirectory, false);
    }

    public NameResolutionCollection resolveName(String nameToResolve, Iterable<FolderId> parentFolderIds, ResolveNameSearchLocation searchScope, boolean returnContactDetails) throws Exception {
        return this.resolveName(nameToResolve, parentFolderIds, searchScope, returnContactDetails, null);
    }

    public NameResolutionCollection resolveName(String nameToResolve, Iterable<FolderId> parentFolderIds, ResolveNameSearchLocation searchScope, boolean returnContactDetails, PropertySet contactDataPropertySet) throws Exception {
        if (contactDataPropertySet != null) {
            EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "ResolveName");
        }
        EwsUtilities.validateParam(nameToResolve, "nameToResolve");
        if (parentFolderIds != null) {
            EwsUtilities.validateParamCollection(parentFolderIds.iterator(), "parentFolderIds");
        }
        ResolveNamesRequest request = new ResolveNamesRequest(this);
        request.setNameToResolve(nameToResolve);
        request.setReturnFullContactData(returnContactDetails);
        request.getParentFolderIds().addRangeFolderId(parentFolderIds);
        request.setSearchLocation(searchScope);
        request.setContactDataPropertySet(contactDataPropertySet);
        return ((ResolveNamesResponse)request.execute().getResponseAtIndex(0)).getResolutions();
    }

    public NameResolutionCollection resolveName(String nameToResolve, ResolveNameSearchLocation searchScope, boolean returnContactDetails, PropertySet contactDataPropertySet) throws Exception {
        return this.resolveName(nameToResolve, null, searchScope, returnContactDetails, contactDataPropertySet);
    }

    public NameResolutionCollection resolveName(String nameToResolve, ResolveNameSearchLocation searchScope, boolean returnContactDetails) throws Exception {
        return this.resolveName(nameToResolve, null, searchScope, returnContactDetails);
    }

    public ExpandGroupResults expandGroup(EmailAddress emailAddress) throws Exception {
        EwsUtilities.validateParam(emailAddress, "emailAddress");
        ExpandGroupRequest request = new ExpandGroupRequest(this);
        request.setEmailAddress(emailAddress);
        return ((ExpandGroupResponse)request.execute().getResponseAtIndex(0)).getMembers();
    }

    public ExpandGroupResults expandGroup(ItemId groupId) throws Exception {
        EwsUtilities.validateParam(groupId, "groupId");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setId(groupId);
        return this.expandGroup(emailAddress);
    }

    public ExpandGroupResults expandGroup(String smtpAddress) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        return this.expandGroup(new EmailAddress(smtpAddress));
    }

    public ExpandGroupResults expandGroup(String address, String routingType) throws Exception {
        EwsUtilities.validateParam(address, "address");
        EwsUtilities.validateParam(routingType, "routingType");
        EmailAddress emailAddress = new EmailAddress(address);
        emailAddress.setRoutingType(routingType);
        return this.expandGroup(emailAddress);
    }

    public Date getPasswordExpirationDate(String mailboxSmtpAddress) throws Exception {
        GetPasswordExpirationDateRequest request = new GetPasswordExpirationDateRequest(this);
        request.setMailboxSmtpAddress(mailboxSmtpAddress);
        return request.execute().getPasswordExpirationDate();
    }

    public PullSubscription subscribeToPullNotifications(Iterable<FolderId> folderIds, int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return (PullSubscription)((SubscribeResponse)this.buildSubscribeToPullNotificationsRequest(folderIds, timeout, watermark, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public AsyncRequestResult beginSubscribeToPullNotifications(AsyncCallback callback, Object state, Iterable<FolderId> folderIds, int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return this.buildSubscribeToPullNotificationsRequest(folderIds, timeout, watermark, eventTypes).beginExecute(callback);
    }

    public PullSubscription subscribeToPullNotificationsOnAllFolders(int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "SubscribeToPullNotificationsOnAllFolders");
        return (PullSubscription)((SubscribeResponse)this.buildSubscribeToPullNotificationsRequest(null, timeout, watermark, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public IAsyncResult beginSubscribeToPullNotificationsOnAllFolders(AsyncCallback callback, Object state, int timeout, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "BeginSubscribeToPullNotificationsOnAllFolders");
        return this.buildSubscribeToPullNotificationsRequest(null, timeout, watermark, eventTypes).beginExecute(null);
    }

    public PullSubscription endSubscribeToPullNotifications(IAsyncResult asyncResult) throws Exception {
        SubscribeToPullNotificationsRequest request = (SubscribeToPullNotificationsRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return (PullSubscription)((SubscribeResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getSubscription();
    }

    private SubscribeToPullNotificationsRequest buildSubscribeToPullNotificationsRequest(Iterable<FolderId> folderIds, int timeout, String watermark, EventType ... eventTypes) throws Exception {
        if (timeout < 1 || timeout > 1440) {
            throw new IllegalArgumentException("timeout", new Throwable("Timeout must be a value between 1 and 1440."));
        }
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToPullNotificationsRequest request = new SubscribeToPullNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        request.setTimeOut(timeout);
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        request.setWatermark(watermark);
        return request;
    }

    public void unsubscribe(String subscriptionId) throws Exception {
        this.buildUnsubscribeRequest(subscriptionId).execute();
    }

    public IAsyncResult beginUnsubscribe(AsyncCallback callback, Object state, String subscriptionId) throws Exception {
        return this.buildUnsubscribeRequest(subscriptionId).beginExecute(callback);
    }

    public void endUnsubscribe(IAsyncResult asyncResult) throws Exception {
        UnsubscribeRequest request = (UnsubscribeRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        request.endExecute(asyncResult);
    }

    private UnsubscribeRequest buildUnsubscribeRequest(String subscriptionId) throws Exception {
        EwsUtilities.validateParam(subscriptionId, "subscriptionId");
        UnsubscribeRequest request = new UnsubscribeRequest(this);
        request.setSubscriptionId(subscriptionId);
        return request;
    }

    public GetEventsResults getEvents(String subscriptionId, String waterMark) throws Exception {
        return ((GetEventsResponse)this.buildGetEventsRequest(subscriptionId, waterMark).execute().getResponseAtIndex(0)).getResults();
    }

    public IAsyncResult beginGetEvents(AsyncCallback callback, Object state, String subscriptionId, String watermark) throws Exception {
        return this.buildGetEventsRequest(subscriptionId, watermark).beginExecute(callback);
    }

    public GetEventsResults endGetEvents(IAsyncResult asyncResult) throws Exception {
        GetEventsRequest request = (GetEventsRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return ((GetEventsResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getResults();
    }

    private GetEventsRequest buildGetEventsRequest(String subscriptionId, String watermark) throws Exception {
        EwsUtilities.validateParam(subscriptionId, "subscriptionId");
        EwsUtilities.validateParam(watermark, "watermark");
        GetEventsRequest request = new GetEventsRequest(this);
        request.setSubscriptionId(subscriptionId);
        request.setWatermark(watermark);
        return request;
    }

    public PushSubscription subscribeToPushNotifications(Iterable<FolderId> folderIds, URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return (PushSubscription)((SubscribeResponse)this.buildSubscribeToPushNotificationsRequest(folderIds, url, frequency, watermark, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public IAsyncResult beginSubscribeToPushNotifications(AsyncCallback callback, Object state, Iterable<FolderId> folderIds, URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return this.buildSubscribeToPushNotificationsRequest(folderIds, url, frequency, watermark, eventTypes).beginExecute(callback);
    }

    public PushSubscription subscribeToPushNotificationsOnAllFolders(URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "SubscribeToPushNotificationsOnAllFolders");
        return (PushSubscription)((SubscribeResponse)this.buildSubscribeToPushNotificationsRequest(null, url, frequency, watermark, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public IAsyncResult beginSubscribeToPushNotificationsOnAllFolders(AsyncCallback callback, Object state, URI url, int frequency, String watermark, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010, "BeginSubscribeToPushNotificationsOnAllFolders");
        return this.buildSubscribeToPushNotificationsRequest(null, url, frequency, watermark, eventTypes).beginExecute(callback);
    }

    public PushSubscription endSubscribeToPushNotifications(IAsyncResult asyncResult) throws Exception {
        SubscribeToPushNotificationsRequest request = (SubscribeToPushNotificationsRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return (PushSubscription)((SubscribeResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getSubscription();
    }

    private SubscribeToPushNotificationsRequest buildSubscribeToPushNotificationsRequest(Iterable<FolderId> folderIds, URI url, int frequency, String watermark, EventType[] eventTypes) throws Exception {
        EwsUtilities.validateParam(url, "url");
        if (frequency < 1 || frequency > 1440) {
            throw new ArgumentOutOfRangeException("frequency", "The frequency must be a value between 1 and 1440.");
        }
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToPushNotificationsRequest request = new SubscribeToPushNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        request.setUrl(url);
        request.setFrequency(frequency);
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        request.setWatermark(watermark);
        return request;
    }

    public StreamingSubscription subscribeToStreamingNotifications(Iterable<FolderId> folderIds, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "SubscribeToStreamingNotifications");
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return (StreamingSubscription)((SubscribeResponse)this.buildSubscribeToStreamingNotificationsRequest(folderIds, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public StreamingSubscription subscribeToStreamingNotificationsOnAllFolders(EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "SubscribeToStreamingNotificationsOnAllFolders");
        return (StreamingSubscription)((SubscribeResponse)this.buildSubscribeToStreamingNotificationsRequest(null, eventTypes).execute().getResponseAtIndex(0)).getSubscription();
    }

    public IAsyncResult beginSubscribeToStreamingNotifications(AsyncCallback callback, Object state, Iterable<FolderId> folderIds, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "BeginSubscribeToStreamingNotifications");
        EwsUtilities.validateParamCollection(folderIds.iterator(), "folderIds");
        return this.buildSubscribeToStreamingNotificationsRequest(folderIds, eventTypes).beginExecute(callback);
    }

    public IAsyncResult beginSubscribeToStreamingNotificationsOnAllFolders(AsyncCallback callback, Object state, EventType ... eventTypes) throws Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "BeginSubscribeToStreamingNotificationsOnAllFolders");
        return this.buildSubscribeToStreamingNotificationsRequest(null, eventTypes).beginExecute(callback);
    }

    public StreamingSubscription endSubscribeToStreamingNotifications(IAsyncResult asyncResult) throws IndexOutOfBoundsException, Exception {
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "EndSubscribeToStreamingNotifications");
        SubscribeToStreamingNotificationsRequest request = (SubscribeToStreamingNotificationsRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return (StreamingSubscription)((SubscribeResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getSubscription();
    }

    private SubscribeToStreamingNotificationsRequest buildSubscribeToStreamingNotificationsRequest(Iterable<FolderId> folderIds, EventType[] eventTypes) throws Exception {
        EwsUtilities.validateParamCollection(eventTypes, "eventTypes");
        SubscribeToStreamingNotificationsRequest request = new SubscribeToStreamingNotificationsRequest(this);
        if (folderIds != null) {
            request.getFolderIds().addRangeFolderId(folderIds);
        }
        for (EventType event : eventTypes) {
            request.getEventTypes().add(event);
        }
        return request;
    }

    public ChangeCollection<ItemChange> syncFolderItems(FolderId syncFolderId, PropertySet propertySet, Iterable<ItemId> ignoredItemIds, int maxChangesReturned, SyncFolderItemsScope syncScope, String syncState) throws Exception {
        return ((SyncFolderItemsResponse)this.buildSyncFolderItemsRequest(syncFolderId, propertySet, ignoredItemIds, maxChangesReturned, syncScope, syncState).execute().getResponseAtIndex(0)).getChanges();
    }

    public IAsyncResult beginSyncFolderItems(AsyncCallback callback, Object state, FolderId syncFolderId, PropertySet propertySet, Iterable<ItemId> ignoredItemIds, int maxChangesReturned, SyncFolderItemsScope syncScope, String syncState) throws Exception {
        return this.buildSyncFolderItemsRequest(syncFolderId, propertySet, ignoredItemIds, maxChangesReturned, syncScope, syncState).beginExecute(callback);
    }

    public ChangeCollection<ItemChange> endSyncFolderItems(IAsyncResult asyncResult) throws Exception {
        SyncFolderItemsRequest request = (SyncFolderItemsRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return ((SyncFolderItemsResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getChanges();
    }

    private SyncFolderItemsRequest buildSyncFolderItemsRequest(FolderId syncFolderId, PropertySet propertySet, Iterable<ItemId> ignoredItemIds, int maxChangesReturned, SyncFolderItemsScope syncScope, String syncState) throws Exception {
        EwsUtilities.validateParam(syncFolderId, "syncFolderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        SyncFolderItemsRequest request = new SyncFolderItemsRequest(this);
        request.setSyncFolderId(syncFolderId);
        request.setPropertySet(propertySet);
        if (ignoredItemIds != null) {
            request.getIgnoredItemIds().addRange(ignoredItemIds);
        }
        request.setMaxChangesReturned(maxChangesReturned);
        request.setSyncScope(syncScope);
        request.setSyncState(syncState);
        return request;
    }

    public ChangeCollection<FolderChange> syncFolderHierarchy(FolderId syncFolderId, PropertySet propertySet, String syncState) throws Exception {
        return ((SyncFolderHierarchyResponse)this.buildSyncFolderHierarchyRequest(syncFolderId, propertySet, syncState).execute().getResponseAtIndex(0)).getChanges();
    }

    public IAsyncResult beginSyncFolderHierarchy(AsyncCallback callback, Object state, FolderId syncFolderId, PropertySet propertySet, String syncState) throws Exception {
        return this.buildSyncFolderHierarchyRequest(syncFolderId, propertySet, syncState).beginExecute(callback);
    }

    public ChangeCollection<FolderChange> syncFolderHierarchy(PropertySet propertySet, String syncState) throws Exception {
        return this.syncFolderHierarchy(null, propertySet, syncState);
    }

    public ChangeCollection<FolderChange> endSyncFolderHierarchy(IAsyncResult asyncResult) throws Exception {
        SyncFolderHierarchyRequest request = (SyncFolderHierarchyRequest)AsyncRequestResult.extractServiceRequest(this, asyncResult);
        return ((SyncFolderHierarchyResponse)request.endExecute(asyncResult).getResponseAtIndex(0)).getChanges();
    }

    private SyncFolderHierarchyRequest buildSyncFolderHierarchyRequest(FolderId syncFolderId, PropertySet propertySet, String syncState) throws Exception {
        EwsUtilities.validateParamAllowNull(syncFolderId, "syncFolderId");
        EwsUtilities.validateParam(propertySet, "propertySet");
        SyncFolderHierarchyRequest request = new SyncFolderHierarchyRequest(this);
        request.setPropertySet(propertySet);
        request.setSyncFolderId(syncFolderId);
        request.setSyncState(syncState);
        return request;
    }

    public OofSettings getUserOofSettings(String smtpAddress) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        GetUserOofSettingsRequest request = new GetUserOofSettingsRequest(this);
        request.setSmtpAddress(smtpAddress);
        return request.execute().getOofSettings();
    }

    public void setUserOofSettings(String smtpAddress, OofSettings oofSettings) throws Exception {
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
        EwsUtilities.validateParam(oofSettings, "oofSettings");
        SetUserOofSettingsRequest request = new SetUserOofSettingsRequest(this);
        request.setSmtpAddress(smtpAddress);
        request.setOofSettings(oofSettings);
        request.execute();
    }

    public GetUserAvailabilityResults getUserAvailability(Iterable<AttendeeInfo> attendees, TimeWindow timeWindow, AvailabilityData requestedData, AvailabilityOptions options) throws Exception {
        EwsUtilities.validateParamCollection(attendees.iterator(), "attendees");
        EwsUtilities.validateParam(timeWindow, "timeWindow");
        EwsUtilities.validateParam(options, "options");
        GetUserAvailabilityRequest request = new GetUserAvailabilityRequest(this);
        request.setAttendees(attendees);
        request.setTimeWindow(timeWindow);
        request.setRequestedData(requestedData);
        request.setOptions(options);
        return request.execute();
    }

    public GetUserAvailabilityResults getUserAvailability(Iterable<AttendeeInfo> attendees, TimeWindow timeWindow, AvailabilityData requestedData) throws Exception {
        return this.getUserAvailability(attendees, timeWindow, requestedData, new AvailabilityOptions());
    }

    public EmailAddressCollection getRoomLists() throws Exception {
        GetRoomListsRequest request = new GetRoomListsRequest(this);
        return request.execute().getRoomLists();
    }

    public Collection<EmailAddress> getRooms(EmailAddress emailAddress) throws Exception {
        EwsUtilities.validateParam(emailAddress, "emailAddress");
        GetRoomsRequest request = new GetRoomsRequest(this);
        request.setRoomList(emailAddress);
        return request.execute().getRooms();
    }

    private Collection<Conversation> findConversation(ConversationIndexedItemView view, SearchFilter.IsEqualTo filter, FolderId folderId) throws Exception {
        EwsUtilities.validateParam(view, "view");
        EwsUtilities.validateParamAllowNull(filter, "filter");
        EwsUtilities.validateParam(folderId, "folderId");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "FindConversation");
        FindConversationRequest request = new FindConversationRequest(this);
        request.setIndexedItemView(view);
        request.setConversationViewFilter(filter);
        request.setFolderId(new FolderIdWrapper(folderId));
        return request.execute().getConversations();
    }

    public Collection<Conversation> findConversation(ConversationIndexedItemView view, FolderId folderId) throws Exception {
        return this.findConversation(view, null, folderId);
    }

    private ServiceResponseCollection<ServiceResponse> applyConversationAction(ConversationActionType actionType, Iterable<ConversationId> conversationIds, boolean processRightAway, StringList categories, boolean enableAlwaysDelete, FolderId destinationFolderId, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.ewsAssert(actionType == ConversationActionType.AlwaysCategorize || actionType == ConversationActionType.AlwaysMove || actionType == ConversationActionType.AlwaysDelete, "ApplyConversationAction", "Invalic actionType");
        EwsUtilities.validateParam(conversationIds, "conversationId");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "ApplyConversationAction");
        ApplyConversationActionRequest request = new ApplyConversationActionRequest(this, errorHandlingMode);
        ConversationAction action = new ConversationAction();
        for (ConversationId conversationId : conversationIds) {
            action.setAction(actionType);
            action.setConversationId(conversationId);
            action.setProcessRightAway(processRightAway);
            action.setCategories(categories);
            action.setEnableAlwaysDelete(enableAlwaysDelete);
            action.setDestinationFolderId(destinationFolderId != null ? new FolderIdWrapper(destinationFolderId) : null);
            request.getConversationActions().add(action);
        }
        return request.execute();
    }

    private ServiceResponseCollection<ServiceResponse> applyConversationOneTimeAction(ConversationActionType actionType, Iterable<HashMap<ConversationId, Date>> idTimePairs, FolderId contextFolderId, FolderId destinationFolderId, DeleteMode deleteType, Boolean isRead, ServiceErrorHandling errorHandlingMode) throws Exception {
        EwsUtilities.ewsAssert(actionType == ConversationActionType.Move || actionType == ConversationActionType.Delete || actionType == ConversationActionType.SetReadState || actionType == ConversationActionType.Copy, "ApplyConversationOneTimeAction", "Invalid actionType");
        EwsUtilities.validateParamCollection(idTimePairs.iterator(), "idTimePairs");
        EwsUtilities.validateMethodVersion(this, ExchangeVersion.Exchange2010_SP1, "ApplyConversationAction");
        ApplyConversationActionRequest request = new ApplyConversationActionRequest(this, errorHandlingMode);
        for (HashMap<ConversationId, Date> idTimePair : idTimePairs) {
            ConversationAction action = new ConversationAction();
            action.setAction(actionType);
            action.setConversationId(idTimePair.keySet().iterator().next());
            action.setContextFolderId(contextFolderId != null ? new FolderIdWrapper(contextFolderId) : null);
            action.setDestinationFolderId(destinationFolderId != null ? new FolderIdWrapper(destinationFolderId) : null);
            action.setConversationLastSyncTime(idTimePair.values().iterator().next());
            action.setIsRead(isRead);
            action.setDeleteType(deleteType);
            request.getConversationActions().add(action);
        }
        return request.execute();
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysCategorizeItemsInConversations(Iterable<ConversationId> conversationId, Iterable<String> categories, boolean processSynchronously) throws Exception {
        EwsUtilities.validateParamCollection(categories.iterator(), "categories");
        return this.applyConversationAction(ConversationActionType.AlwaysCategorize, conversationId, processSynchronously, new StringList(categories), false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysCategorizeItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysCategorize, conversationId, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysDeleteItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysDelete, conversationId, processSynchronously, null, true, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysDeleteItemsInConversations(Iterable<ConversationId> conversationId, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysDelete, conversationId, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> enableAlwaysMoveItemsInConversations(Iterable<ConversationId> conversationId, FolderId destinationFolderId, boolean processSynchronously) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationAction(ConversationActionType.AlwaysMove, conversationId, processSynchronously, null, false, destinationFolderId, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> disableAlwaysMoveItemsInConversations(Iterable<ConversationId> conversationIds, boolean processSynchronously) throws Exception {
        return this.applyConversationAction(ConversationActionType.AlwaysMove, conversationIds, processSynchronously, null, false, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> moveItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationOneTimeAction(ConversationActionType.Move, idLastSyncTimePairs, contextFolderId, destinationFolderId, null, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> copyItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.applyConversationOneTimeAction(ConversationActionType.Copy, idLastSyncTimePairs, contextFolderId, destinationFolderId, null, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> deleteItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, DeleteMode deleteMode) throws Exception {
        return this.applyConversationOneTimeAction(ConversationActionType.Delete, idLastSyncTimePairs, contextFolderId, null, deleteMode, null, ServiceErrorHandling.ReturnErrors);
    }

    public ServiceResponseCollection<ServiceResponse> setReadStateForItemsInConversations(Iterable<HashMap<ConversationId, Date>> idLastSyncTimePairs, FolderId contextFolderId, boolean isRead) throws Exception {
        return this.applyConversationOneTimeAction(ConversationActionType.SetReadState, idLastSyncTimePairs, contextFolderId, null, null, isRead, ServiceErrorHandling.ReturnErrors);
    }

    private ServiceResponseCollection<ConvertIdResponse> internalConvertIds(Iterable<AlternateIdBase> ids, IdFormat destinationFormat, ServiceErrorHandling errorHandling) throws Exception {
        EwsUtilities.validateParamCollection(ids.iterator(), "ids");
        ConvertIdRequest request = new ConvertIdRequest(this, errorHandling);
        request.getIds().addAll((Collection)ids);
        request.setDestinationFormat(destinationFormat);
        return request.execute();
    }

    public ServiceResponseCollection<ConvertIdResponse> convertIds(Iterable<AlternateIdBase> ids, IdFormat destinationFormat) throws Exception {
        EwsUtilities.validateParamCollection(ids.iterator(), "ids");
        return this.internalConvertIds(ids, destinationFormat, ServiceErrorHandling.ReturnErrors);
    }

    public AlternateIdBase convertId(AlternateIdBase id, IdFormat destinationFormat) throws Exception {
        EwsUtilities.validateParam(id, "id");
        ArrayList<AlternateIdBase> alternateIdBaseArray = new ArrayList<AlternateIdBase>();
        alternateIdBaseArray.add(id);
        ServiceResponseCollection<ConvertIdResponse> responses = this.internalConvertIds(alternateIdBaseArray, destinationFormat, ServiceErrorHandling.ThrowOnError);
        return responses.getResponseAtIndex(0).getConvertedId();
    }

    public Collection<DelegateUserResponse> addDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, DelegateUser ... delegateUsers) throws Exception {
        return this.addDelegates(mailbox, meetingRequestsDeliveryScope, Arrays.asList(delegateUsers));
    }

    public Collection<DelegateUserResponse> addDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, Iterable<DelegateUser> delegateUsers) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(delegateUsers.iterator(), "delegateUsers");
        AddDelegateRequest request = new AddDelegateRequest(this);
        request.setMailbox(mailbox);
        for (DelegateUser user : delegateUsers) {
            request.getDelegateUsers().add(user);
        }
        request.setMeetingRequestsDeliveryScope(meetingRequestsDeliveryScope);
        DelegateManagementResponse response = request.execute();
        return response.getDelegateUserResponses();
    }

    public Collection<DelegateUserResponse> updateDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, DelegateUser ... delegateUsers) throws Exception {
        return this.updateDelegates(mailbox, meetingRequestsDeliveryScope, Arrays.asList(delegateUsers));
    }

    public Collection<DelegateUserResponse> updateDelegates(Mailbox mailbox, MeetingRequestsDeliveryScope meetingRequestsDeliveryScope, Iterable<DelegateUser> delegateUsers) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(delegateUsers.iterator(), "delegateUsers");
        UpdateDelegateRequest request = new UpdateDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<DelegateUser> delUser = new ArrayList<DelegateUser>();
        for (DelegateUser user : delegateUsers) {
            delUser.add(user);
        }
        request.getDelegateUsers().addAll(delUser);
        request.setMeetingRequestsDeliveryScope(meetingRequestsDeliveryScope);
        DelegateManagementResponse response = request.execute();
        return response.getDelegateUserResponses();
    }

    public Collection<DelegateUserResponse> removeDelegates(Mailbox mailbox, UserId ... userIds) throws Exception {
        return this.removeDelegates(mailbox, Arrays.asList(userIds));
    }

    public Collection<DelegateUserResponse> removeDelegates(Mailbox mailbox, Iterable<UserId> userIds) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        EwsUtilities.validateParamCollection(userIds.iterator(), "userIds");
        RemoveDelegateRequest request = new RemoveDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        request.getUserIds().addAll(delUser);
        DelegateManagementResponse response = request.execute();
        return response.getDelegateUserResponses();
    }

    public DelegateInformation getDelegates(Mailbox mailbox, boolean includePermissions, UserId ... userIds) throws Exception {
        return this.getDelegates(mailbox, includePermissions, Arrays.asList(userIds));
    }

    public DelegateInformation getDelegates(Mailbox mailbox, boolean includePermissions, Iterable<UserId> userIds) throws Exception {
        EwsUtilities.validateParam(mailbox, "mailbox");
        GetDelegateRequest request = new GetDelegateRequest(this);
        request.setMailbox(mailbox);
        ArrayList<UserId> delUser = new ArrayList<UserId>();
        for (UserId user : userIds) {
            delUser.add(user);
        }
        request.getUserIds().addAll(delUser);
        request.setIncludePermissions(includePermissions);
        GetDelegateResponse response = (GetDelegateResponse)request.execute();
        DelegateInformation delegateInformation = new DelegateInformation((List)response.getDelegateUserResponses(), response.getMeetingRequestsDeliveryScope());
        return delegateInformation;
    }

    public void createUserConfiguration(UserConfiguration userConfiguration) throws Exception {
        EwsUtilities.validateParam(userConfiguration, "userConfiguration");
        CreateUserConfigurationRequest request = new CreateUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.execute();
    }

    public void deleteUserConfiguration(String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        DeleteUserConfigurationRequest request = new DeleteUserConfigurationRequest(this);
        request.setName(name);
        request.setParentFolderId(parentFolderId);
        request.execute();
    }

    public UserConfiguration getUserConfiguration(String name, FolderId parentFolderId, UserConfigurationProperties properties) throws Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        GetUserConfigurationRequest request = new GetUserConfigurationRequest(this);
        request.setName(name);
        request.setParentFolderId(parentFolderId);
        request.setProperties(EnumSet.of(properties));
        return ((GetUserConfigurationResponse)request.execute().getResponseAtIndex(0)).getUserConfiguration();
    }

    public void loadPropertiesForUserConfiguration(UserConfiguration userConfiguration, UserConfigurationProperties properties) throws Exception {
        EwsUtilities.ewsAssert(userConfiguration != null, "ExchangeService.LoadPropertiesForUserConfiguration", "userConfiguration is null");
        GetUserConfigurationRequest request = new GetUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.setProperties(EnumSet.of(properties));
        request.execute();
    }

    public void updateUserConfiguration(UserConfiguration userConfiguration) throws Exception {
        EwsUtilities.validateParam(userConfiguration, "userConfiguration");
        UpdateUserConfigurationRequest request = new UpdateUserConfigurationRequest(this);
        request.setUserConfiguration(userConfiguration);
        request.execute();
    }

    public RuleCollection getInboxRules() throws Exception {
        GetInboxRulesRequest request = new GetInboxRulesRequest(this);
        return request.execute().getRules();
    }

    public RuleCollection getInboxRules(String mailboxSmtpAddress) throws Exception {
        EwsUtilities.validateParam(mailboxSmtpAddress, "MailboxSmtpAddress");
        GetInboxRulesRequest request = new GetInboxRulesRequest(this);
        request.setmailboxSmtpAddress(mailboxSmtpAddress);
        return request.execute().getRules();
    }

    public void updateInboxRules(Iterable<RuleOperation> operations, boolean removeOutlookRuleBlob) throws Exception {
        UpdateInboxRulesRequest request = new UpdateInboxRulesRequest(this);
        request.setInboxRuleOperations(operations);
        request.setRemoveOutlookRuleBlob(removeOutlookRuleBlob);
        request.execute();
    }

    public void updateInboxRules(Iterable<RuleOperation> operations, boolean removeOutlookRuleBlob, String mailboxSmtpAddress) throws Exception {
        UpdateInboxRulesRequest request = new UpdateInboxRulesRequest(this);
        request.setInboxRuleOperations(operations);
        request.setRemoveOutlookRuleBlob(removeOutlookRuleBlob);
        request.setMailboxSmtpAddress(mailboxSmtpAddress);
        request.execute();
    }

    private boolean defaultAutodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        throw new AutodiscoverLocalException(String.format("Autodiscover blocked a potentially insecure redirection to %s. To allow Autodiscover to follow the redirection, use the AutodiscoverUrl(string, AutodiscoverRedirectionUrlValidationCallback) overload.", redirectionUrl));
    }

    public void autodiscoverUrl(String emailAddress) throws Exception {
        this.autodiscoverUrl(emailAddress, this);
    }

    public void autodiscoverUrl(String emailAddress, IAutodiscoverRedirectionUrl validateRedirectionUrlCallback) throws Exception {
        URI exchangeServiceUrl = null;
        if (this.getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            try {
                exchangeServiceUrl = this.getAutodiscoverUrl(emailAddress, this.getRequestedServerVersion(), validateRedirectionUrlCallback);
                this.setUrl(this.adjustServiceUriFromCredentials(exchangeServiceUrl));
                return;
            }
            catch (AutodiscoverLocalException ex) {
                this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service call failed with error '%s'. Will try legacy service", ex.getMessage()));
            }
            catch (ServiceRemoteException ex) {
                if (ex instanceof AccountIsLockedException) {
                    throw new AccountIsLockedException(ex.getMessage(), exchangeServiceUrl, ex);
                }
                this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service call failed with error '%s'. Will try legacy service", ex.getMessage()));
            }
        }
        exchangeServiceUrl = this.getAutodiscoverUrl(emailAddress, ExchangeVersion.Exchange2007_SP1, validateRedirectionUrlCallback);
        this.setUrl(this.adjustServiceUriFromCredentials(exchangeServiceUrl));
    }

    private URI adjustServiceUriFromCredentials(URI uri) throws Exception {
        return this.getCredentials() != null ? this.getCredentials().adjustUrl(uri) : uri;
    }

    private URI getAutodiscoverUrl(String emailAddress, ExchangeVersion requestedServerVersion, IAutodiscoverRedirectionUrl validateRedirectionUrlCallback) throws Exception {
        AutodiscoverService autodiscoverService = new AutodiscoverService(this, requestedServerVersion);
        autodiscoverService.setWebProxy(this.getWebProxy());
        autodiscoverService.setRedirectionUrlValidationCallback(validateRedirectionUrlCallback);
        autodiscoverService.setEnableScpLookup(this.getEnableScpLookup());
        GetUserSettingsResponse response = autodiscoverService.getUserSettings(emailAddress, UserSettingName.InternalEwsUrl, UserSettingName.ExternalEwsUrl);
        switch (response.getErrorCode()) {
            case NoError: {
                autodiscoverService.isExternal();
                return this.getEwsUrlFromResponse(response, Boolean.TRUE);
            }
            case InvalidUser: {
                throw new ServiceRemoteException(String.format("Invalid user: '%s'", emailAddress));
            }
            case InvalidRequest: {
                throw new ServiceRemoteException(String.format("Invalid Autodiscover request: '%s'", response.getErrorMessage()));
            }
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("No EWS Url returned for user %s, error code is %s", new Object[]{emailAddress, response.getErrorCode()}));
        throw new ServiceRemoteException(response.getErrorMessage());
    }

    private URI getEwsUrlFromResponse(GetUserSettingsResponse response, boolean isExternal) throws URISyntaxException, AutodiscoverLocalException {
        String uriString;
        OutParam outParam = new OutParam();
        if (isExternal && response.tryGetSettingValue(String.class, UserSettingName.ExternalEwsUrl, outParam) && (uriString = (String)outParam.getParam()) != null && !uriString.isEmpty()) {
            return new URI(uriString);
        }
        if ((response.tryGetSettingValue(String.class, UserSettingName.InternalEwsUrl, outParam) || response.tryGetSettingValue(String.class, UserSettingName.ExternalEwsUrl, outParam)) && (uriString = (String)outParam.getParam()) != null && !uriString.isEmpty()) {
            return new URI(uriString);
        }
        throw new AutodiscoverLocalException("The Autodiscover service didn't return an appropriate URL that can be used for the ExchangeService Autodiscover URL.");
    }

    protected Document executeDiagnosticMethod(String verb, Node parameter) throws Exception {
        ExecuteDiagnosticMethodRequest request = new ExecuteDiagnosticMethodRequest(this);
        request.setVerb(verb);
        request.setParameter(parameter);
        return ((ExecuteDiagnosticMethodResponse)request.execute().getResponseAtIndex(0)).getReturnValue();
    }

    @Override
    public void validate() throws ServiceLocalException {
        super.validate();
        if (this.getUrl() == null) {
            throw new ServiceLocalException("The Url property on the ExchangeService object must be set.");
        }
    }

    public ExchangeService() {
    }

    public ExchangeService(ExchangeVersion requestedServerVersion) {
        super(requestedServerVersion);
    }

    public HttpWebRequest prepareHttpWebRequest() throws ServiceLocalException, URISyntaxException {
        try {
            this.url = this.adjustServiceUriFromCredentials(this.getUrl());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return this.prepareHttpWebRequestForUrl(this.url, this.getAcceptGzipEncoding(), true);
    }

    public HttpWebRequest prepareHttpPoolingWebRequest() throws ServiceLocalException, URISyntaxException {
        try {
            this.url = this.adjustServiceUriFromCredentials(this.getUrl());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return this.prepareHttpPoolingWebRequestForUrl(this.url, this.getAcceptGzipEncoding(), true);
    }

    @Override
    public void processHttpErrorResponse(HttpWebRequest httpWebResponse, Exception webException) throws Exception {
        this.internalProcessHttpErrorResponse(httpWebResponse, webException, TraceFlags.EwsResponseHttpHeaders, TraceFlags.EwsResponse);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public ImpersonatedUserId getImpersonatedUserId() {
        return this.impersonatedUserId;
    }

    public void setImpersonatedUserId(ImpersonatedUserId impersonatedUserId) {
        this.impersonatedUserId = impersonatedUserId;
    }

    public Locale getPreferredCulture() {
        return this.preferredCulture;
    }

    public void setPreferredCulture(Locale preferredCulture) {
        this.preferredCulture = preferredCulture;
    }

    public DateTimePrecision getDateTimePrecision() {
        return this.dateTimePrecision;
    }

    public void setDateTimePrecision(DateTimePrecision d) {
        this.dateTimePrecision = d;
    }

    public void setPreferredCulture(DateTimePrecision dateTimePrecision) {
        this.dateTimePrecision = dateTimePrecision;
    }

    public IFileAttachmentContentHandler getFileAttachmentContentHandler() {
        return this.fileAttachmentContentHandler;
    }

    public void setFileAttachmentContentHandler(IFileAttachmentContentHandler fileAttachmentContentHandler) {
        this.fileAttachmentContentHandler = fileAttachmentContentHandler;
    }

    public UnifiedMessaging getUnifiedMessaging() {
        if (this.unifiedMessaging == null) {
            this.unifiedMessaging = new UnifiedMessaging(this);
        }
        return this.unifiedMessaging;
    }

    public boolean getEnableScpLookup() {
        return this.enableScpLookup;
    }

    public void setEnableScpLookup(boolean value) {
        this.enableScpLookup = value;
    }

    public boolean getExchange2007CompatibilityMode() {
        return this.exchange2007CompatibilityMode;
    }

    public void setExchange2007CompatibilityMode(boolean value) {
        this.exchange2007CompatibilityMode = value;
    }

    public Collection<TimeZoneDefinition> getServerTimeZones(Iterable<String> timeZoneIds) throws Exception {
        HashMap<String, TimeZoneDefinition> timeZoneMap = new HashMap<String, TimeZoneDefinition>();
        GetServerTimeZonesRequest request = new GetServerTimeZonesRequest(this);
        ServiceResponseCollection responses = request.execute();
        for (GetServerTimeZonesResponse response : responses) {
            for (TimeZoneDefinition tzd : response.getTimeZones()) {
                timeZoneMap.put(tzd.getId(), tzd);
            }
        }
        ArrayList<TimeZoneDefinition> timeZoneList = new ArrayList<TimeZoneDefinition>();
        for (String timeZoneId : timeZoneIds) {
            timeZoneList.add((TimeZoneDefinition)timeZoneMap.get(timeZoneId));
        }
        return timeZoneList;
    }

    public Collection<TimeZoneDefinition> getServerTimeZones() throws Exception {
        GetServerTimeZonesRequest request = new GetServerTimeZonesRequest(this);
        ArrayList<TimeZoneDefinition> timeZoneList = new ArrayList<TimeZoneDefinition>();
        ServiceResponseCollection responses = request.execute();
        for (GetServerTimeZonesResponse response : responses) {
            timeZoneList.addAll(response.getTimeZones());
        }
        return timeZoneList;
    }

    @Override
    public boolean autodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        return this.defaultAutodiscoverRedirectionUrlValidationCallback(redirectionUrl);
    }
}

