/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.response.GetStreamingEventsResponse;

public class GetStreamingEventsRequest
extends HangingServiceRequestBase<GetStreamingEventsResponse> {
    protected static final int HeartbeatFrequencyDefault = 45000;
    private static int heartbeatFrequency = 45000;
    private Iterable<String> subscriptionIds;
    private int connectionTimeout;

    public GetStreamingEventsRequest(ExchangeService service, HangingServiceRequestBase.IHandleResponseObject serviceObjectHandler, Iterable<String> subscriptionIds, int connectionTimeout) throws ServiceVersionException {
        super(service, serviceObjectHandler, heartbeatFrequency);
        this.subscriptionIds = subscriptionIds;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public String getXmlElementName() {
        return "GetStreamingEvents";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetStreamingEventsResponse";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Messages, "SubscriptionIds");
        for (String id : this.subscriptionIds) {
            writer.writeElementValue(XmlNamespace.Types, "SubscriptionId", id);
        }
        writer.writeEndElement();
        writer.writeElementValue(XmlNamespace.Messages, "ConnectionTimeout", this.connectionTimeout);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    @Override
    protected GetStreamingEventsResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "ResponseMessages");
        GetStreamingEventsResponse response = new GetStreamingEventsResponse(this);
        response.loadFromXml(reader, "GetStreamingEventsResponseMessage");
        reader.readEndElementIfNecessary(XmlNamespace.Messages, "ResponseMessages");
        return response;
    }

    protected static void setHeartbeatFrequency(int heartbeatFrequency) {
        GetStreamingEventsRequest.heartbeatFrequency = heartbeatFrequency;
    }

    @Override
    protected HttpWebRequest buildEwsHttpWebRequest() throws Exception {
        return super.buildEwsHttpPoolingWebRequest();
    }
}

