/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceMultiResponseXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.HangingRequestDisconnectReason;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.exception.xml.XmlException;
import microsoft.exchange.webservices.data.core.request.HangingRequestDisconnectEventArgs;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.misc.HangingTraceStream;
import microsoft.exchange.webservices.data.security.XmlNodeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HangingServiceRequestBase<T>
extends ServiceRequestBase<T> {
    private static final Log LOG = LogFactory.getLog(HangingServiceRequestBase.class);
    public static final int BUFFER_SIZE = 4096;
    private static volatile boolean logAllWireBytes = false;
    private IHandleResponseObject responseHandler;
    private HttpWebRequest response;
    protected int heartbeatFrequencyMilliseconds;
    private List<IHangingRequestDisconnectHandler> onDisconnectList = new ArrayList<IHangingRequestDisconnectHandler>();
    private boolean isConnected;

    public static boolean isLogAllWireBytes() {
        return logAllWireBytes;
    }

    public static void setLogAllWireBytes(boolean logAllWireBytes) {
        HangingServiceRequestBase.logAllWireBytes = logAllWireBytes;
    }

    public void addOnDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.add(disconnect);
    }

    protected void removeDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.remove(disconnect);
    }

    protected void clearDisconnectEvents() {
        this.onDisconnectList.clear();
    }

    protected HangingServiceRequestBase(ExchangeService service, IHandleResponseObject handler, int heartbeatFrequency) throws ServiceVersionException {
        super(service);
        this.responseHandler = handler;
        this.heartbeatFrequencyMilliseconds = heartbeatFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecute() throws Exception {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            this.response = this.validateAndEmitRequest();
            this.internalOnConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponses() {
        HangingTraceStream tracingStream = null;
        ByteArrayOutputStream responseCopy = null;
        try {
            boolean traceEWSResponse = this.getService().isTraceEnabledFor(TraceFlags.EwsResponse);
            InputStream responseStream = this.response.getInputStream();
            tracingStream = new HangingTraceStream(responseStream, this.getService());
            if (traceEWSResponse) {
                responseCopy = new ByteArrayOutputStream();
                tracingStream.setResponseCopy(responseCopy);
            }
            while (this.isConnected()) {
                Object responseObject;
                EwsServiceMultiResponseXmlReader ewsXmlReader;
                if (traceEWSResponse) {
                    ewsXmlReader = EwsServiceMultiResponseXmlReader.create(tracingStream, this.getService());
                    responseObject = this.readResponse(ewsXmlReader);
                    this.responseHandler.handleResponseObject(responseObject);
                    responseCopy.close();
                    responseCopy = new ByteArrayOutputStream();
                    tracingStream.setResponseCopy(responseCopy);
                    continue;
                }
                ewsXmlReader = EwsServiceMultiResponseXmlReader.create(tracingStream, this.getService());
                responseObject = this.readResponse(ewsXmlReader);
                this.responseHandler.handleResponseObject(responseObject);
            }
        }
        catch (SocketTimeoutException ex) {
            this.disconnect(HangingRequestDisconnectReason.Timeout, ex);
        }
        catch (UnknownServiceException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
        }
        catch (ObjectStreamException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
        }
        catch (IOException ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
        }
        catch (UnsupportedOperationException ex) {
            LOG.error((Object)ex);
            this.disconnect(HangingRequestDisconnectReason.UserInitiated, null);
        }
        catch (Exception ex) {
            this.disconnect(HangingRequestDisconnectReason.Exception, ex);
        }
        finally {
            if (responseCopy != null) {
                try {
                    responseCopy.close();
                    responseCopy = null;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private void setIsConnected(boolean value) {
        this.isConnected = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            try {
                this.response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.disconnect(HangingRequestDisconnectReason.UserInitiated, null);
        }
    }

    public void disconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            try {
                this.response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.internalOnDisconnect(reason, exception);
        }
    }

    private void internalOnConnect() throws XMLStreamException, IOException, EWSHttpException {
        if (!this.isConnected()) {
            this.isConnected = true;
            if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponseHttpHeaders)) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, this.response);
            }
            int poolSize = 1;
            int maxPoolSize = 1;
            long keepAliveTime = 10L;
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(1);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, queue);
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HangingServiceRequestBase.this.parseResponses();
                }
            });
            threadPool.shutdown();
        }
    }

    private void internalOnDisconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            this.isConnected = false;
            for (IHangingRequestDisconnectHandler disconnect : this.onDisconnectList) {
                disconnect.hangingRequestDisconnectHandler(this, new HangingRequestDisconnectEventArgs(reason, exception));
            }
        }
    }

    @Override
    protected void readPreamble(EwsServiceXmlReader ewsXmlReader) throws Exception {
        try {
            ewsXmlReader.read(new XmlNodeType(7));
        }
        catch (XmlException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
        catch (ServiceXmlDeserializationException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
    }

    public static interface IHangingRequestDisconnectHandler {
        public void hangingRequestDisconnectHandler(Object var1, HangingRequestDisconnectEventArgs var2);
    }

    public static interface IHandleResponseObject {
        public void handleResponseObject(Object var1) throws ArgumentException;
    }
}

