/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.core.WebProxy;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.request.ByteArrayOSRequestEntity;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientWebRequest
extends HttpWebRequest {
    private HttpPost httpPost = null;
    private CloseableHttpResponse response = null;
    private final CloseableHttpClient httpClient;
    private final HttpClientContext httpContext;

    public HttpClientWebRequest(CloseableHttpClient httpClient, HttpClientContext httpContext) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
    }

    @Override
    public void close() throws IOException {
        if (this.response != null && this.response.getEntity() != null) {
            EntityUtils.consume((HttpEntity)this.response.getEntity());
        } else if (this.httpPost != null) {
            this.httpPost.releaseConnection();
        }
        this.httpPost = null;
    }

    @Override
    public void prepareConnection() {
        this.httpPost = new HttpPost(this.getUrl().toString());
        this.httpPost.addHeader("Content-type", this.getContentType());
        this.httpPost.addHeader("User-Agent", this.getUserAgent());
        this.httpPost.addHeader("Accept", this.getAccept());
        this.httpPost.addHeader("Keep-Alive", "300");
        this.httpPost.addHeader("Connection", "Keep-Alive");
        if (this.isAcceptGzipEncoding()) {
            this.httpPost.addHeader("Accept-Encoding", "gzip,deflate");
        }
        if (this.getHeaders() != null) {
            for (Map.Entry<String, String> httpHeader : this.getHeaders().entrySet()) {
                this.httpPost.addHeader(httpHeader.getKey(), httpHeader.getValue());
            }
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setAuthenticationEnabled(true).setConnectionRequestTimeout(this.getTimeout()).setConnectTimeout(this.getTimeout()).setRedirectsEnabled(this.isAllowAutoRedirect()).setSocketTimeout(this.getTimeout()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Basic")).setProxyPreferredAuthSchemes(Arrays.asList("NTLM", "Basic"));
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        WebProxy proxy = this.getProxy();
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            requestConfigBuilder.setProxy(proxyHost);
            if (proxy.hasCredentials()) {
                NTCredentials proxyCredentials = new NTCredentials(proxy.getCredentials().getUsername(), proxy.getCredentials().getPassword(), "", proxy.getCredentials().getDomain());
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)proxyCredentials);
            }
        }
        if (this.isAllowAuthentication() && this.getUsername() != null) {
            NTCredentials webServiceCredentials = new NTCredentials(this.getUsername(), this.getPassword(), "", this.getDomain());
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)webServiceCredentials);
        }
        this.httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.httpPost.setConfig(requestConfigBuilder.build());
    }

    @Override
    public InputStream getInputStream() throws EWSHttpException, IOException {
        this.throwIfResponseIsNull();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.response.getEntity().getContent());
        }
        catch (IOException e) {
            throw new EWSHttpException("Connection Error " + e);
        }
        return bufferedInputStream;
    }

    @Override
    public InputStream getErrorStream() throws EWSHttpException {
        this.throwIfResponseIsNull();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.response.getEntity().getContent());
        }
        catch (Exception e) {
            throw new EWSHttpException("Connection Error " + e);
        }
        return bufferedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws EWSHttpException {
        ByteArrayOutputStream os = null;
        this.throwIfRequestIsNull();
        os = new ByteArrayOutputStream();
        this.httpPost.setEntity((HttpEntity)new ByteArrayOSRequestEntity(os));
        return os;
    }

    @Override
    public Map<String, String> getResponseHeaders() throws EWSHttpException {
        Header[] hM;
        this.throwIfResponseIsNull();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : hM = this.response.getAllHeaders()) {
            if (header.getName().equals("Set-Cookie")) {
                String cookieValue = "";
                if (map.containsKey("Set-Cookie")) {
                    cookieValue = cookieValue + (String)map.get("Set-Cookie");
                    cookieValue = cookieValue + ",";
                }
                cookieValue = cookieValue + header.getValue();
                map.put("Set-Cookie", cookieValue);
                continue;
            }
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    @Override
    public String getResponseHeaderField(String headerName) throws EWSHttpException {
        this.throwIfResponseIsNull();
        Header hM = this.response.getFirstHeader(headerName);
        return hM != null ? hM.getValue() : null;
    }

    @Override
    public String getContentEncoding() throws EWSHttpException {
        this.throwIfResponseIsNull();
        return this.response.getFirstHeader("content-encoding") != null ? this.response.getFirstHeader("content-encoding").getValue() : null;
    }

    @Override
    public String getResponseContentType() throws EWSHttpException {
        this.throwIfResponseIsNull();
        return this.response.getFirstHeader("Content-type") != null ? this.response.getFirstHeader("Content-type").getValue() : null;
    }

    @Override
    public int executeRequest() throws EWSHttpException, IOException {
        this.throwIfRequestIsNull();
        this.response = this.httpClient.execute((HttpUriRequest)this.httpPost, (HttpContext)this.httpContext);
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public int getResponseCode() throws EWSHttpException {
        this.throwIfResponseIsNull();
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getResponseText() throws EWSHttpException {
        this.throwIfResponseIsNull();
        return this.response.getStatusLine().getReasonPhrase();
    }

    private void throwIfRequestIsNull() throws EWSHttpException {
        if (null == this.httpPost) {
            throw new EWSHttpException("Connection not established");
        }
    }

    private void throwIfResponseIsNull() throws EWSHttpException {
        if (null == this.response) {
            throw new EWSHttpException("Connection not established");
        }
    }

    @Override
    public Map<String, String> getRequestProperty() throws EWSHttpException {
        Header[] hM;
        this.throwIfRequestIsNull();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : hM = this.httpPost.getAllHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }
}

