/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.PlayOnPhoneResponse;
import microsoft.exchange.webservices.data.property.complex.ItemId;

public final class PlayOnPhoneRequest
extends SimpleServiceRequestBase<PlayOnPhoneResponse> {
    private ItemId itemId;
    private String dialString;

    public PlayOnPhoneRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    public String getXmlElementName() {
        return "PlayOnPhone";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.itemId.writeToXml(writer, XmlNamespace.Messages, "ItemId");
        writer.writeElementValue(XmlNamespace.Messages, "DialString", this.dialString);
    }

    @Override
    protected String getResponseXmlElementName() {
        return "PlayOnPhoneResponse";
    }

    @Override
    protected PlayOnPhoneResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        PlayOnPhoneResponse serviceResponse = new PlayOnPhoneResponse(this.getService());
        serviceResponse.loadFromXml(reader, "PlayOnPhoneResponse");
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    public PlayOnPhoneResponse execute() throws Exception {
        PlayOnPhoneResponse serviceResponse = (PlayOnPhoneResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    protected ItemId getItemId() {
        return this.itemId;
    }

    public void setItemId(ItemId itemId) {
        this.itemId = itemId;
    }

    protected String getDialString() {
        return this.dialString;
    }

    public void setDialString(String dialString) {
        this.dialString = dialString;
    }
}

