/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.property.complex.Attachment;

public final class DeleteAttachmentResponse
extends ServiceResponse {
    private Attachment attachment;

    public DeleteAttachmentResponse(Attachment attachment) {
        EwsUtilities.ewsAssert(attachment != null, "DeleteAttachmentResponse.ctor", "attachment is null");
        this.attachment = attachment;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws ServiceLocalException, Exception {
        super.readElementsFromXml(reader);
        reader.readStartElement(XmlNamespace.Messages, "RootItemId");
        String changeKey = reader.readAttributeValue("RootItemChangeKey");
        if (null != changeKey && !changeKey.isEmpty()) {
            this.attachment.getOwner().getRootItemId().setChangeKey(changeKey);
        }
        reader.readEndElement(XmlNamespace.Messages, "RootItemId");
    }

    public Attachment getAttachment() {
        return this.attachment;
    }
}

