/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.sync.ChangeType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.sync.Change;
import microsoft.exchange.webservices.data.sync.ChangeCollection;
import microsoft.exchange.webservices.data.sync.ItemChange;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class SyncResponse<TServiceObject extends ServiceObject, TChange extends Change>
extends ServiceResponse {
    private ChangeCollection<TChange> changes = new ChangeCollection();
    private PropertySet propertySet;

    protected SyncResponse(PropertySet propertySet) {
        this.propertySet = propertySet;
        EwsUtilities.ewsAssert(this.propertySet != null, "SyncResponse.ctor", "PropertySet should not be null");
    }

    protected abstract String getIncludesLastInRangeXmlElementName();

    protected abstract TChange createChangeInstance();

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws ServiceLocalException, Exception {
        this.changes.setSyncState(reader.readElementValue(XmlNamespace.Messages, "SyncState"));
        this.changes.setMoreChangesAvailable(reader.readElementValue(Boolean.class, XmlNamespace.Messages, this.getIncludesLastInRangeXmlElementName()) == false);
        reader.readStartElement(XmlNamespace.Messages, "Changes");
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TChange change = this.createChangeInstance();
                if (reader.getLocalName().equals("Create")) {
                    ((Change)change).setChangeType(ChangeType.Create);
                } else if (reader.getLocalName().equals("Update")) {
                    ((Change)change).setChangeType(ChangeType.Update);
                } else if (reader.getLocalName().equals("Delete")) {
                    ((Change)change).setChangeType(ChangeType.Delete);
                } else if (reader.getLocalName().equals("ReadFlagChange")) {
                    ((Change)change).setChangeType(ChangeType.ReadFlagChange);
                } else {
                    reader.skipCurrentElement();
                }
                if (change == null) continue;
                reader.read();
                reader.ensureCurrentNodeIsStartElement();
                if (((Change)change).getChangeType().equals((Object)ChangeType.Delete) || ((Change)change).getChangeType().equals((Object)ChangeType.ReadFlagChange)) {
                    ((Change)change).setId(((Change)change).createId());
                    ((Change)change).getId().loadFromXml(reader, ((Change)change).getId().getXmlElementName());
                    if (((Change)change).getChangeType().equals((Object)ChangeType.ReadFlagChange)) {
                        reader.read();
                        reader.ensureCurrentNodeIsStartElement();
                        ItemChange itemChange = null;
                        if (change instanceof ItemChange) {
                            itemChange = (ItemChange)change;
                        }
                        EwsUtilities.ewsAssert(itemChange != null, "SyncResponse.ReadElementsFromXml", "ReadFlagChange is only valid on ItemChange");
                        itemChange.setIsRead(reader.readElementValue(Boolean.class, XmlNamespace.Types, "IsRead"));
                    }
                } else {
                    ((Change)change).setServiceObject((ServiceObject)EwsUtilities.createEwsObjectFromXmlElementName(null, reader.getService(), reader.getLocalName()));
                    ((Change)change).getServiceObject().loadFromXml(reader, true, this.propertySet, this.getSummaryPropertiesOnly());
                }
                reader.readEndElementIfNecessary(XmlNamespace.Types, ((Change)change).getChangeType().toString());
                this.changes.add(change);
            } while (!reader.isEndElement(XmlNamespace.Messages, "Changes"));
        } else {
            reader.read();
        }
    }

    public ChangeCollection<TChange> getChanges() {
        return this.changes;
    }

    protected abstract boolean getSummaryPropertiesOnly();
}

