/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.Arrays;
import java.util.Date;
import microsoft.exchange.webservices.data.attribute.Attachable;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.core.enumeration.property.MeetingResponseType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.ResponseMessageType;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AppointmentType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.ICalendarActionProvider;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.response.AcceptMeetingInvitationMessage;
import microsoft.exchange.webservices.data.core.service.response.CancelMeetingMessage;
import microsoft.exchange.webservices.data.core.service.response.DeclineMeetingInvitationMessage;
import microsoft.exchange.webservices.data.core.service.response.ResponseMessage;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.CalendarActionResults;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.AppointmentOccurrenceId;
import microsoft.exchange.webservices.data.property.complex.AttendeeCollection;
import microsoft.exchange.webservices.data.property.complex.DeletedOccurrenceInfoCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemCollection;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.complex.OccurrenceInfo;
import microsoft.exchange.webservices.data.property.complex.OccurrenceInfoCollection;
import microsoft.exchange.webservices.data.property.complex.RecurringAppointmentMasterId;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;

@Attachable
@ServiceObjectDefinition(xmlElementName="CalendarItem")
public class Appointment
extends Item
implements ICalendarActionProvider {
    public Appointment(ExchangeService service) throws Exception {
        super(service);
    }

    public Appointment(ItemAttachment parentAttachment, boolean isNew) throws Exception {
        super(parentAttachment);
    }

    public static Appointment bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(Appointment.class, id, propertySet);
    }

    public static Appointment bind(ExchangeService service, ItemId id) throws Exception {
        return Appointment.bind(service, id, PropertySet.FirstClassProperties);
    }

    public static Appointment bindToOccurrence(ExchangeService service, ItemId recurringMasterId, int occurenceIndex) throws Exception {
        return Appointment.bindToOccurrence(service, recurringMasterId, occurenceIndex, PropertySet.FirstClassProperties);
    }

    public static Appointment bindToOccurrence(ExchangeService service, ItemId recurringMasterId, int occurenceIndex, PropertySet propertySet) throws Exception {
        AppointmentOccurrenceId occurenceId = new AppointmentOccurrenceId(recurringMasterId.getUniqueId(), occurenceIndex);
        return Appointment.bind(service, occurenceId, propertySet);
    }

    public static Appointment bindToRecurringMaster(ExchangeService service, ItemId occurrenceId) throws Exception {
        return Appointment.bindToRecurringMaster(service, occurrenceId, PropertySet.FirstClassProperties);
    }

    public static Appointment bindToRecurringMaster(ExchangeService service, ItemId occurrenceId, PropertySet propertySet) throws Exception {
        RecurringAppointmentMasterId recurringMasterId = new RecurringAppointmentMasterId(occurrenceId.getUniqueId());
        return Appointment.bind(service, recurringMasterId, propertySet);
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return AppointmentSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected boolean getIsCustomDateTimeScopingRequired() {
        return true;
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1 && !this.getService().getExchange2007CompatibilityMode() && (this.getPropertyBag().isPropertyUpdated(AppointmentSchema.Start) || this.getPropertyBag().isPropertyUpdated(AppointmentSchema.End) || this.getPropertyBag().isPropertyUpdated(AppointmentSchema.IsAllDayEvent) || this.getPropertyBag().isPropertyUpdated(AppointmentSchema.Recurrence))) {
            if (!this.getPropertyBag().contains(AppointmentSchema.StartTimeZone)) {
                throw new ServiceLocalException("StartTimeZone required when setting the Start, End, IsAllDayEvent, or Recurrence property.  You must load or assign this property before attempting to update the appointment.");
            }
            this.setStartTimeZone(this.getStartTimeZone());
        }
    }

    public ResponseMessage createReply(boolean replyAll) throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, replyAll ? ResponseMessageType.ReplyAll : ResponseMessageType.Reply);
    }

    public void reply(MessageBody bodyPrefix, boolean replyAll) throws Exception {
        ResponseMessage responseMessage = this.createReply(replyAll);
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.sendAndSaveCopy();
    }

    public ResponseMessage createForward() throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, ResponseMessageType.Forward);
    }

    public void forward(MessageBody bodyPrefix, EmailAddress ... toRecipients) throws Exception {
        if (null != toRecipients) {
            this.forward(bodyPrefix, Arrays.asList(toRecipients));
        }
    }

    public void forward(MessageBody bodyPrefix, Iterable<EmailAddress> toRecipients) throws Exception {
        ResponseMessage responseMessage = this.createForward();
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.getToRecipients().addEmailRange(toRecipients.iterator());
        responseMessage.sendAndSaveCopy();
    }

    public void save(WellKnownFolderName destinationFolderName, SendInvitationsMode sendInvitationsMode) throws Exception {
        this.internalCreate(new FolderId(destinationFolderName), null, sendInvitationsMode);
    }

    public void save(FolderId destinationFolderId, SendInvitationsMode sendInvitationsMode) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        this.internalCreate(destinationFolderId, null, sendInvitationsMode);
    }

    public void save(SendInvitationsMode sendInvitationsMode) throws Exception {
        this.internalCreate(null, null, sendInvitationsMode);
    }

    public void update(ConflictResolutionMode conflictResolutionMode, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws Exception {
        this.internalUpdate(null, conflictResolutionMode, null, sendInvitationsOrCancellationsMode);
    }

    public void delete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode) throws Exception {
        this.internalDelete(deleteMode, sendCancellationsMode, null);
    }

    @Override
    public AcceptMeetingInvitationMessage createAcceptMessage(boolean tentative) throws Exception {
        return new AcceptMeetingInvitationMessage(this, tentative);
    }

    public CancelMeetingMessage createCancelMeetingMessage() throws Exception {
        return new CancelMeetingMessage(this);
    }

    @Override
    public DeclineMeetingInvitationMessage createDeclineMessage() throws Exception {
        return new DeclineMeetingInvitationMessage(this);
    }

    @Override
    public CalendarActionResults accept(boolean sendResponse) throws Exception {
        return this.internalAccept(false, sendResponse);
    }

    @Override
    public CalendarActionResults acceptTentatively(boolean sendResponse) throws Exception {
        return this.internalAccept(true, sendResponse);
    }

    protected CalendarActionResults internalAccept(boolean tentative, boolean sendResponse) throws Exception {
        AcceptMeetingInvitationMessage accept = this.createAcceptMessage(tentative);
        if (sendResponse) {
            return accept.calendarSendAndSaveCopy();
        }
        return accept.calendarSave();
    }

    public CalendarActionResults cancelMeeting() throws Exception {
        return this.createCancelMeetingMessage().calendarSendAndSaveCopy();
    }

    public CalendarActionResults cancelMeeting(String cancellationMessageText) throws Exception {
        CancelMeetingMessage cancelMsg = this.createCancelMeetingMessage();
        cancelMsg.setBody(new MessageBody(cancellationMessageText));
        return cancelMsg.calendarSendAndSaveCopy();
    }

    @Override
    public CalendarActionResults decline(boolean sendResponse) throws Exception {
        DeclineMeetingInvitationMessage decline = this.createDeclineMessage();
        if (sendResponse) {
            return decline.calendarSendAndSaveCopy();
        }
        return decline.calendarSave();
    }

    @Override
    protected SendCancellationsMode getDefaultSendCancellationsMode() {
        return SendCancellationsMode.SendToAllAndSaveCopy;
    }

    @Override
    protected SendInvitationsMode getDefaultSendInvitationsMode() {
        return SendInvitationsMode.SendToAllAndSaveCopy;
    }

    @Override
    protected SendInvitationsOrCancellationsMode getDefaultSendInvitationsOrCancellationsMode() {
        return SendInvitationsOrCancellationsMode.SendToAllAndSaveCopy;
    }

    public Date getStart() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Start);
    }

    public void setStart(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.Start, value);
    }

    public Date getEnd() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.End);
    }

    public void setEnd(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.End, value);
    }

    public Date getOriginalStart() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.OriginalStart);
    }

    public Boolean getIsAllDayEvent() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsAllDayEvent);
    }

    public void setIsAllDayEvent(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.IsAllDayEvent, value);
    }

    public LegacyFreeBusyStatus getLegacyFreeBusyStatus() throws ServiceLocalException {
        return (LegacyFreeBusyStatus)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.LegacyFreeBusyStatus));
    }

    public void setLegacyFreeBusyStatus(LegacyFreeBusyStatus value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.LegacyFreeBusyStatus, (Object)value);
    }

    public String getLocation() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Location);
    }

    public void setLocation(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.Location, value);
    }

    public String getWhen() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.When);
    }

    public Boolean getIsMeeting() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsMeeting);
    }

    public Boolean getIsCancelled() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsCancelled);
    }

    public Boolean getIsRecurring() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsRecurring);
    }

    public Boolean getMeetingRequestWasSent() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MeetingRequestWasSent);
    }

    public Boolean getIsResponseRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsResponseRequested);
    }

    public void setIsResponseRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.IsResponseRequested, value);
    }

    public AppointmentType getAppointmentType() throws ServiceLocalException {
        return (AppointmentType)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentType));
    }

    public MeetingResponseType getMyResponseType() throws ServiceLocalException {
        return (MeetingResponseType)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MyResponseType));
    }

    public EmailAddress getOrganizer() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Organizer);
    }

    public AttendeeCollection getRequiredAttendees() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.RequiredAttendees);
    }

    public AttendeeCollection getOptionalAttendees() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.OptionalAttendees);
    }

    public AttendeeCollection getResources() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Resources);
    }

    public Integer getConflictingMeetingCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConflictingMeetingCount);
    }

    public Integer getAdjacentMeetingCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AdjacentMeetingCount);
    }

    public ItemCollection<Appointment> getConflictingMeetings() throws ServiceLocalException {
        return (ItemCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConflictingMeetings);
    }

    public ItemCollection<Appointment> getAdjacentMeetings() throws ServiceLocalException {
        return (ItemCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AdjacentMeetings);
    }

    public TimeSpan getDuration() throws ServiceLocalException {
        return (TimeSpan)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Duration);
    }

    public String getTimeZone() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.TimeZone);
    }

    public Date getAppointmentReplyTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentReplyTime);
    }

    public Integer getAppointmentSequenceNumber() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentSequenceNumber);
    }

    public Integer getAppointmentState() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentState);
    }

    public Recurrence getRecurrence() throws ServiceLocalException {
        return (Recurrence)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Recurrence);
    }

    public void setRecurrence(Recurrence value) throws Exception {
        if (value != null && value.isRegenerationPattern()) {
            throw new ServiceLocalException("Regeneration pattern can only be used with Task item.");
        }
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.Recurrence, value);
    }

    public OccurrenceInfo getFirstOccurrence() throws ServiceLocalException {
        return (OccurrenceInfo)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.FirstOccurrence);
    }

    public OccurrenceInfo getLastOccurrence() throws ServiceLocalException {
        return (OccurrenceInfo)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.LastOccurrence);
    }

    public OccurrenceInfoCollection getModifiedOccurrences() throws ServiceLocalException {
        return (OccurrenceInfoCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ModifiedOccurrences);
    }

    public DeletedOccurrenceInfoCollection getDeletedOccurrences() throws ServiceLocalException {
        return (DeletedOccurrenceInfoCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.DeletedOccurrences);
    }

    public TimeZoneDefinition getStartTimeZone() throws ServiceLocalException {
        return (TimeZoneDefinition)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.StartTimeZone);
    }

    public void setStartTimeZone(TimeZoneDefinition value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.StartTimeZone, value);
    }

    public TimeZoneDefinition getEndTimeZone() throws ServiceLocalException {
        return (TimeZoneDefinition)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.EndTimeZone);
    }

    public void setEndTimeZone(TimeZoneDefinition value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.EndTimeZone, value);
    }

    public Integer getConferenceType() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConferenceType);
    }

    public void setConferenceType(Integer value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.ConferenceType, value);
    }

    public Boolean getAllowNewTimeProposal() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AllowNewTimeProposal);
    }

    public void setAllowNewTimeProposal(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.AllowNewTimeProposal, value);
    }

    public Boolean getIsOnlineMeeting() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsOnlineMeeting);
    }

    public void setIsOnlineMeeting(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.IsOnlineMeeting, value);
    }

    public String getMeetingWorkspaceUrl() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MeetingWorkspaceUrl);
    }

    public void setMeetingWorkspaceUrl(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.MeetingWorkspaceUrl, value);
    }

    public String getNetShowUrl() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.NetShowUrl);
    }

    public void setNetShowUrl(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.NetShowUrl, value);
    }

    public String getICalUid() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ICalUid);
    }

    public void setICalUid(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(AppointmentSchema.ICalUid, value);
    }

    public Date getICalRecurrenceId() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ICalRecurrenceId);
    }

    public Date getICalDateTimeStamp() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ICalDateTimeStamp);
    }
}

