/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.response;

import java.util.List;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.exception.misc.InvalidOperationException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.item.PostItem;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.core.service.schema.PostReplySchema;
import microsoft.exchange.webservices.data.core.service.schema.ResponseObjectSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.MessageBody;

@ServiceObjectDefinition(xmlElementName="PostReplyItem", returnedByServer=false)
public final class PostReply
extends ServiceObject {
    private Item referenceItem;

    public PostReply(Item referenceItem) throws Exception {
        super(referenceItem.getService());
        referenceItem.throwIfThisIsNew();
        this.referenceItem = referenceItem;
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return PostReplySchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected PostItem internalCreate(FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        ((ItemId)this.getObjectFromPropertyDefinition(ResponseObjectSchema.ReferenceItemId)).assign(this.referenceItem.getId());
        List<Item> items = this.getService().internalCreateResponseObject(this, parentFolderId, messageDisposition);
        PostItem postItem = EwsUtilities.findFirstItemOfType(PostItem.class, items);
        EwsUtilities.ewsAssert(postItem != null, "PostReply.InternalCreate", "postItem is null. The CreateItem call did not return the expected PostItem.");
        return postItem;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) throws InvalidOperationException {
        throw new InvalidOperationException("Loading this type of object is not supported.");
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws InvalidOperationException {
        throw new InvalidOperationException("Deleting this type of object isn't authorized.");
    }

    public PostItem save() throws Exception {
        return this.internalCreate(null, null);
    }

    public PostItem save(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.internalCreate(destinationFolderId, null);
    }

    public PostItem save(WellKnownFolderName destinationFolderName) throws Exception {
        return this.internalCreate(new FolderId(destinationFolderName), null);
    }

    public String getSubject() throws Exception {
        return (String)this.getObjectFromPropertyDefinition(EmailMessageSchema.Subject);
    }

    public void setSubject(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Subject, value);
    }

    public MessageBody getBody() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ItemSchema.Body);
    }

    public void setBody(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Body, value);
    }

    public MessageBody getBodyPrefix() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix);
    }

    public void setBodyPrefix(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix, value);
    }
}

